# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .conversation_message import ConversationMessage


class ConversationResult(UniversalBaseModel):
    """
    Model representing the conversation result from task/AOP execution.
    """

    conversation_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the conversation asset
    """

    created_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    ISO timestamp when conversation was created
    """

    last_assistant_message: typing.Optional[ConversationMessage] = pydantic.Field(default=None)
    """
    The last message from the assistant
    """

    messages: typing.Optional[typing.List[ConversationMessage]] = pydantic.Field(default=None)
    """
    Complete list of messages in the conversation
    """

    messages_source: str = pydantic.Field()
    """
    Source of the messages (e.g., 'checkpoints')
    """

    metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Additional conversation metadata
    """

    num_messages: int = pydantic.Field()
    """
    Total number of messages in the conversation
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    Title of the conversation
    """

    updated_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    ISO timestamp when conversation was last updated
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
