# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class CreateProjectResponseOut(UniversalBaseModel):
    """
    Response model for project creation.
    """

    asset_id: str = pydantic.Field()
    """
    ID of the created project asset
    """

    custom_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Custom metadata associated with the project
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the project
    """

    project_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Type of the project
    """

    tags: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Tags associated with the project
    """

    title: str = pydantic.Field()
    """
    Title of the created project
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
