# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class DimensionProperties(UniversalBaseModel):
    """
    Properties for a row or column dimension in the spreadsheet.
    """

    hidden_by_filter: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="hiddenByFilter")] = (
        pydantic.Field(default=None)
    )
    """
    True if this row/column is hidden due to a filter being applied. Do not modify directly - managed by filter operations
    """

    hidden_by_user: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="hiddenByUser")] = (
        pydantic.Field(default=None)
    )
    """
    True if the user explicitly hid this row/column (e.g., right-click > Hide). Set to False to unhide
    """

    resized_by_user: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="resizedByUser")] = (
        pydantic.Field(default=None)
    )
    """
    True if the user manually resized this dimension (e.g., dragged column border to resize)
    """

    size: typing.Optional[int] = pydantic.Field(default=None)
    """
    Size in pixels. For columns, this is the width. For rows, this is the height. Default: 100px for columns, 21px for rows
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
