# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Optional

from .segment import Segment
from .._models import BaseModel

__all__ = ["Chunk"]


class Chunk(BaseModel):
    chunk_length: int
    """The total number of tokens in the `embed` field of the chunk.

    Calculated by the `tokenizer`.
    """

    segments: List[Segment]
    """
    Collection of document segments that form this chunk. When
    `target_chunk_length` > 0, contains the maximum number of segments that fit
    within that length (segments remain intact). Otherwise, contains exactly one
    segment.
    """

    chunk_id: Optional[str] = None
    """The unique identifier for the chunk."""

    content: Optional[str] = None
    """The content of the chunk.

    This is the text that is generated by combining the `content` field from each
    segment. Can be used provided as context to the LLM.
    """

    embed: Optional[str] = None
    """Suggested text to be embedded for the chunk.

    This text is generated by combining the `embed` field from each segment.
    """
