# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Optional
from typing_extensions import Literal

from .cell import Cell
from .._models import BaseModel
from .ocr_result import OcrResult
from .bounding_box import BoundingBox

__all__ = ["Segment"]


class Segment(BaseModel):
    bbox: BoundingBox
    """Bounding box for an item. It is used for segments and OCR results."""

    page_height: float
    """Height of the page/sheet containing the segment."""

    page_number: int
    """Page number/Sheet number of the segment."""

    page_width: float
    """Width of the page/sheet containing the segment."""

    segment_id: str
    """Unique identifier for the segment."""

    segment_type: Literal[
        "Caption",
        "Footnote",
        "Formula",
        "FormRegion",
        "GraphicalItem",
        "Legend",
        "LineNumber",
        "ListItem",
        "Page",
        "PageFooter",
        "PageHeader",
        "PageNumber",
        "Picture",
        "Table",
        "Text",
        "Title",
        "Unknown",
        "SectionHeader",
    ]
    """All the possible types for a segment."""

    confidence: Optional[float] = None
    """Confidence score of the layout analysis model"""

    content: Optional[str] = None
    """
    Content of the segment, will be either HTML or Markdown, depending on format
    chosen.
    """

    description: Optional[str] = None
    """Description of the segment, generated by the LLM."""

    embed: Optional[str] = None
    """Embeddable content of the segment."""

    image: Optional[str] = None
    """Presigned URL to the image of the segment."""

    ocr: Optional[List[OcrResult]] = None
    """OCR results for the segment."""

    segment_length: Optional[int] = None
    """Length of the segment in tokens."""

    ss_cells: Optional[List[Cell]] = None
    """Cells of the segment. Only used for Spreadsheets."""

    ss_header_bbox: Optional[BoundingBox] = None
    """Bounding box of the header of the segment, if found.

    Only used for Spreadsheets.
    """

    ss_header_ocr: Optional[List[OcrResult]] = None
    """OCR results of the header of the segment, if found. Only used for Spreadsheets."""

    ss_header_range: Optional[str] = None
    """
    Header range of the segment, if found. The header can have overlap with the
    `segment.range` if the table contains the header, if the header is located in a
    different sheet, the header range will have no overlap with the `segment.range`.
    Only used for Spreadsheets.
    """

    ss_header_text: Optional[str] = None
    """Text content of the header of the segment, if found.

    Only used for Spreadsheets.
    """

    ss_range: Optional[str] = None
    """Range of the segment in Excel notation (e.g., A1:B5).

    Only used for Spreadsheets.
    """

    ss_sheet_name: Optional[str] = None
    """Name of the sheet containing the segment. Only used for Spreadsheets."""

    text: Optional[str] = None
    """Text content of the segment. Calculated by the OCR results."""
