<p align="center">
  <img width="350" src="https://github.com/PlanetHunters/watson/blob/main/images/watson.png?raw=true">
</p>

<b>WATSON</b> (<b>V</b>isual <b>V</b>etting and <b>A</b>nalysis of <b>T</b>ransits from <b>S</b>pace Observatio<b>N</b>s) is a lightweight software package
that enables a comfortable visual vetting of a transiting signal candidate from Kepler, K2 and TESS missions.

Any transiting candidate signal found in a space-based mission could have been potentially generated by 
different astrophysical sources or even by instrumental artifacts induced into a target's light curve. 
To rule-out these scenarios, the Science Processing Operation Center (SPOC) of the NASA implemented 
the Data Validation (DV) Reports, which are showing different metrics to qualify 
or discard an analyzed candidate. These scenarios are mainly 

* Transit shape model fit
* Odd-even transits checks, 
* Weak secondary events
* Centroids shifts
* Optical ghost effects
* Transit source offsets
* Rolling band contamination histograms

WATSON is also implementing similar but more simplified checks for all of those scenarios 
(SPOC fits transits models and we just compute the SNR of the possible candidate signal) except the 
rolling band contamination. In addition, we included a new check comparing the transit SNRs in the different 
available cadences and also all the single-transit plots computed with the official pipeline aperture and a 
smaller one. With all of these data, we compute metrics that might alert the scientist about problematic 
signals not complying with any of the thresholds.

For more information check the docs: [https://dearwatson.readthedocs.io](https://dearwatson.readthedocs.io)

## Code example
Let's say that you found a new candidate in the TOI-175 with a period of 1.04 days (this is a known false positive
from the TESS mission). You could run WATSON easily with the next code chunk:
```
period = 1.0491800670761966
epoch = 1354.7155898963902
duration_mins = 54
depth_ppts = 0.158
sectors = 'all'
rp_rstar = 0.01205
a_rstar = 9 
ra = 124.531756290083
dec = -68.3129998725044
# We need to mask the previous candidates to ensure they don't add noise to the analysis
known_transits_mask = [{'P': 3.6906682312153136, 'T0': 1356.20298505518, 'D': 56}, 
                 {'P': 2.2531273092040185, 'T0': 1354.9020729263193, 'D': 45}, 
                 {'P': 7.450690528437917, 'T0': 1355.2917484673462, 'D': 69}]
your_execution_dir = os.getcwd() 
object_dir = your_execution_dir + '/results'
if not os.path.exists(object_dir):
    os.mkdir(object_dir)
Watson(object_dir).vetting("TIC 307210830", period, epoch, duration_mins, depth_ppts, sectors, rp_rstar,
                                       a_rstar=a_rstar, cadence=120,
                                       cpus=os.cpu_count() // 2,
                                       transits_list=None, ra=ra,
                                       dec=dec, clean=True, transits_mask=known_transits_mask)
```

This same example is done in one of our tutorials. Go and check it out!: [TOI-175 tutorial](https://dearwatson.readthedocs.io/en/latest/TOI-175/TOI-175-vetting.html)
