"""changes for feedback

Revision ID: 5e011849ea76
Revises: 161f8829d93f
Create Date: 2025-09-11 15:58:57.378056

"""

from typing import Sequence

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision: str = "5e011849ea76"
down_revision: str | Sequence[str] | None = "161f8829d93f"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_message_feedback_contact_id"), table_name="message_feedback")
    op.drop_index(op.f("ix_message_feedback_conversation_id"), table_name="message_feedback")
    op.drop_index(op.f("ix_message_feedback_created_at"), table_name="message_feedback")
    op.drop_index(op.f("ix_message_feedback_feedback_type"), table_name="message_feedback")
    op.drop_index(op.f("ix_message_feedback_message_id"), table_name="message_feedback")
    op.drop_index(op.f("ix_message_feedback_metadata_gin"), table_name="message_feedback", postgresql_using="gin")
    op.drop_index(op.f("ix_message_feedback_review_status"), table_name="message_feedback")
    op.drop_index(op.f("ix_message_feedback_reviewed_at"), table_name="message_feedback")
    op.drop_index(op.f("message_feedback_contact_id_idx"), table_name="message_feedback")
    op.drop_index(op.f("message_feedback_conversation_id_idx"), table_name="message_feedback")
    op.drop_index(op.f("message_feedback_id_idx"), table_name="message_feedback")
    op.drop_index(op.f("message_feedback_message_id_idx"), table_name="message_feedback")
    op.drop_table("message_feedback")
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "message_feedback",
        sa.Column("message_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("conversation_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("contact_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feedback_type", postgresql.ENUM("THUMBS_DOWN", "THUMBS_UP", name="feedbacktype"), autoincrement=False, nullable=False),
        sa.Column("user_query", sa.TEXT(), autoincrement=False, nullable=False),
        sa.Column("message_content", sa.TEXT(), autoincrement=False, nullable=False),
        sa.Column("user_feedback", sa.TEXT(), autoincrement=False, nullable=True),
        sa.Column("llm_synthesized_correction", sa.TEXT(), autoincrement=False, nullable=True),
        sa.Column("review_status", postgresql.ENUM("PENDING", "REVIEWED", "CORRECTED", name="reviewstatus"), autoincrement=False, nullable=False),
        sa.Column("reviewed_by", sa.VARCHAR(length=255), autoincrement=False, nullable=True),
        sa.Column("reviewed_at", postgresql.TIMESTAMP(), autoincrement=False, nullable=True),
        sa.Column("metadata_json", postgresql.JSONB(astext_type=sa.Text()), autoincrement=False, nullable=True),
        sa.Column("id", sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column("created_at", postgresql.TIMESTAMP(timezone=True), server_default=sa.text("now()"), autoincrement=False, nullable=False),
        sa.Column("updated_at", postgresql.TIMESTAMP(timezone=True), server_default=sa.text("now()"), autoincrement=False, nullable=False),
        sa.Column("deleted_at", postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
        sa.ForeignKeyConstraint(["contact_id"], ["contact.id"], name=op.f("message_feedback_contact_id_fkey")),
        sa.ForeignKeyConstraint(["conversation_id"], ["conversation.id"], name=op.f("message_feedback_conversation_id_fkey")),
        sa.ForeignKeyConstraint(["message_id"], ["conversation_message.id"], name=op.f("message_feedback_message_id_fkey")),
        sa.PrimaryKeyConstraint("id", name=op.f("message_feedback_pkey")),
    )
    op.create_index(op.f("message_feedback_message_id_idx"), "message_feedback", ["message_id"], unique=False)
    op.create_index(op.f("message_feedback_id_idx"), "message_feedback", ["id"], unique=False)
    op.create_index(op.f("message_feedback_conversation_id_idx"), "message_feedback", ["conversation_id"], unique=False)
    op.create_index(op.f("message_feedback_contact_id_idx"), "message_feedback", ["contact_id"], unique=False)
    op.create_index(op.f("ix_message_feedback_reviewed_at"), "message_feedback", ["reviewed_at"], unique=False)
    op.create_index(op.f("ix_message_feedback_review_status"), "message_feedback", ["review_status"], unique=False)
    op.create_index(op.f("ix_message_feedback_metadata_gin"), "message_feedback", ["metadata_json"], unique=False, postgresql_using="gin")
    op.create_index(op.f("ix_message_feedback_message_id"), "message_feedback", ["message_id"], unique=False)
    op.create_index(op.f("ix_message_feedback_feedback_type"), "message_feedback", ["feedback_type"], unique=False)
    op.create_index(op.f("ix_message_feedback_created_at"), "message_feedback", ["created_at"], unique=False)
    op.create_index(op.f("ix_message_feedback_conversation_id"), "message_feedback", ["conversation_id"], unique=False)
    op.create_index(op.f("ix_message_feedback_contact_id"), "message_feedback", ["contact_id"], unique=False)
    # ### end Alembic commands ###
