"""added publish status to Document

Revision ID: 6eb70e848451
Revises: bbc1955191e6
Create Date: 2025-09-26 11:15:57.436553

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '6eb70e848451'
down_revision: Union[str, Sequence[str], None] = 'bbc1955191e6'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('document', sa.Column('publish_status', sa.String(length=50), nullable=False))
    op.drop_constraint(op.f('uq_document_title'), 'document', type_='unique')
    op.create_index(op.f('document_publish_status_idx'), 'document', ['publish_status'], unique=False)
    op.create_unique_constraint('uq_document_title_version', 'document', ['title', 'version'])
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint('uq_document_title_version', 'document', type_='unique')
    op.drop_index(op.f('document_publish_status_idx'), table_name='document')
    op.create_unique_constraint(op.f('uq_document_title'), 'document', ['title'], postgresql_nulls_not_distinct=False)
    op.drop_column('document', 'publish_status')
    # ### end Alembic commands ###
