"""Drop unique (title, version) on document

Revision ID: f8b0ea2e743c
Revises: 6eb70e848451
Create Date: 2025-09-26 12:40:09.365217

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'f8b0ea2e743c'
down_revision: Union[str, Sequence[str], None] = '6eb70e848451'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('uq_document_title_version'), 'document', type_='unique')
    op.alter_column('source', 'name',
               existing_type=sa.VARCHAR(length=200),
               type_=sa.Enum('USER_ADDED', 'CONFLUENCE', 'GRID', 'CRM', name='sourcename', native_enum=False),
               existing_nullable=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('source', 'name',
               existing_type=sa.Enum('USER_ADDED', 'CONFLUENCE', 'GRID', 'CRM', name='sourcename', native_enum=False),
               type_=sa.VARCHAR(length=200),
               existing_nullable=False)
    op.create_unique_constraint(op.f('uq_document_title_version'), 'document', ['title', 'version'], postgresql_nulls_not_distinct=False)
    # ### end Alembic commands ###
