"""added s3_bucket and s3_dir in Source table

Revision ID: 7d1cb343a63f
Revises: ac85b606d8a4
Create Date: 2025-10-03 12:04:15.507431

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '7d1cb343a63f'
down_revision: Union[str, Sequence[str], None] = 'ac85b606d8a4'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('source', sa.Column('s3_bucket', sa.String(length=255), nullable=True))
    op.add_column('source', sa.Column('s3_directory', sa.String(length=2048), nullable=True))
    op.alter_column('source', 'name',
               existing_type=sa.VARCHAR(length=10),
               type_=sa.Enum('USER_ADDED', 'S3', 'EVENTS_AND_DESTINATIONS', 'SHAREPOINT', name='sourcename', native_enum=False),
               existing_nullable=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('source', 'name',
               existing_type=sa.Enum('USER_ADDED', 'S3', 'EVENTS_AND_DESTINATIONS', 'SHAREPOINT', name='sourcename', native_enum=False),
               type_=sa.VARCHAR(length=10),
               existing_nullable=False)
    op.drop_column('source', 's3_directory')
    op.drop_column('source', 's3_bucket')
    # ### end Alembic commands ###
