"""added travel advisory enum

Revision ID: 5cfa0c462948
Revises: f9c750ec2a0b
Create Date: 2025-10-07 17:22:46.670468

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '5cfa0c462948'
down_revision: Union[str, Sequence[str], None] = 'f9c750ec2a0b'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('source', 'type',
               existing_type=sa.VARCHAR(length=11),
               type_=sa.Enum('S3', 'SHARE_POINT', 'GRID', 'CRM', 'CONFLUENCE', 'CUSTOM', 'TRAVEL_ADVISORY', name='sourcename', native_enum=False),
               existing_nullable=True)
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('source', 'type',
               existing_type=sa.Enum('S3', 'SHARE_POINT', 'GRID', 'CRM', 'CONFLUENCE', 'CUSTOM', 'TRAVEL_ADVISORY', name='sourcename', native_enum=False),
               type_=sa.VARCHAR(length=11),
               existing_nullable=True)
    # ### end Alembic commands ###
