"""Added Destination Report and event sources

Revision ID: c91eb8e38cc7
Revises: 5cfa0c462948
Create Date: 2025-10-08 13:04:14.325976

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'c91eb8e38cc7'
down_revision: Union[str, Sequence[str], None] = '5cfa0c462948'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('source', 'type',
               existing_type=sa.VARCHAR(length=15),
               type_=sa.Enum('S3', 'SHARE_POINT', 'GRID', 'GRID_DESTINATION_REPORT', 'GRID_EVENT_REPORT', 'CRM', 'CONFLUENCE', 'CUSTOM', 'TRAVEL_ADVISORY', name='sourcename', native_enum=False),
               existing_nullable=True)
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('source', 'type',
               existing_type=sa.Enum('S3', 'SHARE_POINT', 'GRID', 'GRID_DESTINATION_REPORT', 'GRID_EVENT_REPORT', 'CRM', 'CONFLUENCE', 'CUSTOM', 'TRAVEL_ADVISORY', name='sourcename', native_enum=False),
               type_=sa.VARCHAR(length=15),
               existing_nullable=True)
    # ### end Alembic commands ###
