"""added AgentCollectionAccess table

Revision ID: ff3be2c4311f
Revises: 919d07a93f83
Create Date: 2025-10-27 13:31:19.882851

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'ff3be2c4311f'
down_revision: Union[str, Sequence[str], None] = '919d07a93f83'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('agent_collection_access',
    sa.Column('agent_id', sa.Integer(), nullable=False),
    sa.Column('collection_id', sa.Integer(), nullable=False),
    sa.Column('access_granted_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
    sa.ForeignKeyConstraint(['agent_id'], ['agent.id'], name=op.f('agent_collection_access_agent_id_fkey'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['collection_id'], ['collection.id'], name=op.f('agent_collection_access_collection_id_fkey'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name=op.f('agent_collection_access_pkey')),
    sa.UniqueConstraint('agent_id', 'collection_id', name='uq_agent_collection')
    )
    op.create_index(op.f('agent_collection_access_agent_id_idx'), 'agent_collection_access', ['agent_id'], unique=False)
    op.create_index(op.f('agent_collection_access_collection_id_idx'), 'agent_collection_access', ['collection_id'], unique=False)
    op.create_index(op.f('agent_collection_access_id_idx'), 'agent_collection_access', ['id'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('agent_collection_access_id_idx'), table_name='agent_collection_access')
    op.drop_index(op.f('agent_collection_access_collection_id_idx'), table_name='agent_collection_access')
    op.drop_index(op.f('agent_collection_access_agent_id_idx'), table_name='agent_collection_access')
    op.drop_table('agent_collection_access')
    # ### end Alembic commands ###
