"""removed collection from source integration config should be used

Revision ID: bf5c2ce928e3
Revises: cc27b20a106e
Create Date: 2025-11-03 16:53:03.130091

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.exc import ProgrammingError


# revision identifiers, used by Alembic.
revision: str = 'bf5c2ce928e3'
down_revision: Union[str, Sequence[str], None] = 'cc27b20a106e'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    # Drop index if it exists
    try:
        op.drop_index(op.f('source_collection_id_idx'), table_name='source')
    except ProgrammingError:
        pass  # Index doesn't exist, that's okay
    
    # Drop constraint if it exists
    try:
        op.drop_constraint(op.f('source_collection_id_fkey'), 'source', type_='foreignkey')
    except ProgrammingError:
        pass  # Constraint doesn't exist, that's okay
    
    # Drop column if it exists
    try:
        op.drop_column('source', 'collection_id')
    except ProgrammingError:
        pass  # Column doesn't exist, that's okay
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('source', sa.Column('collection_id', sa.INTEGER(), autoincrement=False, nullable=False))
    op.create_foreign_key(op.f('source_collection_id_fkey'), 'source', 'collection', ['collection_id'], ['id'])
    op.create_index(op.f('source_collection_id_idx'), 'source', ['collection_id'], unique=False)
    # ### end Alembic commands ###
