"""Simplified feedback

Revision ID: 3d37806383a2
Revises: b9663951b5c1
Create Date: 2025-11-12 17:49:28.464920

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '3d37806383a2'
down_revision: Union[str, Sequence[str], None] = 'b9663951b5c1'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('feedback_chunk_id_idx'), table_name='feedback')
    op.drop_constraint(op.f('feedback_chunk_id_fkey'), 'feedback', type_='foreignkey')
    op.drop_column('feedback', 'query')
    op.drop_column('feedback', 'provided_response')
    op.drop_column('feedback', 'chunk_id')
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('feedback', sa.Column('chunk_id', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('feedback', sa.Column('provided_response', sa.TEXT(), autoincrement=False, nullable=True))
    op.add_column('feedback', sa.Column('query', sa.TEXT(), autoincrement=False, nullable=True))
    op.create_foreign_key(op.f('feedback_chunk_id_fkey'), 'feedback', 'chunk', ['chunk_id'], ['id'])
    op.create_index(op.f('feedback_chunk_id_idx'), 'feedback', ['chunk_id'], unique=False)
    # ### end Alembic commands ###
