"""Agent and profile Entity changes

Revision ID: a3bc4e4c08a0
Revises: 2c62317520f9
Create Date: 2025-11-17 12:59:15.991806

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision: str = 'a3bc4e4c08a0'
down_revision: Union[str, Sequence[str], None] = '2c62317520f9'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('agent_profile_version',
    sa.Column('agent_profile_id', sa.Integer(), nullable=False),
    sa.Column('version', sa.Integer(), nullable=False),
    sa.Column('status', sa.Enum('ACTIVE', 'PREVIEW', 'ARCHIVED', name='agentprofileversionstatus'), nullable=False),
    sa.Column('prompt', sa.Text(), nullable=False),
    sa.Column('functions_enabled', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
    sa.ForeignKeyConstraint(['agent_profile_id'], ['agent_profile.id'], name=op.f('agent_profile_version_agent_profile_id_fkey'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name=op.f('agent_profile_version_pkey')),
    sa.UniqueConstraint('agent_profile_id', 'version', name='uq_agent_profile_version_number')
    )
    op.create_index(op.f('agent_profile_version_agent_profile_id_idx'), 'agent_profile_version', ['agent_profile_id'], unique=False)
    op.create_index(op.f('agent_profile_version_id_idx'), 'agent_profile_version', ['id'], unique=False)
    op.create_index('ix_agent_profile_only_one_active', 'agent_profile_version', ['agent_profile_id'], unique=True, postgresql_where=sa.text("status = 'ACTIVE'"))
    op.create_index('ix_agent_profile_only_one_preview', 'agent_profile_version', ['agent_profile_id'], unique=True, postgresql_where=sa.text("status = 'PREVIEW'"))
    op.execute("CREATE TYPE agent_type AS ENUM ('ORCHESTRATOR_AGENT', 'DOMAIN_AGENT', 'UTILITY_AGENT', 'SUMMARIZER_AGENT')")
    op.add_column('agent', sa.Column('type', sa.Enum('ORCHESTRATOR_AGENT', 'DOMAIN_AGENT', 'UTILITY_AGENT', 'SUMMARIZER_AGENT', name='agent_type', create_type=False), nullable=True))
    op.add_column('agent', sa.Column('default_prompt', sa.Text(), nullable=True))
    op.add_column('agent', sa.Column('functions', postgresql.JSONB(astext_type=sa.Text()), nullable=True))
    op.drop_column('agent_collection_access', 'access_granted_at')
    op.add_column(
    'agent_profile',
    sa.Column('is_enabled', sa.Boolean(), nullable=True)
    )
    op.execute("UPDATE agent_profile SET is_enabled = TRUE")
    op.alter_column('agent_profile', 'is_enabled', nullable=False)
    op.create_unique_constraint('uq_agent_profile_binding', 'agent_profile', ['agent_id', 'profile_id'])
    op.drop_column('agent_profile', 'prompt')
    op.drop_column('agent_profile', 'version')
    op.drop_column('agent_profile', 'status')
    op.drop_column('agent_profile', 'is_default')
    op.drop_column('profile_collection_access', 'access_granted_at')
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('profile_collection_access', sa.Column('access_granted_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text('now()'), autoincrement=False, nullable=True))
    op.add_column('agent_profile', sa.Column('is_default', sa.BOOLEAN(), autoincrement=False, nullable=False))
    op.add_column('agent_profile', sa.Column('status', postgresql.ENUM('ACTIVE', 'INACTIVE', 'PREVIEW', name='agent_profile_status'), autoincrement=False, nullable=False))
    op.add_column('agent_profile', sa.Column('version', sa.INTEGER(), autoincrement=False, nullable=False))
    op.add_column('agent_profile', sa.Column('prompt', sa.TEXT(), autoincrement=False, nullable=True))
    op.drop_constraint('uq_agent_profile_binding', 'agent_profile', type_='unique')
    op.drop_column('agent_profile', 'is_enabled')
    op.add_column('agent_collection_access', sa.Column('access_granted_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text('now()'), autoincrement=False, nullable=True))
    op.drop_column('agent', 'functions')
    op.drop_column('agent', 'default_prompt')
    op.drop_column('agent', 'type')
    op.drop_index('ix_agent_profile_only_one_preview', table_name='agent_profile_version', postgresql_where=sa.text("status = 'PREVIEW'"))
    op.drop_index('ix_agent_profile_only_one_active', table_name='agent_profile_version', postgresql_where=sa.text("status = 'ACTIVE'"))
    op.drop_index(op.f('agent_profile_version_id_idx'), table_name='agent_profile_version')
    op.drop_index(op.f('agent_profile_version_agent_profile_id_idx'), table_name='agent_profile_version')
    op.drop_table('agent_profile_version')
    # ### end Alembic commands ###
