"""AgentProfile contact  Entity changes

Revision ID: df5b1cdc2c36
Revises: a3bc4e4c08a0
Create Date: 2025-11-17 13:25:51.561137

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'df5b1cdc2c36'
down_revision: Union[str, Sequence[str], None] = 'a3bc4e4c08a0'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('agent_profile', sa.Column('created_by_contact_id', sa.Integer(), nullable=True))
    op.create_foreign_key(op.f('agent_profile_created_by_contact_id_fkey'), 'agent_profile', 'contact', ['created_by_contact_id'], ['id'])
    op.add_column('agent_profile_version', sa.Column('modified_by_contact_id', sa.Integer(), nullable=True))
    op.add_column('agent_profile_version', sa.Column('published_by_contact_id', sa.Integer(), nullable=True))
    op.create_foreign_key(op.f('agent_profile_version_published_by_contact_id_fkey'), 'agent_profile_version', 'contact', ['published_by_contact_id'], ['id'])
    op.create_foreign_key(op.f('agent_profile_version_modified_by_contact_id_fkey'), 'agent_profile_version', 'contact', ['modified_by_contact_id'], ['id'])
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('agent_profile_version_modified_by_contact_id_fkey'), 'agent_profile_version', type_='foreignkey')
    op.drop_constraint(op.f('agent_profile_version_published_by_contact_id_fkey'), 'agent_profile_version', type_='foreignkey')
    op.drop_column('agent_profile_version', 'published_by_contact_id')
    op.drop_column('agent_profile_version', 'modified_by_contact_id')
    op.drop_constraint(op.f('agent_profile_created_by_contact_id_fkey'), 'agent_profile', type_='foreignkey')
    op.drop_column('agent_profile', 'created_by_contact_id')
    # ### end Alembic commands ###
