
# DO NOT EDIT THIS FILE -- AUTOGENERATED BY PANTS
# Target: integrate_ai:dist

from setuptools import setup

setup(**{
    'author': 'integrate.ai',
    'classifiers': [
        'Programming Language :: Python :: 3',
    ],
    'description': 'integrate.ai',
    'entry_points': {
        'console_scripts': [
            'iai = integrate_ai.cli:main',
        ],
    },
    'install_requires': (
        'click==8.1.8',
        'docker==7.1.0',
        'pyjwt>=2.4.0',
        'requests<3.0.0,>=2.32.2',
        'rich<14.0.0,>=13.3.4',
        'typer<0.8.0,>=0.7.0',
    ),
    'license': 'Copyright (C) 2022 integrate.ai, Inc. All rights reserved.',
    'long_description': """# integrate.ai Command Line Interface

A CLI that enables users to interact with integrate.ai's software.

This tool allows users to manage client and sdk packages. Use the integate.ai sdk to seamlessly integrate federated learning and analytics workflows directly into your product.

## Installation

integrate-ai requires `Python >= 3.8`

```
pip install integrate-ai
```

## Quick Start

Create a new IAI token through the integrate.ai UI.

### Install integrate-ai-sdk

```
iai sdk install --token <IAI_TOKEN> 
```

### Pull integrate.ai docker client

```
iai client pull --token <IAI_TOKEN> 
```

### Run integrate.ai training session

```
iai client train --token <IAI_TOKEN> --session <SESSION_ID> --train_path <PATH_TO_TRAINING_DATA> --test_path <PATH_TO_TEST_DATA> --batch_size 5
```
""",
    'long_description_content_type': 'text/markdown',
    'name': 'integrate_ai',
    'namespace_packages': (
    ),
    'package_data': {
    },
    'packages': (
        'integrate_ai',
        'integrate_ai.utils',
    ),
    'python_requires': '>=3.7.5',
    'version': '10.0.5',
})
