"""
Setup configuration for Composio Autogen plugin
"""

from pathlib import Path

from setuptools import setup


setup(
    name="composio_autogen",
    version="0.2.36",
    author="Sawradip",
    author_email="sawradip@composio.dev",
    description="Use Composio to get an array of tools with your Autogen agent.",
    long_description=(Path(__file__).parent / "README.md").read_text(encoding="utf-8"),
    long_description_content_type="text/markdown",
    url="https://github.com/SamparkAI/composio_sdk",
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: Apache Software License",
        "Operating System :: OS Independent",
    ],
    python_requires=">=3.9,<4",
    install_requires=[
        "composio_core===0.2.36",
        "pyautogen>=0.2.19",
    ],
    include_package_data=True,
)
