/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.mdarray;

import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;

public final class MDShortArray
extends MDAbstractArray<Short> {
    private static final long serialVersionUID = 1L;
    private short[] flattenedArray;

    public MDShortArray(long[] dimensions) {
        this(new short[MDShortArray.getLength(dimensions, 0L)], MDShortArray.toInt(dimensions), false);
    }

    public MDShortArray(long[] dimensions, long capacityHyperRows) {
        this(new short[MDShortArray.getLength(dimensions, capacityHyperRows)], MDShortArray.toInt(dimensions), false);
    }

    public MDShortArray(short[] flattenedArray, long[] dimensions) {
        this(flattenedArray, MDShortArray.toInt(dimensions), true);
    }

    public MDShortArray(short[] flattenedArray, long[] dimensions, boolean checkdimensions) {
        this(flattenedArray, MDShortArray.toInt(dimensions), checkdimensions);
    }

    public MDShortArray(int[] dimensions) {
        this(new short[MDShortArray.getLength(dimensions, 0)], dimensions, false);
    }

    public MDShortArray(int[] dimensions, int capacityHyperRows) {
        this(new short[MDShortArray.getLength(dimensions, capacityHyperRows)], dimensions, false);
    }

    public MDShortArray(short[] flattenedArray, int[] dimensions) {
        this(flattenedArray, dimensions, true);
    }

    public MDShortArray(short[] flattenedArray, int[] dimensions, boolean checkdimensions) {
        super(dimensions, flattenedArray.length, 0);
        int expectedLength;
        assert (flattenedArray != null);
        if (checkdimensions && flattenedArray.length != (expectedLength = MDShortArray.getLength(dimensions, 0))) {
            throw new IllegalArgumentException("Actual array length " + flattenedArray.length + " does not match expected length " + expectedLength + ".");
        }
        this.flattenedArray = flattenedArray;
    }

    public MDShortArray(short[][] matrix) {
        this(matrix, MDShortArray.getDimensions(matrix));
    }

    public MDShortArray(short[][] matrix, int[] dimensions) {
        super(dimensions, 0, matrix.length);
        int sizeX = dimensions[0];
        int sizeY = dimensions[1];
        int length = MDShortArray.getLength(dimensions, 0);
        this.flattenedArray = new short[length];
        int i = 0;
        while (i < sizeX) {
            System.arraycopy(matrix[i], 0, this.flattenedArray, i * sizeY, sizeY);
            ++i;
        }
    }

    private static int[] getDimensions(short[][] matrix) {
        assert (matrix != null);
        return new int[]{matrix.length, matrix.length == 0 ? 0 : matrix[0].length};
    }

    @Override
    public int capacity() {
        return this.flattenedArray.length;
    }

    @Override
    public Short getAsObject(int ... indices) {
        return this.get(indices);
    }

    @Override
    public void setToObject(Short value, int ... indices) {
        this.set((short)value, indices);
    }

    @Override
    public Short getAsObject(int linearIndex) {
        return this.get(linearIndex);
    }

    @Override
    public void setToObject(Short value, int linearIndex) {
        this.set((short)value, linearIndex);
    }

    public short[] getAsFlatArray() {
        return this.flattenedArray;
    }

    public short[] getCopyAsFlatArray() {
        return ArrayUtils.subarray(this.flattenedArray, 0, this.dimensions[0] * this.hyperRowLength);
    }

    @Override
    protected void adaptCapacityHyperRows() {
        short[] oldArray = this.flattenedArray;
        this.flattenedArray = new short[this.capacityHyperRows * this.hyperRowLength];
        System.arraycopy(oldArray, 0, this.flattenedArray, 0, Math.min(oldArray.length, this.flattenedArray.length));
    }

    public short get(int ... indices) {
        return this.flattenedArray[this.computeIndex(indices)];
    }

    public short get(int index) {
        return this.flattenedArray[index];
    }

    public short get(int indexX, int indexY) {
        return this.flattenedArray[this.computeIndex(indexX, indexY)];
    }

    public short get(int indexX, int indexY, int indexZ) {
        return this.flattenedArray[this.computeIndex(indexX, indexY, indexZ)];
    }

    public void set(short value, int ... indices) {
        this.flattenedArray[this.computeIndex((int[])indices)] = value;
    }

    public void set(short value, int index) {
        this.flattenedArray[index] = value;
    }

    public void set(short value, int indexX, int indexY) {
        this.flattenedArray[this.computeIndex((int)indexX, (int)indexY)] = value;
    }

    public void set(short value, int indexX, int indexY, int indexZ) {
        this.flattenedArray[this.computeIndex((int)indexX, (int)indexY, (int)indexZ)] = value;
    }

    public short[][] toMatrix() {
        int sizeX = this.dimensions[0];
        int sizeY = this.dimensions[1];
        short[][] result = new short[sizeX][sizeY];
        int i = 0;
        while (i < sizeX) {
            System.arraycopy(this.flattenedArray, i * sizeY, result[i], 0, sizeY);
            ++i;
        }
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.getValuesAsFlatArray());
        result = 31 * result + Arrays.hashCode(this.dimensions);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MDShortArray other = (MDShortArray)obj;
        if (!Arrays.equals(this.getValuesAsFlatArray(), other.getValuesAsFlatArray())) {
            return false;
        }
        return Arrays.equals(this.dimensions, other.dimensions);
    }

    private short[] getValuesAsFlatArray() {
        return this.dimensions[0] < this.capacityHyperRows ? this.getCopyAsFlatArray() : this.getAsFlatArray();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.hyperRowLength == 0) {
            this.hyperRowLength = this.computeHyperRowLength(this.dimensions);
        }
        if (this.capacityHyperRows == 0) {
            this.capacityHyperRows = this.dimensions[0];
        }
        if (this.size == 0) {
            this.size = this.hyperRowLength * this.dimensions[0];
        }
    }
}

