/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.h5ar;

import ch.systemsx.cisd.base.exceptions.IErrorStrategy;
import ch.systemsx.cisd.base.unix.FileLinkType;
import ch.systemsx.cisd.hdf5.HDF5LinkInformation;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.h5ar.ArchiveEntry;
import ch.systemsx.cisd.hdf5.h5ar.ArchiverException;
import ch.systemsx.cisd.hdf5.h5ar.IArchiveEntryProcessor;
import ch.systemsx.cisd.hdf5.h5ar.IArchiveEntryVisitor;
import ch.systemsx.cisd.hdf5.h5ar.IdCache;
import ch.systemsx.cisd.hdf5.h5ar.LinkRecord;
import ch.systemsx.cisd.hdf5.h5ar.ListArchiveException;
import ch.systemsx.cisd.hdf5.h5ar.ListArchiveTooManySymbolicLinksException;
import ch.systemsx.cisd.hdf5.h5ar.Utils;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import java.io.File;
import java.io.IOException;
import java.util.zip.CRC32;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;

class ArchiveEntryListProcessor
implements IArchiveEntryProcessor {
    private final IArchiveEntryVisitor visitor;
    private final byte[] buffer;
    private final boolean checkArchive;

    ArchiveEntryListProcessor(IArchiveEntryVisitor visitor, byte[] buffer, boolean checkArchive) {
        this.visitor = visitor;
        this.buffer = buffer;
        this.checkArchive = checkArchive;
    }

    @Override
    public boolean process(String dir, String path, LinkRecord link, IHDF5Reader reader, IdCache idCache, IErrorStrategy errorStrategy) throws IOException {
        String errorMessage = null;
        if (this.checkArchive) {
            HDF5LinkInformation info = reader.object().getLinkInformation(path);
            FileLinkType verifiedType = Utils.translateType(info.getType());
            link.setVerifiedType(verifiedType);
            if (verifiedType == FileLinkType.REGULAR_FILE) {
                long verifiedSize = reader.object().getSize(path);
                int verifiedCrc32 = 0;
                try {
                    verifiedCrc32 = this.calcCRC32Archive(path, verifiedSize, reader);
                }
                catch (HDF5Exception ex) {
                    errorMessage = String.valueOf(ex.getClass().getSimpleName()) + ": " + ex.getMessage();
                }
                link.setFileVerification(verifiedSize, verifiedCrc32, -1L);
            }
        }
        this.visitor.visit(new ArchiveEntry(dir, path, link, idCache, errorMessage));
        return true;
    }

    @Override
    public void postProcessDirectory(String dir, String path, LinkRecord link, IHDF5Reader reader, IdCache idCache, IErrorStrategy errorStrategy) throws IOException, HDF5Exception {
    }

    private int calcCRC32Archive(String objectPath, long size, IHDF5Reader hdf5Reader) {
        CRC32 crc32Digest = new CRC32();
        long offset = 0L;
        while (offset < size) {
            int n = hdf5Reader.opaque().readArrayToBlockWithOffset(objectPath, this.buffer, this.buffer.length, offset, 0);
            offset += (long)n;
            crc32Digest.update(this.buffer, 0, n);
        }
        return (int)crc32Digest.getValue();
    }

    @Override
    public ArchiverException createException(String objectPath, String detailedMsg) {
        return new ListArchiveException(objectPath, detailedMsg);
    }

    @Override
    public ArchiverException createException(String objectPath, HDF5Exception cause) {
        if (this.isTooManySymlinksError(cause)) {
            return new ListArchiveTooManySymbolicLinksException(objectPath, cause);
        }
        return new ListArchiveException(objectPath, cause);
    }

    private boolean isTooManySymlinksError(HDF5Exception cause) {
        return cause instanceof HDF5LibraryException && ((HDF5LibraryException)cause).getMajorErrorNumber() == HDF5Constants.H5E_LINK && "Too many soft links in path".equals(((HDF5LibraryException)cause).getMinorError());
    }

    @Override
    public ArchiverException createException(String objectPath, RuntimeException cause) {
        return new ListArchiveException(objectPath, cause);
    }

    @Override
    public ArchiverException createException(File file2, IOException cause) {
        return new ListArchiveException(file2, cause);
    }
}

