/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.DelegateReader;
import loci.formats.FileInfo;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.Modulo;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetadataOptions;
import loci.formats.meta.MetadataStore;

public abstract class ReaderWrapper
implements IFormatReader {
    protected IFormatReader reader;

    public ReaderWrapper() {
        this(new ImageReader());
    }

    public ReaderWrapper(IFormatReader r) {
        if (r == null) {
            throw new IllegalArgumentException("Format reader cannot be null");
        }
        this.reader = r;
    }

    public IFormatReader getReader() {
        return this.reader;
    }

    public IFormatReader unwrap() throws FormatException, IOException {
        return this.unwrap(null, null);
    }

    public IFormatReader unwrap(String id) throws FormatException, IOException {
        return this.unwrap(null, id);
    }

    public IFormatReader unwrap(Class<? extends IFormatReader> readerClass, String id) throws FormatException, IOException {
        IFormatReader r = this;
        while (!(!(r instanceof ReaderWrapper) && !(r instanceof ImageReader) || readerClass != null && readerClass.isInstance(r))) {
            if (r instanceof ImageReader) {
                ImageReader ir = (ImageReader)r;
                r = id == null ? ir.getReader() : ir.getReader(id);
                continue;
            }
            r = r.getReader();
        }
        if (readerClass != null && !readerClass.isInstance(r)) {
            return null;
        }
        return r;
    }

    public ReaderWrapper duplicate(Class<? extends IFormatReader> imageReaderClass) throws FormatException {
        ReaderWrapper wrapperCopy = this.duplicateRecurse(imageReaderClass);
        boolean normalized = this.isNormalized();
        boolean metadataFiltered = this.isMetadataFiltered();
        wrapperCopy.setNormalized(normalized);
        wrapperCopy.setMetadataFiltered(metadataFiltered);
        return wrapperCopy;
    }

    @Override
    public Set<MetadataLevel> getSupportedMetadataLevels() {
        return this.reader.getSupportedMetadataLevels();
    }

    @Override
    public MetadataOptions getMetadataOptions() {
        return this.reader.getMetadataOptions();
    }

    @Override
    public void setMetadataOptions(MetadataOptions options) {
        this.reader.setMetadataOptions(options);
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        return this.reader.isThisType(name, open);
    }

    @Override
    public boolean isThisType(byte[] block) {
        return this.reader.isThisType(block);
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return this.reader.isThisType(stream);
    }

    @Override
    public int getImageCount() {
        return this.reader.getImageCount();
    }

    @Override
    public boolean isRGB() {
        return this.reader.isRGB();
    }

    @Override
    public int getSizeX() {
        return this.reader.getSizeX();
    }

    @Override
    public int getSizeY() {
        return this.reader.getSizeY();
    }

    @Override
    public int getSizeZ() {
        return this.reader.getSizeZ();
    }

    @Override
    public int getSizeC() {
        return this.reader.getSizeC();
    }

    @Override
    public int getSizeT() {
        return this.reader.getSizeT();
    }

    @Override
    public int getPixelType() {
        return this.reader.getPixelType();
    }

    @Override
    public int getBitsPerPixel() {
        return this.reader.getBitsPerPixel();
    }

    @Override
    public int getEffectiveSizeC() {
        int sizeZT = this.getSizeZ() * this.getSizeT();
        if (sizeZT == 0) {
            return 0;
        }
        return this.getImageCount() / sizeZT;
    }

    @Override
    public int getRGBChannelCount() {
        int effSizeC = this.getEffectiveSizeC();
        if (effSizeC == 0) {
            return 0;
        }
        return this.getSizeC() / effSizeC;
    }

    @Override
    public boolean isIndexed() {
        return this.reader.isIndexed();
    }

    @Override
    public boolean isFalseColor() {
        return this.reader.isFalseColor();
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        return this.reader.get8BitLookupTable();
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        return this.reader.get16BitLookupTable();
    }

    @Override
    public Modulo getModuloZ() {
        return this.reader.getModuloZ();
    }

    @Override
    public Modulo getModuloC() {
        return this.reader.getModuloC();
    }

    @Override
    public Modulo getModuloT() {
        return this.reader.getModuloT();
    }

    @Override
    public int getThumbSizeX() {
        return this.reader.getThumbSizeX();
    }

    @Override
    public int getThumbSizeY() {
        return this.reader.getThumbSizeY();
    }

    @Override
    public boolean isLittleEndian() {
        return this.reader.isLittleEndian();
    }

    @Override
    public String getDimensionOrder() {
        return this.reader.getDimensionOrder();
    }

    @Override
    public boolean isOrderCertain() {
        return this.reader.isOrderCertain();
    }

    @Override
    public boolean isThumbnailSeries() {
        return this.reader.isThumbnailSeries();
    }

    @Override
    public boolean isInterleaved() {
        return this.reader.isInterleaved();
    }

    @Override
    public boolean isInterleaved(int subC) {
        return this.reader.isInterleaved(subC);
    }

    @Override
    public byte[] openBytes(int no) throws FormatException, IOException {
        return this.reader.openBytes(no);
    }

    @Override
    public byte[] openBytes(int no, int x, int y, int w, int h2) throws FormatException, IOException {
        return this.reader.openBytes(no, x, y, w, h2);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return this.reader.openBytes(no, buf);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        return this.reader.openBytes(no, buf, x, y, w, h2);
    }

    @Override
    public Object openPlane(int no, int x, int y, int w, int h2) throws FormatException, IOException {
        return this.reader.openPlane(no, x, y, w, h2);
    }

    @Override
    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        return this.reader.openThumbBytes(no);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        this.reader.close(fileOnly);
    }

    @Override
    public int getSeriesCount() {
        return this.reader.getSeriesCount();
    }

    @Override
    public void setSeries(int no) {
        this.reader.setSeries(no);
    }

    @Override
    public int getSeries() {
        return this.reader.getSeries();
    }

    @Override
    public void setGroupFiles(boolean group) {
        this.reader.setGroupFiles(group);
    }

    @Override
    public boolean isGroupFiles() {
        return this.reader.isGroupFiles();
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return this.reader.fileGroupOption(id);
    }

    @Override
    public boolean isMetadataComplete() {
        return this.reader.isMetadataComplete();
    }

    @Override
    public void setNormalized(boolean normalize) {
        this.reader.setNormalized(normalize);
    }

    @Override
    public boolean isNormalized() {
        return this.reader.isNormalized();
    }

    @Override
    public void setOriginalMetadataPopulated(boolean populate) {
        this.reader.setOriginalMetadataPopulated(populate);
    }

    @Override
    public boolean isOriginalMetadataPopulated() {
        return this.reader.isOriginalMetadataPopulated();
    }

    @Override
    public String[] getUsedFiles() {
        return this.reader.getUsedFiles();
    }

    @Override
    public String[] getUsedFiles(boolean noPixels) {
        return this.reader.getUsedFiles(noPixels);
    }

    @Override
    public String[] getSeriesUsedFiles() {
        return this.reader.getSeriesUsedFiles();
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        return this.reader.getSeriesUsedFiles(noPixels);
    }

    @Override
    public FileInfo[] getAdvancedUsedFiles(boolean noPixels) {
        return this.reader.getAdvancedUsedFiles(noPixels);
    }

    @Override
    public FileInfo[] getAdvancedSeriesUsedFiles(boolean noPixels) {
        return this.reader.getAdvancedSeriesUsedFiles(noPixels);
    }

    @Override
    public String getCurrentFile() {
        return this.reader.getCurrentFile();
    }

    @Override
    public int getIndex(int z, int c, int t) {
        return this.reader.getIndex(z, c, t);
    }

    @Override
    public int getIndex(int z, int c, int t, int moduloZ, int moduloC, int moduloT) {
        return this.reader.getIndex(z, c, t, moduloZ, moduloC, moduloT);
    }

    @Override
    public int[] getZCTCoords(int index) {
        return this.reader.getZCTCoords(index);
    }

    @Override
    public int[] getZCTModuloCoords(int index) {
        return this.reader.getZCTModuloCoords(index);
    }

    @Override
    public Object getMetadataValue(String field) {
        return this.reader.getMetadataValue(field);
    }

    @Override
    public Object getSeriesMetadataValue(String field) {
        return this.reader.getSeriesMetadataValue(field);
    }

    @Override
    public Hashtable<String, Object> getGlobalMetadata() {
        return this.reader.getGlobalMetadata();
    }

    @Override
    public Hashtable<String, Object> getSeriesMetadata() {
        return this.reader.getSeriesMetadata();
    }

    @Override
    public List<CoreMetadata> getCoreMetadataList() {
        List<CoreMetadata> oldcore = this.reader.getCoreMetadataList();
        ArrayList<CoreMetadata> newcore = new ArrayList<CoreMetadata>();
        for (int s2 = 0; s2 < oldcore.size(); ++s2) {
            CoreMetadata newMeta = oldcore.get(s2).clone(this, s2);
            newMeta.resolutionCount = oldcore.get((int)s2).resolutionCount;
            newcore.add(newMeta);
        }
        return newcore;
    }

    @Override
    public void setMetadataFiltered(boolean filter) {
        this.reader.setMetadataFiltered(filter);
    }

    @Override
    public boolean isMetadataFiltered() {
        return this.reader.isMetadataFiltered();
    }

    @Override
    public void setMetadataStore(MetadataStore store) {
        this.reader.setMetadataStore(store);
    }

    @Override
    public MetadataStore getMetadataStore() {
        return this.reader.getMetadataStore();
    }

    @Override
    public Object getMetadataStoreRoot() {
        return this.reader.getMetadataStoreRoot();
    }

    @Override
    public IFormatReader[] getUnderlyingReaders() {
        return new IFormatReader[]{this.reader};
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return this.reader.isSingleFile(id);
    }

    @Override
    public int getRequiredDirectories(String[] files) throws FormatException, IOException {
        return this.reader.getRequiredDirectories(files);
    }

    @Override
    public String getDatasetStructureDescription() {
        return this.reader.getDatasetStructureDescription();
    }

    @Override
    public boolean hasCompanionFiles() {
        return this.reader.hasCompanionFiles();
    }

    @Override
    public String[] getPossibleDomains(String id) throws FormatException, IOException {
        return this.reader.getPossibleDomains(id);
    }

    @Override
    public String[] getDomains() {
        return this.reader.getDomains();
    }

    @Override
    public int getOptimalTileWidth() {
        return this.reader.getOptimalTileWidth();
    }

    @Override
    public int getOptimalTileHeight() {
        return this.reader.getOptimalTileHeight();
    }

    @Override
    public int getCoreIndex() {
        return this.reader.getCoreIndex();
    }

    @Override
    public void setCoreIndex(int no) {
        this.reader.setCoreIndex(no);
    }

    @Override
    public int seriesToCoreIndex(int series) {
        return this.reader.seriesToCoreIndex(series);
    }

    @Override
    public int coreIndexToSeries(int index) {
        return this.reader.coreIndexToSeries(index);
    }

    @Override
    public int getResolutionCount() {
        return this.reader.getResolutionCount();
    }

    @Override
    public void setResolution(int no) {
        this.reader.setResolution(no);
    }

    @Override
    public int getResolution() {
        return this.reader.getResolution();
    }

    @Override
    public boolean hasFlattenedResolutions() {
        return this.reader.hasFlattenedResolutions();
    }

    @Override
    public void setFlattenedResolutions(boolean flattened) {
        this.reader.setFlattenedResolutions(flattened);
    }

    @Override
    public boolean isThisType(String name) {
        return this.reader.isThisType(name);
    }

    @Override
    public String getFormat() {
        return this.reader.getFormat();
    }

    @Override
    public String[] getSuffixes() {
        return this.reader.getSuffixes();
    }

    @Override
    public Class<?> getNativeDataType() {
        return this.reader.getNativeDataType();
    }

    @Override
    public void setId(String id) throws FormatException, IOException {
        this.reader.setId(id);
    }

    @Override
    public void reopenFile() throws IOException {
        this.reader.reopenFile();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private ReaderWrapper duplicateRecurse(Class<? extends IFormatReader> imageReaderClass) throws FormatException {
        IFormatReader childCopy = null;
        if (this.reader instanceof ReaderWrapper) {
            childCopy = ((ReaderWrapper)this.reader).duplicateRecurse(imageReaderClass);
        } else {
            Class c = null;
            c = this.reader instanceof ImageReader ? (imageReaderClass == null ? ImageReader.class : imageReaderClass) : this.reader.getClass();
            try {
                childCopy = (IFormatReader)c.newInstance();
            }
            catch (IllegalAccessException exc) {
                throw new FormatException(exc);
            }
            catch (InstantiationException exc) {
                throw new FormatException(exc);
            }
            if (this.reader instanceof DelegateReader) {
                DelegateReader delegateOriginal = (DelegateReader)this.reader;
                DelegateReader delegateCopy = (DelegateReader)childCopy;
                delegateCopy.setLegacy(delegateOriginal.isLegacy());
            }
        }
        Class<?> wrapperClass = this.getClass();
        ReaderWrapper wrapperCopy = null;
        try {
            wrapperCopy = (ReaderWrapper)wrapperClass.getConstructor(IFormatReader.class).newInstance(childCopy);
        }
        catch (InstantiationException exc) {
            throw new FormatException(exc);
        }
        catch (IllegalAccessException exc) {
            throw new FormatException(exc);
        }
        catch (NoSuchMethodException exc) {
            throw new FormatException(exc);
        }
        catch (InvocationTargetException exc) {
            throw new FormatException(exc);
        }
        return wrapperCopy;
    }
}

