/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import ch.systemsx.cisd.base.mdarray.MDIntArray;
import ch.systemsx.cisd.hdf5.HDF5CompoundDataMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.common.xml.BaseHandler;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatHandler;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.services.JHDFService;
import loci.formats.services.JHDFServiceImpl;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class BDVReader
extends FormatReader {
    public static final String HDF_MAGIC_STRING = "HDF";
    public static final String BDV_MAGIC_STRING = "SpimData";
    private final int[][] COLORS = new int[][]{{255, 0, 0}, {0, 255, 0}, {0, 0, 255}, {255, 255, 0}, {0, 255, 255}, {255, 0, 255}, {255, 255, 255}, {255, 0, 128}, {0, 255, 128}, {0, 128, 256}, {128, 0, 128}, {255, 128, 0}, {64, 128, 0}, {0, 64, 128}, {128, 0, 64}};
    private MetadataStore store;
    private String bdvxml;
    private String h5Id;
    private int sizeC = 0;
    private boolean timepointUsePattern = false;
    private Integer firstTimepoint = 0;
    private Integer lastTimepoint = 0;
    private Integer timepointIncrement = 1;
    private int seriesCount;
    private transient JHDFService jhdf;
    private int lastChannel = 0;
    private List<H5Coordinate> H5PositionList = new ArrayList<H5Coordinate>();
    private List<String> H5PathsToImageData = new ArrayList<String>();
    private List<String> cellObjectNames = new ArrayList<String>();
    private List<Integer> channelIndexes = new ArrayList<Integer>();
    private HashMap<Integer, HashMap<String, String>> setupAttributeList = new HashMap();
    private HashMap<Integer, Integer> setupResolutionCounts = new HashMap();
    private HDF5CompoundDataMap[] times = null;
    private HDF5CompoundDataMap[] classes = null;
    private HDF5CompoundDataMap[] bbox = null;

    public BDVReader() {
        super("BDV", new String[]{"xml", "h5"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Unknown"};
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        if (BDVReader.checkSuffix(id, "h5")) {
            id = this.fetchXMLId();
        }
        this.store = this.makeFilterMetadata();
        this.in = new RandomAccessInputStream(id);
        this.in.setEncoding("ASCII");
        BDVXMLHandler handler = new BDVXMLHandler();
        try (RandomAccessInputStream s2 = new RandomAccessInputStream(id);){
            XMLTools.parseXML(s2, (DefaultHandler)handler);
        }
        catch (IOException e) {
            throw new FormatException("Malformed XML", e);
        }
        if (StringUtils.isEmpty(this.h5Id)) {
            throw new FormatException("Could not find H5 file location in XML");
        }
        this.store.setXMLAnnotationValue(this.bdvxml, 0);
        String xml_id = MetadataTools.createLSID("XMLAnnotation", 0);
        this.store.setXMLAnnotationID(xml_id, 0);
        this.initializeJHDFService(this.h5Id);
        this.parseStructure();
        if (this.seriesCount <= 2 && this.getMetadataOptions().getMetadataLevel() == MetadataLevel.ALL) {
            this.parseROIs(0);
        }
    }

    private String fetchXMLId() throws FormatException {
        String xmlId = this.currentId;
        Location location = new Location(this.currentId);
        Location parent = location.getParentFile();
        String baseName = location.getName();
        Location xmlLocation = new Location(parent, (baseName = baseName.substring(0, baseName.indexOf("."))) + ".xml");
        if (!xmlLocation.exists()) {
            throw new FormatException("Unable to locate associated BDV XML: " + xmlLocation);
        }
        xmlId = xmlLocation.getAbsolutePath();
        return xmlId;
    }

    @Override
    public String[] getUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        String xmlId = this.currentId;
        if (BDVReader.checkSuffix(this.currentId, "h5")) {
            try {
                xmlId = this.fetchXMLId();
            }
            catch (FormatException e) {
                LOGGER.error("Unable to locate associated BDV XML for file: " + this.currentId);
            }
        }
        return new String[]{xmlId, this.h5Id};
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        String baseName;
        Location parent;
        Location xmlLocation;
        Location location = new Location(name);
        if (!location.exists()) {
            return false;
        }
        if (BDVReader.checkSuffix(name, "h5") && open && (xmlLocation = new Location(parent = (location = location.getAbsoluteFile()).getParentFile(), (baseName = location.getName()).substring(0, baseName.indexOf(".")) + ".xml")).exists()) {
            return super.isThisType(xmlLocation.getAbsolutePath(), open);
        }
        return super.isThisType(name, open);
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 100;
        if (!FormatTools.validStream(stream, 100, false)) {
            return false;
        }
        return stream.readString(100).contains(BDV_MAGIC_STRING);
    }

    @Override
    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getPixelType() != 1 || !this.isIndexed()) {
            return null;
        }
        if (this.lastChannel < 0) {
            return null;
        }
        byte[][] lut = new byte[3][256];
        block8: for (int i = 0; i < 256; ++i) {
            switch (this.lastChannel) {
                case 0: {
                    lut[0][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 1: {
                    lut[1][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 2: {
                    lut[2][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 3: {
                    lut[1][i] = (byte)(i & 0xFF);
                    lut[2][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 4: {
                    lut[0][i] = (byte)(i & 0xFF);
                    lut[2][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 5: {
                    lut[0][i] = (byte)(i & 0xFF);
                    lut[1][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                default: {
                    lut[0][i] = (byte)(i & 0xFF);
                    lut[1][i] = (byte)(i & 0xFF);
                    lut[2][i] = (byte)(i & 0xFF);
                }
            }
        }
        return lut;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        this.lastChannel = this.getZCTCoords(no)[1];
        Object image = this.getImageData(no, y, h2);
        boolean little = this.isLittleEndian();
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        for (int row = 0; row < h2; ++row) {
            int i;
            byte[] rowData;
            Object data;
            int base = row * w * bpp;
            if (image instanceof byte[][]) {
                data = (byte[][])image;
                rowData = data[row];
                System.arraycopy(rowData, x, buf, row * w, w);
                continue;
            }
            if (image instanceof short[][]) {
                data = (short[][])image;
                rowData = data[row];
                for (i = 0; i < w; ++i) {
                    DataTools.unpackBytes(rowData[i + x], buf, base + 2 * i, 2, little);
                }
                continue;
            }
            if (image instanceof int[][]) {
                data = (int[][])image;
                rowData = data[row];
                for (i = 0; i < w; ++i) {
                    DataTools.unpackBytes(rowData[i + x], buf, base + i * 4, 4, little);
                }
                continue;
            }
            if (image instanceof float[][]) {
                data = (float[][])image;
                rowData = data[row];
                for (i = 0; i < w; ++i) {
                    int v = Float.floatToIntBits(rowData[i + x]);
                    DataTools.unpackBytes(v, buf, base + i * 4, 4, little);
                }
                continue;
            }
            if (!(image instanceof double[][])) continue;
            data = (double[][])image;
            rowData = data[row];
            for (i = 0; i < w; ++i) {
                long v = Double.doubleToLongBits(rowData[i + x]);
                DataTools.unpackBytes(v, buf, base + i * 8, 8, little);
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        try {
            super.close(fileOnly);
        }
        finally {
            if (!fileOnly) {
                this.seriesCount = 0;
                this.H5PositionList.clear();
                this.H5PathsToImageData.clear();
                this.cellObjectNames.clear();
                if (this.jhdf != null) {
                    this.jhdf.close();
                }
                this.jhdf = null;
                this.lastChannel = 0;
            }
        }
    }

    @Override
    public void reopenFile() throws IOException {
        try {
            this.initializeJHDFService(this.h5Id);
        }
        catch (MissingLibraryException e) {
            throw new IOException(e);
        }
    }

    private void initializeJHDFService(String id) throws IOException, MissingLibraryException {
        try {
            ServiceFactory factory = new ServiceFactory();
            this.jhdf = factory.getInstance(JHDFService.class);
            this.jhdf.setFile(id);
        }
        catch (DependencyException e) {
            throw new MissingLibraryException(JHDFServiceImpl.NO_JHDF_MSG, e);
        }
    }

    private Object getImageData(int no, int y, int height) throws FormatException {
        int[] zct = this.getZCTCoords(no);
        int zslice = zct[0];
        int channel = zct[1];
        int time = zct[2];
        int width = this.getSizeX();
        int seriesIndex = this.series;
        int requiredResolution = this.getResolution();
        if (this.hasFlattenedResolutions()) {
            int totalSeriesCount = 0;
            seriesIndex = 0;
            for (int setup : this.setupResolutionCounts.keySet()) {
                totalSeriesCount += this.setupResolutionCounts.get(setup).intValue();
                if (this.hasFlattenedResolutions()) {
                    int numResolutions = ((CoreMetadata)this.core.get((int)this.seriesToCoreIndex((int)this.getSeries()))).resolutionCount;
                    requiredResolution = this.series % numResolutions;
                }
                if (totalSeriesCount > this.series) {
                    requiredResolution = (this.series - (totalSeriesCount - this.setupResolutionCounts.get(setup))) % this.setupResolutionCounts.get(setup);
                    break;
                }
                ++seriesIndex;
            }
        }
        int currentSetup = (Integer)this.setupAttributeList.keySet().toArray()[seriesIndex];
        if (this.sizeC > 1) {
            int numChannelSetupFound = 0;
            block1: for (int index : this.setupAttributeList.keySet()) {
                HashMap<String, String> setup = this.setupAttributeList.get(index);
                for (String key : setup.keySet()) {
                    String value;
                    if (!key.equals("channel") || Integer.parseInt(value = setup.get(key)) != this.channelIndexes.get(channel)) continue;
                    if (numChannelSetupFound == seriesIndex) {
                        currentSetup = index;
                        continue block1;
                    }
                    ++numChannelSetupFound;
                }
            }
        }
        String formattedTimepoint = String.format("t%05d", this.firstTimepoint + this.timepointIncrement * time);
        String formattedSetup = String.format("s%02d", currentSetup);
        H5Coordinate imagePath = new H5Coordinate(formattedTimepoint, formattedSetup, "" + requiredResolution);
        if (!this.H5PathsToImageData.contains(imagePath.pathToImageData)) {
            LOGGER.warn("Attempting to retrieve invalid path: " + imagePath.pathToImageData);
        }
        int elementSize = this.jhdf.getElementSize(imagePath.pathToImageData);
        int[] arrayOrigin = new int[]{zslice, y, 0};
        int[] arrayDimension = new int[]{1, height, width};
        MDIntArray subBlock = this.jhdf.readIntBlockArray(imagePath.pathToImageData, arrayOrigin, arrayDimension);
        if (elementSize == 1) {
            byte[][] image = new byte[height][width];
            for (int yy = 0; yy < height; ++yy) {
                for (int xx = 0; xx < width; ++xx) {
                    image[yy][xx] = (byte)subBlock.get(0, yy, xx);
                }
            }
            return image;
        }
        if (elementSize == 2) {
            short[][] image = new short[height][width];
            for (int yy = 0; yy < height; ++yy) {
                for (int xx = 0; xx < width; ++xx) {
                    image[yy][xx] = (short)subBlock.get(0, yy, xx);
                }
            }
            return image;
        }
        int[][] image = new int[height][width];
        for (int yy = 0; yy < height; ++yy) {
            for (int xx = 0; xx < width; ++xx) {
                image[yy][xx] = subBlock.get(0, yy, xx);
            }
        }
        return image;
    }

    /*
     * WARNING - void declaration
     */
    private void parseStructure() throws FormatException {
        void var5_10;
        this.seriesCount = 0;
        this.core.clear();
        int numTimepoints = 1;
        if (this.timepointUsePattern && this.lastTimepoint > 0) {
            numTimepoints = this.lastTimepoint - this.firstTimepoint + 1;
            if (this.timepointIncrement > 0) {
                numTimepoints /= this.timepointIncrement.intValue();
            }
        } else {
            if (this.lastTimepoint == 0) {
                this.lastTimepoint = this.firstTimepoint;
            }
            numTimepoints = this.lastTimepoint - this.firstTimepoint + 1;
        }
        for (int timepoint = this.firstTimepoint.intValue(); timepoint <= this.lastTimepoint; timepoint += this.timepointIncrement.intValue()) {
            String path_to_timepoint = String.format("t%05d", timepoint);
            LOGGER.info("Timepoint :" + path_to_timepoint);
            for (String string : this.jhdf.getMember(path_to_timepoint)) {
                String path_to_setup = path_to_timepoint + "/" + string;
                LOGGER.info("Setup :" + path_to_setup);
                if (this.jhdf.getMember(path_to_setup).size() > 0 && timepoint == this.firstTimepoint) {
                    this.setupResolutionCounts.put(Integer.parseInt(string.substring(1)), this.jhdf.getMember(path_to_setup).size());
                }
                for (String resolution : this.jhdf.getMember(path_to_setup)) {
                    String path_to_site = path_to_setup + "/" + resolution;
                    LOGGER.info("Site :" + path_to_site);
                    this.H5PositionList.add(new H5Coordinate(String.format("t%05d", timepoint), string, resolution));
                }
            }
        }
        if (this.H5PositionList.size() == 0) {
            throw new FormatException("No series found in file...");
        }
        ArrayList<String> seriesNames = new ArrayList<String>();
        String formattedFirstTimepoint = String.format("t%05d", this.firstTimepoint);
        if (this.sizeC == 0) {
            this.sizeC = 1;
        }
        int sumOfResolutions = 0;
        for (H5Coordinate coord : this.H5PositionList) {
            String firstChannelIndex;
            if (!this.jhdf.exists(coord.pathToImageData)) continue;
            this.H5PathsToImageData.add(coord.pathToImageData);
            if (!coord.timepoint.equals(formattedFirstTimepoint)) continue;
            int setupIndex = Integer.parseInt(coord.setup.substring(1));
            HashMap<String, String> setupAttributes = this.setupAttributeList.get(setupIndex);
            String string = firstChannelIndex = this.channelIndexes.size() > 0 ? this.channelIndexes.get(0).toString() : "";
            if (this.sizeC == 1 || setupAttributes.containsKey("channel") && setupAttributes.get("channel").equals(firstChannelIndex)) {
                CoreMetadata m3 = new CoreMetadata();
                this.core.add(m3);
                int resolutionsInThisSetup = this.setupResolutionCounts.get(setupIndex);
                if (this.hasFlattenedResolutions()) {
                    this.setSeries(this.seriesCount);
                } else {
                    this.setSeries(this.coreIndexToSeries(this.seriesCount));
                    this.setResolution(this.seriesCount - sumOfResolutions);
                    if (this.seriesCount == sumOfResolutions + resolutionsInThisSetup - 1) {
                        sumOfResolutions += resolutionsInThisSetup;
                    }
                }
                LOGGER.debug(coord.pathToImageData);
                int[] ctzyx = this.jhdf.getShape(coord.pathToImageData);
                m3.sizeC = this.sizeC;
                m3.sizeT = numTimepoints;
                m3.sizeZ = ctzyx[0];
                m3.sizeY = ctzyx[1];
                m3.sizeX = ctzyx[2];
                m3.resolutionCount = resolutionsInThisSetup;
                m3.thumbnail = false;
                m3.imageCount = this.getSizeC() * this.getSizeT() * this.getSizeZ();
                m3.dimensionOrder = "XYZTC";
                m3.rgb = false;
                m3.thumbSizeX = 128;
                m3.thumbSizeY = 128;
                m3.orderCertain = false;
                m3.littleEndian = true;
                m3.interleaved = false;
                m3.indexed = true;
                int bpp = this.jhdf.getElementSize(coord.pathToImageData);
                if (bpp == 1) {
                    m3.pixelType = 1;
                } else if (bpp == 2) {
                    m3.pixelType = 3;
                } else if (bpp == 4) {
                    m3.pixelType = 4;
                } else {
                    throw new FormatException("Pixel type not understood. Only 8, 16 and 32 bit images supported");
                }
                if (this.getResolution() == 0) {
                    seriesNames.add(String.format("P_%s, W_%s_%s", coord.timepoint, coord.setup, coord.mipmapLevel));
                }
                ++this.seriesCount;
                continue;
            }
            this.setupResolutionCounts.remove(setupIndex);
        }
        if (this.seriesCount == 0) {
            throw new FormatException("No image data found...");
        }
        MetadataTools.populatePixels(this.store, this);
        boolean bl = false;
        while (var5_10 < seriesNames.size()) {
            this.store.setImageName((String)seriesNames.get((int)var5_10), (int)var5_10);
            ++var5_10;
        }
        this.setSeries(0);
    }

    private int getChannelIndexOfCellObjectName(String cellObjectName) {
        HDF5CompoundDataMap[] allImageRegions = this.jhdf.readCompoundArrayDataMap("/definition/image/region/");
        for (int regionIdx = 0; regionIdx < allImageRegions.length; ++regionIdx) {
            String regionName = (String)allImageRegions[regionIdx].get("region_name");
            Integer channelIdx = (Integer)allImageRegions[regionIdx].get("channel_idx");
            if (!regionName.endsWith(cellObjectName)) continue;
            return channelIdx;
        }
        return -1;
    }

    private static Color hex2Rgb(String colorStr) {
        int red = Integer.parseInt(colorStr.substring(1, 3), 16);
        int green = Integer.parseInt(colorStr.substring(3, 5), 16);
        int blue = Integer.parseInt(colorStr.substring(5, 7), 16);
        return new Color(red, green, blue, 255);
    }

    private void parseROIs(int s2) {
        int objectIdx = 0;
        ArrayList<Color> classColors = new ArrayList<Color>();
        int roiIndexOffset = 0;
        H5Coordinate coord = this.H5PositionList.get(0);
        for (String cellObjectName : this.cellObjectNames) {
            LOGGER.info("Parse segmentation ROIs for cell object {} : {}", (Object)cellObjectName, (Object)objectIdx);
            String featureName = "feature/" + cellObjectName + "/";
            String pathToBoundingBox = coord.pathToPosition + featureName + "bounding_box/";
            String pathToClassDefinition = "/definition/" + featureName + "object_classification/class_labels/";
            boolean hasClassification = false;
            if (this.jhdf.exists(pathToClassDefinition)) {
                HDF5CompoundDataMap[] classDef = this.jhdf.readCompoundArrayDataMap(pathToClassDefinition);
                for (int cls = 0; cls < classDef.length; ++cls) {
                    String classColorHexString = (String)classDef[cls].get("color");
                    classColors.add(BDVReader.hex2Rgb(classColorHexString));
                }
                if (classDef.length > 0) {
                    hasClassification = true;
                    this.classes = this.jhdf.readCompoundArrayDataMap(coord.pathToPosition + featureName + "object_classification/prediction");
                }
            }
            if (this.jhdf.exists(pathToBoundingBox)) {
                this.bbox = this.jhdf.readCompoundArrayDataMap(pathToBoundingBox);
                this.times = this.jhdf.readCompoundArrayDataMap(coord.pathToPosition + "object/" + cellObjectName);
                int roiChannel = this.getChannelIndexOfCellObjectName(cellObjectName);
                int roiZSlice = 0;
                for (int roiIndex = 0; roiIndex < this.bbox.length; ++roiIndex) {
                    Color strokeColor;
                    int roiManagerRoiIndex = roiIndex + roiIndexOffset;
                    int roiTime = (Integer)this.times[roiIndex].get("time_idx");
                    int objectLabelId = (Integer)this.times[roiIndex].get("obj_label_id");
                    int left = (Integer)this.bbox[roiIndex].get("left");
                    int right = (Integer)this.bbox[roiIndex].get("right");
                    int top = (Integer)this.bbox[roiIndex].get("top");
                    int bottom = (Integer)this.bbox[roiIndex].get("bottom");
                    int width = right - left;
                    int height = bottom - top;
                    String roiID = MetadataTools.createLSID("ROI", roiManagerRoiIndex);
                    this.store.setROIID(roiID, roiManagerRoiIndex);
                    this.store.setImageROIRef(roiID, s2, roiManagerRoiIndex);
                    this.store.setROIName(cellObjectName + " " + objectLabelId, roiManagerRoiIndex);
                    String shapeID = MetadataTools.createLSID("Shape", roiManagerRoiIndex, 0);
                    this.store.setRectangleID(shapeID, roiManagerRoiIndex, 0);
                    this.store.setRectangleX(Double.valueOf(left), roiManagerRoiIndex, 0);
                    this.store.setRectangleY(Double.valueOf(top), roiManagerRoiIndex, 0);
                    this.store.setRectangleWidth(Double.valueOf(width), roiManagerRoiIndex, 0);
                    this.store.setRectangleHeight(Double.valueOf(height), roiManagerRoiIndex, 0);
                    this.store.setRectangleText(cellObjectName, roiManagerRoiIndex, 0);
                    this.store.setRectangleTheT(new NonNegativeInteger(roiTime), roiManagerRoiIndex, 0);
                    this.store.setRectangleTheC(new NonNegativeInteger(roiChannel), roiManagerRoiIndex, 0);
                    this.store.setRectangleTheZ(new NonNegativeInteger(roiZSlice), roiManagerRoiIndex, 0);
                    if (hasClassification) {
                        int classLabelIDx = (Integer)this.classes[roiIndex].get("label_idx");
                        strokeColor = (Color)classColors.get(classLabelIDx);
                    } else {
                        strokeColor = new Color(this.COLORS[objectIdx][0], this.COLORS[objectIdx][1], this.COLORS[objectIdx][2], 255);
                    }
                    this.store.setRectangleStrokeColor(strokeColor, roiManagerRoiIndex, 0);
                }
                ++objectIdx;
                roiIndexOffset += this.bbox.length;
                continue;
            }
            LOGGER.info("No Segmentation data found...");
            break;
        }
    }

    class BDVXMLHandler
    extends BaseHandler {
        private final StringBuilder xmlBuffer = new StringBuilder();
        private String currentQName;
        private boolean inPixels = false;
        private boolean parsingTimepoints;
        private boolean parsingAttributes;
        private boolean parsingViewSetups;
        private boolean parsingId;
        private int currentSetupIndex;

        private void parseIntegerString(String timepontPattern) {
            String[] parts = timepontPattern.split("-");
            if (DataTools.parseInteger(parts[0]) != null) {
                BDVReader.this.firstTimepoint = DataTools.parseInteger(parts[0]);
            }
            if (parts.length > 1 && DataTools.parseInteger(parts[1]) != null) {
                String[] parts2 = parts[1].split(":");
                if (DataTools.parseInteger(parts2[0]) != null) {
                    BDVReader.this.lastTimepoint = DataTools.parseInteger(parts2[0]);
                }
                if (parts2.length > 1 && DataTools.parseInteger(parts2[1]) != null) {
                    BDVReader.this.timepointIncrement = DataTools.parseInteger(parts2[1]);
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (!this.inPixels || this.currentQName.indexOf("BinData") < 0) {
                String setupId;
                String timepoint;
                String hdf5Contents;
                if (this.currentQName.toLowerCase().equals("hdf5") && FormatHandler.checkSuffix(hdf5Contents = new String(ch, start, length), "h5")) {
                    String parent = new Location(BDVReader.this.currentId).getAbsoluteFile().getParent();
                    BDVReader.this.h5Id = parent + File.separator + hdf5Contents;
                }
                if (this.parsingTimepoints && this.currentQName.toLowerCase().equals("first")) {
                    timepoint = new String(ch, start, length);
                    if (DataTools.parseInteger(timepoint) != null) {
                        BDVReader.this.firstTimepoint = DataTools.parseInteger(timepoint);
                    }
                } else if (this.parsingTimepoints && this.currentQName.toLowerCase().equals("last")) {
                    timepoint = new String(ch, start, length);
                    if (DataTools.parseInteger(timepoint) != null) {
                        BDVReader.this.lastTimepoint = DataTools.parseInteger(timepoint);
                    }
                } else if (this.parsingTimepoints && this.currentQName.toLowerCase().equals("integerpattern")) {
                    String timepointPattern = new String(ch, start, length);
                    if (BDVReader.this.timepointUsePattern) {
                        this.parseIntegerString(timepointPattern);
                    }
                }
                if (this.parsingViewSetups && this.parsingId && DataTools.parseInteger(setupId = new String(ch, start, length)) >= BDVReader.this.setupAttributeList.size()) {
                    this.currentSetupIndex = DataTools.parseInteger(setupId);
                    BDVReader.this.setupAttributeList.put(DataTools.parseInteger(setupId), new HashMap());
                }
                if (this.parsingViewSetups && this.parsingAttributes && !this.currentQName.isEmpty() && !this.currentQName.toLowerCase().equals("attributes")) {
                    String attributeValue = new String(ch, start, length);
                    ((HashMap)BDVReader.this.setupAttributeList.get(this.currentSetupIndex)).put(this.currentQName, attributeValue);
                    if (this.currentQName.toLowerCase().equals("channel") && !BDVReader.this.channelIndexes.contains(Integer.parseInt(attributeValue))) {
                        BDVReader.this.channelIndexes.add(Integer.parseInt(attributeValue));
                        BDVReader.this.sizeC = BDVReader.this.channelIndexes.size();
                    }
                }
                this.xmlBuffer.append(new String(ch, start, length));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.currentQName = "";
            if (qName.toLowerCase().equals("timepoints")) {
                this.parsingTimepoints = false;
            }
            if (qName.toLowerCase().equals("attributes")) {
                this.parsingAttributes = false;
            }
            if (qName.toLowerCase().equals("viewsetup")) {
                this.parsingViewSetups = false;
            }
            if (qName.toLowerCase().equals("id")) {
                this.parsingId = false;
            }
            this.xmlBuffer.append("</");
            this.xmlBuffer.append(qName);
            this.xmlBuffer.append(">");
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.currentQName = qName;
            if (qName.toLowerCase().equals("viewsetup")) {
                this.parsingViewSetups = true;
            }
            if (qName.toLowerCase().equals("id")) {
                this.parsingId = true;
            }
            if (qName.toLowerCase().equals("attributes")) {
                this.parsingAttributes = true;
            }
            if (qName.toLowerCase().equals("timepoints")) {
                this.parsingTimepoints = true;
                int typeIndex = attributes.getIndex("type");
                if (typeIndex != -1) {
                    String timepointType = attributes.getValue(typeIndex);
                    BDVReader.this.timepointUsePattern = timepointType != null && timepointType.toLowerCase().equals("pattern");
                }
            }
            this.xmlBuffer.append("<");
            this.xmlBuffer.append(qName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String key = XMLTools.escapeXML(attributes.getQName(i));
                String value = XMLTools.escapeXML(attributes.getValue(i));
                this.xmlBuffer.append(" ");
                this.xmlBuffer.append(key);
                this.xmlBuffer.append("=\"");
                this.xmlBuffer.append(value);
                this.xmlBuffer.append("\"");
            }
            this.xmlBuffer.append(">");
        }

        @Override
        public void endDocument() {
            BDVReader.this.bdvxml = this.xmlBuffer.toString();
        }
    }

    private class H5Coordinate {
        public String timepoint;
        public String setup;
        public String mipmapLevel;
        protected String pathToImageData;
        protected String pathToPosition;

        H5Coordinate(String timepoint, String setup, String mipmapLevel) {
            this.timepoint = timepoint;
            this.setup = setup;
            this.mipmapLevel = mipmapLevel;
            this.pathToImageData = this.pathToPosition = this.timepoint + "/" + this.setup + "/" + this.mipmapLevel + "/cells/";
            LOGGER.trace(this.pathToImageData);
        }

        public String toString() {
            return String.format("%s %s_%s", this.timepoint, this.setup, this.mipmapLevel);
        }
    }

    private class H5Constants {
        public static final String SEGMENTATION_PATH = "image/region/";
        public static final String DEFINITION = "/definition/";
        public static final String OBJECT = "object/";
        public static final String FEATURE = "feature/";
        public static final String BBOX = "bounding_box/";
        public static final String CLASS_LABELS = "object_classification/class_labels/";
        public static final String PREDICTED_CLASS_LABELS = "object_classification/prediction";

        private H5Constants() {
        }
    }
}

