/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.model.enums.Immersion;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.Timestamp;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OIRReader
extends FormatReader {
    private static final String IDENTIFIER = "OLYMPUSRAWFORMAT";
    private static final int BUFFER_SIZE = 8192;
    private HashMap<String, PixelBlock> pixelBlocks = new HashMap();
    private ArrayList<Channel> channels = new ArrayList();
    private ArrayList<Laser> lasers = new ArrayList();
    private ArrayList<Detector> detectors = new ArrayList();
    private ArrayList<Objective> objectives = new ArrayList();
    private Length physicalSizeX;
    private Length physicalSizeY;
    private Length physicalSizeZ;
    private Timestamp acquisitionDate;
    private int defaultXMLSkip = 36;
    private int blocksPerPlane = 0;
    private String[] pixelUIDs = null;
    private String baseName;
    private int lastChannel = -1;
    private int minZ = Integer.MAX_VALUE;
    private int minT = Integer.MAX_VALUE;

    public OIRReader() {
        super("Olympus OIR", "oir");
        this.domains = new String[]{"Light Microscopy"};
        this.suffixNecessary = false;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return this.isSingleFile(id) ? 1 : 0;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        Location file2 = new Location(id);
        return OIRReader.checkSuffix(id, "oir") && file2.length() < 0x40000000L;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        HashSet<String> files = new HashSet<String>();
        for (String key : this.pixelBlocks.keySet()) {
            files.add(this.pixelBlocks.get((Object)key).file);
        }
        Object[] allFiles = files.toArray(new String[files.size()]);
        Arrays.sort(allFiles);
        return allFiles;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int length = 16;
        if (!FormatTools.validStream(stream, 16, true)) {
            return false;
        }
        return stream.readString(16).equals(IDENTIFIER);
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        int pixelType = this.getPixelType();
        if (pixelType != 0 && pixelType != 1 || !this.isIndexed()) {
            return null;
        }
        if (this.lastChannel < 0 || this.lastChannel >= this.channels.size()) {
            return null;
        }
        return (byte[][])this.channels.get((int)this.lastChannel).lut;
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        int pixelType = this.getPixelType();
        if (pixelType != 2 && pixelType != 3 || !this.isIndexed()) {
            return null;
        }
        if (this.lastChannel < 0 || this.lastChannel >= this.channels.size()) {
            return null;
        }
        return (short[][])this.channels.get((int)this.lastChannel).lut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        int[] zct = this.getZCTCoords(no);
        this.lastChannel = zct[1];
        int startIndex = -1;
        int end = 0;
        for (int first = 0; first < this.pixelUIDs.length; ++first) {
            if (this.getZ(this.pixelUIDs[first]) - this.minZ != zct[0] || this.getT(this.pixelUIDs[first]) - this.minT != zct[2] || this.pixelUIDs[first].indexOf(this.channels.get((int)(zct[1] % this.channels.size())).id) <= 0) continue;
            if (startIndex < 0) {
                startIndex = first;
            }
            end = first;
        }
        if (startIndex < 0) {
            LOGGER.warn("No pixel blocks for plane #{}", (Object)no);
            Arrays.fill(buf, (byte)0);
            return buf;
        }
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int bufferOffset = bpp * (y * this.getSizeX() + x);
        int rowLen = bpp * w;
        int imageWidth = bpp * this.getSizeX();
        int bufferEnd = bpp * ((y + h2) * this.getSizeX() + x + w);
        int bufferPointer = 0;
        String openFile = null;
        try (RandomAccessInputStream s2 = null;){
            for (int i = startIndex; i <= end; ++i) {
                PixelBlock block = this.pixelBlocks.get(this.pixelUIDs[i]);
                if (bufferPointer + block.length < bufferOffset || bufferPointer >= bufferEnd) {
                    bufferPointer += block.length;
                    continue;
                }
                byte[] pixels = null;
                if (s2 == null || !block.file.equals(openFile)) {
                    if (s2 != null) {
                        s2.close();
                    }
                    s2 = new RandomAccessInputStream(block.file, 8192);
                    openFile = block.file;
                }
                if ((pixels = this.readPixelBlock(s2, block.offset)) != null) {
                    int blockY = bufferPointer / imageWidth;
                    int blockH = pixels.length / imageWidth;
                    for (int yy = blockY; yy < blockY + blockH; ++yy) {
                        if (yy < y || yy >= y + h2) continue;
                        int blockOffset = (yy - blockY) * imageWidth + x * bpp;
                        int bufOffset = (yy - y) * rowLen;
                        System.arraycopy(pixels, blockOffset, buf, bufOffset, rowLen);
                    }
                }
                bufferPointer += block.length;
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelBlocks.clear();
            this.channels.clear();
            this.lasers.clear();
            this.detectors.clear();
            this.objectives.clear();
            this.physicalSizeX = null;
            this.physicalSizeY = null;
            this.physicalSizeZ = null;
            this.acquisitionDate = null;
            this.defaultXMLSkip = 36;
            this.blocksPerPlane = 0;
            this.pixelUIDs = null;
            this.baseName = null;
            this.lastChannel = -1;
            this.minZ = Integer.MAX_VALUE;
            this.minT = Integer.MAX_VALUE;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int i;
        int tIndex;
        int zIndex;
        super.initFile(id);
        Location current = new Location(id).getAbsoluteFile();
        Location parent = current.getParentFile();
        ArrayList<String> extraFiles = new ArrayList<String>();
        if (parent != null) {
            Object[] fileList = parent.list();
            Arrays.sort(fileList);
            String prefix = current.getName();
            if (prefix.indexOf(".") > 0) {
                prefix = prefix.substring(0, prefix.lastIndexOf("."));
            } else if (!OIRReader.checkSuffix(id, "oir")) {
                prefix = prefix.substring(0, prefix.lastIndexOf("_"));
            }
            for (Object file2 : fileList) {
                if (!((String)file2).startsWith(prefix + "_") || ((String)file2).length() != prefix.length() + 6) continue;
                try {
                    int index = Integer.parseInt(((String)file2).substring(((String)file2).lastIndexOf("_") + 1));
                    if (index != extraFiles.size() + 1) {
                        LOGGER.warn("Found file {} with index {}; expected index {}", file2, index, extraFiles.size() + 1);
                    }
                    extraFiles.add(new Location(parent, (String)file2).getAbsolutePath());
                }
                catch (NumberFormatException index) {
                    // empty catch block
                }
            }
            if (extraFiles.contains(current.getAbsolutePath())) {
                for (Object file2 : fileList) {
                    if (!((String)file2).startsWith(prefix) || !((String)file2).equalsIgnoreCase(prefix + ".oir")) continue;
                    current = new Location(parent, (String)file2);
                    this.currentId = current.getAbsolutePath();
                    break;
                }
            }
        }
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        m3.littleEndian = true;
        m3.sizeZ = 1;
        m3.sizeC = 1;
        m3.sizeT = 1;
        m3.indexed = true;
        m3.falseColor = true;
        RandomAccessInputStream s2 = new RandomAccessInputStream(this.currentId, 8192);
        Object object = null;
        try {
            this.readPixelsFile(current.getAbsolutePath(), s2);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (s2 != null) {
                if (object != null) {
                    try {
                        s2.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    s2.close();
                }
            }
        }
        for (String file3 : extraFiles) {
            RandomAccessInputStream s3 = new RandomAccessInputStream(file3, 8192);
            Throwable throwable = null;
            try {
                this.readPixelsFile(file3, s3);
            }
            catch (Throwable file4) {
                throwable = file4;
                throw file4;
            }
            finally {
                if (s3 == null) continue;
                if (throwable != null) {
                    try {
                        s3.close();
                    }
                    catch (Throwable file4) {
                        throwable.addSuppressed(file4);
                    }
                    continue;
                }
                s3.close();
            }
        }
        m3.sizeC *= this.channels.size();
        m3.imageCount = this.getSizeC() * this.getSizeZ() * this.getSizeT();
        LOGGER.debug("blocks per plane = {}", (Object)this.blocksPerPlane);
        LOGGER.debug("number of pixel blocks = {}", (Object)this.pixelBlocks.size());
        if (this.blocksPerPlane * this.getImageCount() != this.pixelBlocks.size()) {
            int maxZ = 0;
            int maxT = 0;
            for (String uid : this.pixelBlocks.keySet()) {
                LOGGER.debug("  checking uid = {}", (Object)uid);
                int thisZ = this.getZ(uid);
                int thisT = this.getT(uid);
                int block = this.getBlock(uid);
                if (block != this.blocksPerPlane - 1) continue;
                if (thisZ > maxZ) {
                    maxZ = thisZ;
                }
                if (thisT > maxT) {
                    maxT = thisT;
                }
                if (thisZ < this.minZ) {
                    this.minZ = thisZ;
                }
                if (thisT >= this.minT) continue;
                this.minT = thisT;
            }
            m3.sizeZ = maxZ - this.minZ + 1;
            m3.sizeT = maxT - this.minT + 1;
            m3.imageCount = this.getSizeC() * this.getSizeZ() * this.getSizeT();
        } else {
            this.minZ = 0;
            this.minT = 0;
        }
        m3.dimensionOrder = "XYC";
        m3.dimensionOrder = this.getSizeZ() == 1 || this.getSizeT() == 1 ? m3.dimensionOrder + "ZT" : ((zIndex = this.baseName.toLowerCase().indexOf("z")) < (tIndex = this.baseName.toLowerCase().indexOf("t")) ? m3.dimensionOrder + "TZ" : m3.dimensionOrder + "ZT");
        this.pixelUIDs = this.pixelBlocks.keySet().toArray(new String[this.pixelBlocks.size()]);
        Arrays.sort(this.pixelUIDs, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int lastUnderscore1 = s1.lastIndexOf("_");
                int lastUnderscore2 = s2.lastIndexOf("_");
                Integer block1 = new Integer(s1.substring(lastUnderscore1 + 1));
                Integer block2 = new Integer(s2.substring(lastUnderscore2 + 1));
                int underscore1 = s1.lastIndexOf("_", lastUnderscore1 - 1);
                int underscore2 = s2.lastIndexOf("_", lastUnderscore2 - 1);
                String prefix1 = s1.substring(0, underscore1);
                String prefix2 = s2.substring(0, underscore2);
                String channel1 = s1.substring(underscore1 + 1, lastUnderscore1);
                String channel2 = s2.substring(underscore2 + 1, lastUnderscore2);
                if (!prefix1.equals(prefix2)) {
                    return s1.compareTo(s2);
                }
                if (!channel1.equals(channel2)) {
                    Integer index1 = -1;
                    Integer index2 = -2;
                    for (int i = 0; i < OIRReader.this.channels.size(); ++i) {
                        if (((Channel)((OIRReader)OIRReader.this).channels.get((int)i)).id.equals(channel1)) {
                            index1 = i;
                        }
                        if (!((Channel)((OIRReader)OIRReader.this).channels.get((int)i)).id.equals(channel2)) continue;
                        index2 = i;
                    }
                    return index1.compareTo(index2);
                }
                return block1.compareTo(block2);
            }
        });
        if (LOGGER.isTraceEnabled()) {
            for (int i2 = 0; i2 < this.pixelUIDs.length; ++i2) {
                LOGGER.trace("pixel UID #{} = {}", (Object)i2, (Object)this.pixelUIDs[i2]);
            }
        }
        Hashtable<String, Object> tmpMeta = new Hashtable<String, Object>();
        this.addMeta("Creation date", this.acquisitionDate, tmpMeta);
        this.addMeta("Pixel Length X", this.physicalSizeX, tmpMeta);
        this.addMeta("Pixel Length Y", this.physicalSizeY, tmpMeta);
        this.addMeta("Z step", this.physicalSizeZ, tmpMeta);
        for (Channel channel : this.channels) {
            String prefix = "Channel " + channel.name + " ";
            this.addMetaList(prefix + "ID", channel.id, tmpMeta);
            this.addMetaList(prefix + "color", channel.color, tmpMeta);
            this.addMetaList(prefix + "pinhole", channel.pinhole, tmpMeta);
            this.addMetaList(prefix + "start wavelength", channel.excitation, tmpMeta);
            this.addMetaList(prefix + "end wavelength", channel.emission, tmpMeta);
            this.addMetaList(prefix + "linked laser index", channel.laserIndex, tmpMeta);
        }
        for (Objective objective : this.objectives) {
            this.addMetaList("Objective Lens name", objective.name, tmpMeta);
            this.addMetaList("Objective Lens magnification", objective.magnification, tmpMeta);
            this.addMetaList("Objective Lens na", objective.na, tmpMeta);
            this.addMetaList("Objective Lens wd", objective.wd, tmpMeta);
            this.addMetaList("Objective Lens refractive index", objective.ri, tmpMeta);
            this.addMetaList("Objective Lens immersion", objective.immersion, tmpMeta);
        }
        for (Laser laser : this.lasers) {
            String prefix = "Laser " + laser.name + " ";
            this.addMetaList(prefix + "ID", laser.id, tmpMeta);
            this.addMetaList(prefix + "data ID", laser.dataId, tmpMeta);
            this.addMetaList(prefix + "power", laser.power, tmpMeta);
            this.addMetaList(prefix + "transmissivity", laser.transmissivity, tmpMeta);
            this.addMetaList(prefix + "wavelength", laser.wavelength, tmpMeta);
        }
        for (Detector detector : this.detectors) {
            this.addMetaList("Detector ID", detector.id, tmpMeta);
            this.addMetaList("Detector linked channel ID", detector.channelId, tmpMeta);
            this.addMetaList("Detector voltage", detector.voltage, tmpMeta);
            this.addMetaList("Detector offset", detector.offset, tmpMeta);
            this.addMetaList("Detector gain", detector.gain, tmpMeta);
        }
        MetadataTools.merge(tmpMeta, this.metadata, "- ");
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        store.setImageInstrumentRef(instrumentID, 0);
        for (i = 0; i < this.lasers.size(); ++i) {
            Laser l = this.lasers.get(i);
            String lsid = MetadataTools.createLSID("LightSource", 0, i);
            store.setLaserID(lsid, 0, i);
            store.setLaserModel(l.id, 0, i);
            if (l.wavelength == null) continue;
            store.setLaserWavelength(FormatTools.getWavelength(l.wavelength, null), 0, i);
        }
        for (i = 0; i < this.detectors.size(); ++i) {
            Detector detector = this.detectors.get(i);
            String lsid = MetadataTools.createLSID("Detector", 0, i);
            store.setDetectorID(lsid, 0, i);
            store.setDetectorOffset(detector.offset, 0, i);
            store.setDetectorVoltage(FormatTools.createElectricPotential(detector.voltage, UNITS.VOLT), 0, i);
            store.setDetectorGain(detector.gain, 0, i);
        }
        for (i = 0; i < this.objectives.size(); ++i) {
            Objective objective = this.objectives.get(i);
            String lsid = MetadataTools.createLSID("Objective", 0, i);
            store.setObjectiveID(lsid, 0, i);
            store.setObjectiveModel(objective.name, 0, i);
            store.setObjectiveNominalMagnification(objective.magnification, 0, i);
            store.setObjectiveLensNA(objective.na, 0, i);
            store.setObjectiveWorkingDistance(FormatTools.createLength(objective.wd, UNITS.MILLIMETRE), 0, i);
            store.setObjectiveImmersion(objective.immersion, 0, i);
            if (i != 0) continue;
            store.setObjectiveSettingsID(lsid, 0);
            store.setObjectiveSettingsRefractiveIndex(objective.ri, 0);
        }
        if (this.acquisitionDate != null) {
            store.setImageAcquisitionDate(this.acquisitionDate, 0);
        }
        if (this.physicalSizeX != null) {
            store.setPixelsPhysicalSizeX(this.physicalSizeX, 0);
        }
        if (this.physicalSizeY != null) {
            store.setPixelsPhysicalSizeY(this.physicalSizeY, 0);
        }
        if (this.physicalSizeZ != null) {
            store.setPixelsPhysicalSizeZ(this.physicalSizeZ, 0);
        }
        for (int c = 0; c < this.channels.size(); ++c) {
            Channel ch = this.channels.get(c);
            store.setChannelName(ch.name, 0, c);
            if (ch.color != null) {
                store.setChannelColor(ch.color, 0, c);
            }
            if (ch.pinhole != null) {
                store.setChannelPinholeSize(ch.pinhole, 0, c);
            }
            if (ch.emission != null) {
                store.setChannelEmissionWavelength(ch.emission, 0, c);
            }
            if (ch.excitation != null) {
                store.setChannelExcitationWavelength(ch.excitation, 0, c);
            }
            for (int d = 0; d < this.detectors.size(); ++d) {
                if (!this.detectors.get((int)d).channelId.equals(ch.id)) continue;
                store.setDetectorSettingsID(MetadataTools.createLSID("Detector", 0, d), 0, c);
            }
            if (ch.laserIndex < 0 || ch.laserIndex >= this.lasers.size()) continue;
            String laserId = MetadataTools.createLSID("LightSource", 0, ch.laserIndex);
            store.setChannelLightSourceSettingsID(laserId, 0, c);
        }
    }

    private void readPixelsFile(String file2, RandomAccessInputStream s2) throws FormatException, IOException {
        LOGGER.info("Reading pixel blocks from {}", (Object)file2);
        s2.order(true);
        this.defaultXMLSkip = 36;
        long baseOffset = 16L;
        s2.seek(baseOffset);
        while (s2.readInt() != -1) {
        }
        s2.skipBytes(4);
        long pixelStart = s2.getFilePointer();
        while (this.skipPixelBlock(file2, s2, false)) {
        }
        if (s2.getFilePointer() == pixelStart && !this.isCurrentFile(file2)) {
            while (s2.readInt() != -1) {
            }
            s2.skipBytes(4);
        }
        this.readXMLBlock(file2, s2);
        while (this.skipPixelBlock(file2, s2, true)) {
        }
        this.readXMLBlock(file2, s2);
        while (s2.getFilePointer() < s2.length() - 16L) {
            boolean expectPixelBlock;
            s2.findString("<?xml");
            s2.seek(s2.getFilePointer() - 9L);
            int length = s2.readInt();
            if (length <= 0 || (long)length + s2.getFilePointer() > s2.length()) break;
            long fp = s2.getFilePointer();
            String xml = s2.readString(length);
            if (!xml.startsWith("<?xml")) {
                s2.seek(fp - 2L);
                continue;
            }
            LOGGER.trace("xml = {}", (Object)xml);
            if ((this.channels.size() == 0 || this.getSizeX() == 0 || this.getSizeY() == 0) && this.isCurrentFile(file2) || xml.indexOf("lut:LUT") > 0) {
                this.parseXML(s2, xml, fp);
            }
            if (!(expectPixelBlock = xml.endsWith(":frameProperties>"))) continue;
            while (this.skipPixelBlock(file2, s2, true)) {
            }
        }
    }

    private void readXMLBlock(String file2, RandomAccessInputStream s2) throws FormatException, IOException {
        long offset = s2.getFilePointer();
        LOGGER.debug("reading XML block from {}", (Object)offset);
        if (s2.getFilePointer() + 8L >= s2.length()) {
            return;
        }
        int totalBlockLength = s2.readInt();
        long end = s2.getFilePointer() + (long)totalBlockLength - 4L;
        s2.skipBytes(4);
        while (s2.getFilePointer() < end) {
            long start = s2.getFilePointer();
            s2.skipBytes(this.defaultXMLSkip);
            int xmlLength = s2.readInt();
            if (xmlLength <= 32) {
                xmlLength = s2.readInt();
                String uid = s2.readString(xmlLength);
                xmlLength = s2.readInt();
            } else if (xmlLength < 0 || (long)xmlLength >= s2.length() - s2.getFilePointer()) {
                s2.seek(s2.getFilePointer() - 40L);
                xmlLength = s2.readInt();
                if (xmlLength <= 0 || (long)xmlLength + s2.getFilePointer() > s2.length()) {
                    s2.seek(start);
                    xmlLength = s2.readInt();
                    if (xmlLength <= 0 || (long)xmlLength + s2.getFilePointer() > s2.length()) {
                        return;
                    }
                }
                if (xmlLength > 1024) {
                    return;
                }
                String uid = s2.readString(xmlLength);
                xmlLength = s2.readInt();
                if (xmlLength < 0 || xmlLength > totalBlockLength) {
                    s2.seek(offset + 4L);
                    int skipped = 0;
                    while (s2.readInt() != totalBlockLength - skipped) {
                        skipped += 4;
                        if (s2.getFilePointer() + 4L < s2.length()) continue;
                        s2.seek(end);
                        return;
                    }
                    xmlLength = totalBlockLength - skipped;
                    this.defaultXMLSkip = skipped - 4;
                }
            }
            if (xmlLength <= 32 || s2.getFilePointer() + (long)xmlLength > end + 8L) break;
            long fp = s2.getFilePointer();
            String xml = s2.readString(xmlLength).trim();
            LOGGER.trace("xml = {}", (Object)xml);
            if (!this.isCurrentFile(file2) && xml.indexOf("lut:LUT") <= 0) continue;
            this.parseXML(s2, xml, fp);
        }
    }

    private void parseXML(RandomAccessInputStream s2, String xml, long startFilePointer) throws FormatException, IOException {
        Element root = null;
        try {
            root = XMLTools.parseDOM(xml).getDocumentElement();
        }
        catch (ParserConfigurationException e) {
            LOGGER.debug("Could not parse XML", e);
            return;
        }
        catch (SAXException e) {
            LOGGER.debug("Could not parse XML", e);
            return;
        }
        if (root != null) {
            String name = root.getNodeName();
            if ("lsmimage:imageProperties".equals(name)) {
                this.parseImageProperties(root);
            } else if ("lsmframe:frameProperties".equals(name)) {
                this.parseFrameProperties(root);
            } else if ("lut:LUT".equals(name)) {
                long fp = s2.getFilePointer();
                s2.seek(startFilePointer - 44L);
                int uidLength = s2.readInt();
                String uid = s2.readString(uidLength);
                s2.seek(fp);
                this.parseLUT(root, uid);
            }
            this.parseOriginalMetadata(root);
        }
    }

    private void parseLUT(Element root, String uid) throws FormatException {
        Element data;
        Element linear = this.getFirstChild(root, "lut:linear");
        boolean isLinear = false;
        if (linear != null) {
            isLinear = Boolean.valueOf(linear.getTextContent());
        }
        if ((data = this.getFirstChild(root, "lut:data")) != null) {
            String lutContent = data.getTextContent();
            for (int i = 0; i < this.channels.size(); ++i) {
                if (this.channels.get((int)i).lut != null || !this.channels.get((int)i).id.equals(uid)) continue;
                if (this.getPixelType() == 1) {
                    this.channels.get((int)i).lut = new byte[3][lutContent.length() / 8];
                } else if (this.getPixelType() == 3) {
                    this.channels.get((int)i).lut = new short[3][lutContent.length() / 8];
                } else {
                    LOGGER.warn("Skipping LUTs for pixel type {}", (Object)this.getPixelType());
                    return;
                }
                for (int q = 0; q < lutContent.length(); q += 8) {
                    int r = Integer.parseInt(lutContent.substring(q, q + 2), 16);
                    int g2 = Integer.parseInt(lutContent.substring(q + 2, q + 4), 16);
                    int b = Integer.parseInt(lutContent.substring(q + 4, q + 6), 16);
                    if (this.channels.get((int)i).lut instanceof byte[][]) {
                        ((byte[][])this.channels.get((int)i).lut)[0][q / 8] = (byte)(r & 0xFF);
                        ((byte[][])this.channels.get((int)i).lut)[1][q / 8] = (byte)(g2 & 0xFF);
                        ((byte[][])this.channels.get((int)i).lut)[2][q / 8] = (byte)(b & 0xFF);
                    } else if (this.channels.get((int)i).lut instanceof short[][]) {
                        ((short[][])this.channels.get((int)i).lut)[0][q / 8] = (short)((r & 0xFFFF) * 256);
                        ((short[][])this.channels.get((int)i).lut)[1][q / 8] = (short)((g2 & 0xFFFF) * 256);
                        ((short[][])this.channels.get((int)i).lut)[2][q / 8] = (short)((b & 0xFFFF) * 256);
                    }
                    if (!isLinear || q != lutContent.length() - 8) continue;
                    this.channels.get((int)i).color = new Color(r, g2, b, 255);
                }
                break;
            }
        }
    }

    private void parseFrameProperties(Element root) throws FormatException {
        Element name;
        Element general;
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        Element imageDefinition = this.getFirstChild(root, "commonframe:imageDefinition");
        if (imageDefinition != null) {
            Element width = this.getFirstChild(imageDefinition, "base:width");
            Element height = this.getFirstChild(imageDefinition, "base:height");
            Element depth = this.getFirstChild(imageDefinition, "base:depth");
            Element bitCount = this.getFirstChild(imageDefinition, "base:bitCounts");
            if (width != null) {
                m3.sizeX = Integer.parseInt(width.getTextContent());
            }
            if (height != null) {
                m3.sizeY = Integer.parseInt(height.getTextContent());
            }
            if (depth != null) {
                int bytes = Integer.parseInt(depth.getTextContent());
                m3.pixelType = FormatTools.pixelTypeFromBytes(bytes, false, false);
            }
            if (bitCount != null) {
                m3.bitsPerPixel = Integer.parseInt(bitCount.getTextContent());
            }
        }
        if ((general = this.getFirstChild(root, "commonframe:general")) != null && (name = this.getFirstChild(general, "base:name")) != null) {
            this.baseName = name.getTextContent();
        }
    }

    private void parseImageProperties(Element root) throws FormatException {
        block63: {
            boolean appendChannels;
            String id;
            NodeList imagingMainLasers;
            Element imagingParam;
            NodeList objectiveLenses;
            Element imageInfo;
            int i;
            Element lsm;
            Element creationDate;
            CoreMetadata m3 = (CoreMetadata)this.core.get(0);
            Element general = this.getFirstChild(root, "commonimage:general");
            if (general != null && (creationDate = this.getFirstChild(general, "base:creationDateTime")) != null) {
                String date = creationDate.getTextContent();
                this.acquisitionDate = new Timestamp(date);
            }
            if ((lsm = this.getFirstChild(root, "commonimage:lsm")) != null) {
                NodeList laserNodes = lsm.getElementsByTagName("commonimage:laser");
                for (i = 0; i < laserNodes.getLength(); ++i) {
                    Element laser = (Element)laserNodes.item(i);
                    Element idNode = this.getFirstChild(laser, "commonimage:id");
                    Element nameNode = this.getFirstChild(laser, "commonimage:name");
                    Laser l = new Laser();
                    if (idNode != null) {
                        l.id = idNode.getTextContent();
                    }
                    if (nameNode != null) {
                        l.name = nameNode.getTextContent();
                    }
                    this.lasers.add(l);
                }
            }
            if ((imageInfo = this.getFirstChild(root, "commonimage:imageInfo")) != null) {
                NodeList axisNodes;
                Element width = this.getFirstChild(imageInfo, "commonimage:width");
                Element height = this.getFirstChild(imageInfo, "commonimage:height");
                if (width != null && this.getSizeX() == 0) {
                    m3.sizeX = Integer.parseInt(width.getTextContent());
                }
                if (height != null && this.getSizeY() == 0) {
                    m3.sizeY = Integer.parseInt(height.getTextContent());
                }
                if ((axisNodes = imageInfo.getElementsByTagName("commonimage:axis")) != null) {
                    for (int i2 = 0; i2 < axisNodes.getLength(); ++i2) {
                        this.parseAxis((Element)axisNodes.item(i2));
                    }
                }
                NodeList channelNodes = imageInfo.getElementsByTagName("commonphase:channel");
                for (int i3 = 0; i3 < channelNodes.getLength(); ++i3) {
                    Element imageDefinition;
                    Double wave;
                    Double pinholeSize;
                    Element pinhole;
                    Channel c = new Channel();
                    Element channelNode = (Element)channelNodes.item(i3);
                    c.id = channelNode.getAttribute("id");
                    int index = Integer.parseInt(channelNode.getAttribute("order")) - 1;
                    Element name = this.getFirstChild(channelNode, "commonphase:name");
                    if (name != null) {
                        c.name = name.getTextContent();
                    }
                    if ((pinhole = this.getFirstChild(channelNode, "fvCommonphase:pinholeDiameter")) != null && (pinholeSize = DataTools.parseDouble(pinhole.getTextContent())) != null) {
                        c.pinhole = new Length(pinholeSize, UNITS.MICROMETER);
                    }
                    Element startWavelength = this.getFirstChild(channelNode, "opticalelement:startWavelength");
                    Element endWavelength = this.getFirstChild(channelNode, "opticalelement:endWavelength");
                    if (startWavelength != null && (wave = DataTools.parseDouble(startWavelength.getTextContent())) != null) {
                        c.excitation = FormatTools.getExcitationWavelength(wave);
                    }
                    if (endWavelength != null && (wave = DataTools.parseDouble(endWavelength.getTextContent())) != null) {
                        c.emission = FormatTools.getEmissionWavelength(wave);
                    }
                    if ((imageDefinition = this.getFirstChild(channelNode, "commonphase:imageDefinition")) != null) {
                        Element depth = this.getFirstChild(imageDefinition, "commonphase:depth");
                        Element bitCount = this.getFirstChild(imageDefinition, "commonphase:bitCounts");
                        if (depth != null) {
                            int bytes = Integer.parseInt(depth.getTextContent());
                            m3.pixelType = FormatTools.pixelTypeFromBytes(bytes, false, false);
                        }
                        if (bitCount != null) {
                            m3.bitsPerPixel = Integer.parseInt(bitCount.getTextContent());
                        }
                    }
                    Element length = this.getFirstChild(channelNode, "commonphase:length");
                    Element pixelUnit = this.getFirstChild(channelNode, "commonphase:pixelUnit");
                    if (length != null) {
                        Element xLength = this.getFirstChild(length, "commonparam:x");
                        Element xUnit = this.getFirstChild(pixelUnit, "commonphase:x");
                        if (xLength != null) {
                            Double x = DataTools.parseDouble(xLength.getTextContent());
                            String unit = null;
                            if (xUnit != null) {
                                unit = xUnit.getTextContent();
                            }
                            this.physicalSizeX = FormatTools.getPhysicalSize(x, unit);
                        }
                        Element yLength = this.getFirstChild(length, "commonparam:y");
                        Element yUnit = this.getFirstChild(pixelUnit, "commonphase:y");
                        if (yLength != null) {
                            Double y = DataTools.parseDouble(yLength.getTextContent());
                            String unit = null;
                            if (yUnit != null) {
                                unit = yUnit.getTextContent();
                            }
                            this.physicalSizeY = FormatTools.getPhysicalSize(y, unit);
                        }
                        Element zLength = this.getFirstChild(length, "commonparam:z");
                        Element zUnit = this.getFirstChild(pixelUnit, "commonphase:z");
                        if (zLength != null) {
                            Double z = DataTools.parseDouble(zLength.getTextContent());
                            String unit = null;
                            if (zUnit != null) {
                                unit = zUnit.getTextContent();
                            }
                            this.physicalSizeZ = FormatTools.getPhysicalSize(z, unit);
                        }
                    }
                    while (index > this.channels.size()) {
                        this.channels.add(null);
                    }
                    if (index == this.channels.size()) {
                        this.channels.add(c);
                        continue;
                    }
                    this.channels.set(index, c);
                }
            }
            for (i = 0; i < this.channels.size(); ++i) {
                if (this.channels.get(i) != null) continue;
                this.channels.remove(i);
                --i;
            }
            Element acquisition = this.getFirstChild(root, "commonimage:acquisition");
            if (acquisition == null) {
                acquisition = this.getFirstChild(root, "lsmimage:acquisition");
            }
            if (acquisition == null) break block63;
            Element microscopeConfiguration = this.getFirstChild(acquisition, "commonimage:microscopeConfiguration");
            if (microscopeConfiguration != null && (objectiveLenses = microscopeConfiguration.getElementsByTagName("commonimage:objectiveLens")) != null) {
                for (int i4 = 0; i4 < objectiveLenses.getLength(); ++i4) {
                    Element lens = (Element)objectiveLenses.item(i4);
                    Objective objective = new Objective();
                    Element lensName = this.getFirstChild(lens, "opticalelement:displayName");
                    Element magnification = this.getFirstChild(lens, "opticalelement:magnification");
                    Element na = this.getFirstChild(lens, "opticalelement:naValue");
                    Element wd = this.getFirstChild(lens, "opticalelement:wdValue");
                    Element refraction = this.getFirstChild(lens, "opticalelement:refraction");
                    Element immersion = this.getFirstChild(lens, "opticalelement:immersion");
                    if (lensName != null) {
                        objective.name = lensName.getTextContent();
                    }
                    if (magnification != null) {
                        objective.magnification = DataTools.parseDouble(magnification.getTextContent());
                    }
                    if (na != null) {
                        objective.na = DataTools.parseDouble(na.getTextContent());
                    }
                    if (wd != null) {
                        objective.wd = DataTools.parseDouble(wd.getTextContent());
                    }
                    if (refraction != null) {
                        objective.ri = DataTools.parseDouble(refraction.getTextContent());
                    }
                    if (immersion != null) {
                        objective.immersion = MetadataTools.getImmersion(immersion.getTextContent());
                    }
                    this.objectives.add(objective);
                }
            }
            if ((imagingParam = this.getFirstChild(acquisition, "commonimage:imagingParam")) == null) {
                imagingParam = this.getFirstChild(acquisition, "lsmimage:imagingParam");
            }
            if (imagingParam != null) {
                Element resolution;
                NodeList mainLasers;
                NodeList pmts;
                NodeList axes = imagingParam.getElementsByTagName("commonparam:axis");
                if (axes != null) {
                    for (int i5 = 0; i5 < axes.getLength(); ++i5) {
                        Element dimensionAxis = (Element)axes.item(i5);
                        if (!dimensionAxis.hasAttribute("enable") || !dimensionAxis.getAttribute("enable").equals("true") || dimensionAxis.hasAttribute("paramEnable") && !dimensionAxis.getAttribute("paramEnable").equals("true")) continue;
                        this.parseAxis(dimensionAxis);
                    }
                }
                if ((pmts = imagingParam.getElementsByTagName("lsmparam:pmt")) != null) {
                    for (int i6 = 0; i6 < pmts.getLength(); ++i6) {
                        Element pmt = (Element)pmts.item(i6);
                        Detector detector = new Detector();
                        detector.id = pmt.getAttribute("detectorId");
                        detector.channelId = pmt.getAttribute("channelId");
                        Element voltage = this.getFirstChild(pmt, "lsmparam:voltage");
                        Element offset = this.getFirstChild(pmt, "lsmparam:offset");
                        Element gain = this.getFirstChild(pmt, "lsmparam:gain");
                        if (voltage != null) {
                            detector.voltage = DataTools.parseDouble(voltage.getTextContent());
                        }
                        if (offset != null) {
                            detector.offset = DataTools.parseDouble(offset.getTextContent());
                        }
                        if (gain != null) {
                            detector.gain = DataTools.parseDouble(gain.getTextContent());
                        }
                        this.detectors.add(detector);
                    }
                }
                if ((mainLasers = imagingParam.getElementsByTagName("lsmparam:mainLaser")) != null) {
                    for (int i7 = 0; i7 < mainLasers.getLength(); ++i7) {
                        Element mainLaser = (Element)mainLasers.item(i7);
                        String id2 = mainLaser.getAttribute("laserDataId");
                        Laser currentLaser = null;
                        for (int laser = 0; laser < this.lasers.size(); ++laser) {
                            if (!id2.startsWith(this.lasers.get((int)laser).id)) continue;
                            currentLaser = this.lasers.get(laser);
                            break;
                        }
                        if (currentLaser == null) continue;
                        currentLaser.dataId = id2;
                        Element power = this.getFirstChild(mainLaser, "commonparam:power");
                        Element transmissivity = this.getFirstChild(mainLaser, "commonparam:transmissivity");
                        if (power != null) {
                            currentLaser.power = DataTools.parseDouble(power.getTextContent());
                        }
                        if (transmissivity == null) continue;
                        currentLaser.transmissivity = DataTools.parseDouble(transmissivity.getTextContent());
                    }
                }
                if ((resolution = this.getFirstChild(imagingParam, "commonparam:pixelResolution")) != null) {
                    Element x = this.getFirstChild(resolution, "commonparam:x");
                    Element y = this.getFirstChild(resolution, "commonparam:y");
                    Element z = this.getFirstChild(resolution, "commonparam:z");
                    if (x != null && this.physicalSizeX == null) {
                        Double xValue = DataTools.parseDouble(x.getTextContent());
                        this.physicalSizeX = FormatTools.getPhysicalSize(xValue, null);
                    }
                    if (y != null && this.physicalSizeY == null) {
                        Double yValue = DataTools.parseDouble(y.getTextContent());
                        this.physicalSizeY = FormatTools.getPhysicalSize(yValue, null);
                    }
                    if (z != null && this.physicalSizeZ == null) {
                        Double zValue = DataTools.parseDouble(z.getTextContent());
                        this.physicalSizeZ = FormatTools.getPhysicalSize(zValue, null);
                    }
                }
            }
            if ((imagingMainLasers = acquisition.getElementsByTagName("lsmimage:imagingMainLaser")) != null) {
                for (int i8 = 0; i8 < imagingMainLasers.getLength(); ++i8) {
                    Element wavelength;
                    Element mainLaser = (Element)imagingMainLasers.item(i8);
                    id = mainLaser.getAttribute("id");
                    String enable = mainLaser.getAttribute("enable");
                    if (!"true".equals(enable) || (wavelength = this.getFirstChild(mainLaser, "commonimage:wavelength")) == null) continue;
                    for (Laser l : this.lasers) {
                        if (!id.equals(l.dataId)) continue;
                        l.wavelength = DataTools.parseDouble(wavelength.getTextContent());
                    }
                }
            }
            NodeList channelLinkages = acquisition.getElementsByTagName("commonphase:channel");
            for (int c = 0; c < this.channels.size(); ++c) {
                id = this.channels.get((int)c).id;
                boolean hasUID = false;
                for (String uid : this.pixelBlocks.keySet()) {
                    if (uid.indexOf(id) < 0) continue;
                    hasUID = true;
                    break;
                }
                if (hasUID) continue;
                this.channels.remove(c);
                --c;
            }
            boolean bl = appendChannels = this.channels.size() == 0;
            if (channelLinkages != null && channelLinkages.getLength() > 0) {
                for (int i9 = 0; i9 < channelLinkages.getLength(); ++i9) {
                    Element channel = (Element)channelLinkages.item(i9);
                    this.parseChannel(channel, appendChannels);
                }
            } else {
                channelLinkages = acquisition.getElementsByTagName("lsmimage:channel");
                for (int i10 = 0; i10 < channelLinkages.getLength(); ++i10) {
                    Element channel = (Element)channelLinkages.item(i10);
                    this.parseChannel(channel, appendChannels);
                }
            }
        }
    }

    private void parseChannel(Element channel, boolean appendChannels) {
        if (channel.hasAttribute("enable") && !channel.getAttribute("enable").equals("true")) {
            return;
        }
        String id = channel.getAttribute("id");
        NodeList laserIds = channel.getElementsByTagName("lsmimage:laserDataId");
        if (laserIds == null) {
            laserIds = channel.getElementsByTagName("fvLsmimage:laserDataId");
        }
        if (!(laserIds != null && laserIds.getLength() <= 1 || appendChannels)) {
            return;
        }
        String type = channel.getAttribute("xsi:type");
        if (type != null && !type.endsWith("NormalChannel")) {
            return;
        }
        Element laserId = (Element)laserIds.item(0);
        Element name = this.getFirstChild(channel, "commonimage:name");
        String channelName = null;
        if (name != null) {
            channelName = name.getTextContent();
        }
        if (id != null) {
            boolean foundChannel = false;
            block0: for (Channel ch : this.channels) {
                if (!ch.id.equals(id)) continue;
                foundChannel = true;
                if (laserId == null) continue;
                for (int l = 0; l < this.lasers.size(); ++l) {
                    Laser laser = this.lasers.get(l);
                    if (!laser.dataId.equals(laserId.getTextContent())) continue;
                    ch.laserIndex = l;
                    continue block0;
                }
            }
            if (!foundChannel && appendChannels) {
                Channel c = new Channel();
                c.id = id;
                c.name = channelName;
                if (laserId != null) {
                    for (int l = 0; l < this.lasers.size(); ++l) {
                        Laser laser = this.lasers.get(l);
                        if (!laser.dataId.equals(laserId.getTextContent())) continue;
                        c.laserIndex = l;
                        break;
                    }
                }
                this.channels.add(c);
            }
        }
    }

    private void parseAxis(Element dimensionAxis) {
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        Element axis = this.getFirstChild(dimensionAxis, "commonparam:axis");
        Element size = this.getFirstChild(dimensionAxis, "commonparam:maxSize");
        Element start = this.getFirstChild(dimensionAxis, "commonparam:startPosition");
        Element end = this.getFirstChild(dimensionAxis, "commonparam:endPosition");
        Element step = this.getFirstChild(dimensionAxis, "commonparam:step");
        if (axis != null && size != null) {
            String name = axis.getTextContent();
            if (name.equals("ZSTACK")) {
                if (m3.sizeZ <= 1) {
                    m3.sizeZ = Integer.parseInt(size.getTextContent());
                }
            } else if (name.equals("TIMELAPSE")) {
                if (m3.sizeT <= 1) {
                    m3.sizeT = Integer.parseInt(size.getTextContent());
                }
            } else if (name.equals("LAMBDA")) {
                m3.sizeC = Integer.parseInt(size.getTextContent());
                m3.moduloC.type = "Spectra";
                m3.moduloC.start = DataTools.parseDouble(start.getTextContent());
                m3.moduloC.step = DataTools.parseDouble(step.getTextContent());
                m3.moduloC.end = m3.moduloC.start + m3.moduloC.step * (double)(m3.sizeC - 1);
            } else {
                LOGGER.warn("Unhandled axis '{}'", (Object)name);
            }
        }
    }

    private void parseOriginalMetadata(Node root) {
        String value = root.getNodeValue();
        if (value != null && value.trim().length() > 0) {
            Node grandparent;
            value = value.trim();
            String key = "";
            Node parent = root.getParentNode();
            if (parent != null) {
                String name = parent.getNodeName();
                key = name.substring(name.indexOf(":") + 1);
            }
            if ((grandparent = parent.getParentNode()) != null) {
                String name = grandparent.getNodeName();
                name = name.substring(name.indexOf(":") + 1);
                key = name + " " + key;
            }
            this.addSeriesMetaList(key, value);
        } else {
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                this.parseOriginalMetadata(children.item(i));
            }
        }
    }

    private Element getFirstChild(Element root, String tag) {
        if (root == null || tag == null) {
            return null;
        }
        NodeList list = root.getElementsByTagName(tag);
        if (list == null || list.getLength() == 0) {
            return null;
        }
        return (Element)list.item(0);
    }

    private boolean skipPixelBlock(String currentFile, RandomAccessInputStream s2, boolean store) throws IOException {
        long offset = s2.getFilePointer();
        LOGGER.debug("reading pixel block from {}", (Object)offset);
        if (offset + 8L >= s2.length()) {
            return false;
        }
        int checkLength = s2.readInt();
        int check = s2.readInt();
        if (check != 3) {
            s2.seek(offset);
            if (check == 2) {
                s2.seek(offset + (long)checkLength + 8L);
                return true;
            }
            return false;
        }
        s2.skipBytes(8);
        int uidLength = s2.readInt();
        if (checkLength != uidLength + 12) {
            s2.seek(offset);
            return false;
        }
        String uid = s2.readString(uidLength);
        if (store) {
            LOGGER.debug("pixel uid = {} @ {}", (Object)uid, (Object)offset);
        }
        if (s2.getFilePointer() + 4L >= s2.length()) {
            return false;
        }
        int pixelBytes = s2.readInt();
        s2.skipBytes(4);
        if (store && pixelBytes > 0) {
            PixelBlock block = new PixelBlock();
            block.file = currentFile;
            block.offset = offset;
            block.length = pixelBytes;
            this.pixelBlocks.put(uid, block);
            int blockIndex = Integer.parseInt(uid.substring(uid.lastIndexOf("_") + 1));
            if (blockIndex >= this.blocksPerPlane) {
                this.blocksPerPlane = blockIndex + 1;
            }
            LOGGER.debug("added pixel block @ {}, size = {}", (Object)offset, (Object)this.pixelBlocks.size());
        } else if (pixelBytes <= 0) {
            return false;
        }
        s2.skipBytes(pixelBytes);
        return true;
    }

    private byte[] readPixelBlock(RandomAccessInputStream s2, long offset) throws IOException {
        s2.order(true);
        s2.seek(offset);
        int checkLength = s2.readInt();
        int check = s2.readInt();
        if (check != 3) {
            s2.seek(offset);
            return null;
        }
        s2.skipBytes(8);
        int uidLength = s2.readInt();
        String uid = s2.readString(uidLength);
        LOGGER.debug("reading pixel block with uid = {}", (Object)uid);
        if (checkLength != uidLength + 12) {
            s2.seek(offset);
            return null;
        }
        int pixelBytes = s2.readInt();
        s2.skipBytes(4);
        byte[] pixels = new byte[pixelBytes];
        s2.readFully(pixels);
        return pixels;
    }

    private int getZ(String uid) {
        int zIndex = uid.indexOf("z");
        if (zIndex < 0) {
            return 0;
        }
        return Integer.parseInt(uid.substring(zIndex + 1, zIndex + 4)) - 1;
    }

    private int getT(String uid) {
        int tIndex = uid.indexOf("t");
        if (tIndex < 0) {
            return 0;
        }
        String tSubString = uid.substring(tIndex + 1);
        return Integer.parseInt(tSubString.substring(0, tSubString.indexOf("_"))) - 1;
    }

    private int getBlock(String uid) {
        int index = uid.lastIndexOf("_");
        if (index < 0) {
            return 0;
        }
        return Integer.parseInt(uid.substring(index + 1));
    }

    private boolean isCurrentFile(String file2) {
        String currentPath = new Location(this.currentId).getAbsolutePath();
        return currentPath.equals(new Location(file2).getAbsolutePath());
    }

    class PixelBlock {
        public String file;
        public long offset;
        public int length;

        PixelBlock() {
        }
    }

    class Objective {
        public String name;
        public Double magnification;
        public Double na;
        public Double wd;
        public Double ri;
        public Immersion immersion;

        Objective() {
        }
    }

    class Detector {
        public String id;
        public String channelId;
        public Double voltage;
        public Double offset;
        public Double gain;

        Detector() {
        }
    }

    class Laser {
        public String id;
        public String dataId;
        public String name;
        public Double power;
        public Double transmissivity;
        public Double wavelength;

        Laser() {
        }
    }

    class Channel {
        public String id;
        public String name;
        public int laserIndex = -1;
        public Object lut;
        public Color color;
        public Length pinhole;
        public Length excitation;
        public Length emission;

        Channel() {
        }
    }
}

