/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.meta.IPyramidStore;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.out.OMETiffWriter;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import loci.formats.tiff.TiffSaver;

public class PyramidOMETiffWriter
extends OMETiffWriter {
    @Override
    public boolean isThisType(String name) {
        if (!super.isThisType(name)) {
            return false;
        }
        if (this.resolutionData.size() > 0) {
            return true;
        }
        MetadataRetrieve r = this.getMetadataRetrieve();
        if (!(r instanceof IPyramidStore)) {
            return false;
        }
        return ((IPyramidStore)((Object)r)).getResolutionCount(0) > 1;
    }

    @Override
    public void saveBytes(int no, byte[] buf, IFD ifd, int x, int y, int w, int h2) throws FormatException, IOException {
        if (ifd == null) {
            ifd = new IFD();
        }
        if (this.getResolution() > 0) {
            ifd.put(254, 1);
        } else if (!ifd.containsKey(330)) {
            ifd.put(330, 0L);
        }
        super.saveBytes(no, buf, ifd, x, y, w, h2);
    }

    @Override
    public void close() throws IOException {
        String id = this.currentId;
        MetadataRetrieve r = this.getMetadataRetrieve();
        int[] planeCounts = new int[r.getImageCount()];
        int[] resCounts = new int[r.getImageCount()];
        for (int i = 0; i < planeCounts.length; ++i) {
            planeCounts[i] = this.getPlaneCount(i);
            try {
                this.setSeries(i);
            }
            catch (FormatException e) {
                throw new IOException(e);
            }
            resCounts[i] = this.getResolutionCount();
        }
        super.close();
        try {
            boolean littleEndian = false;
            long[] allOffsets = null;
            try (RandomAccessInputStream in = new RandomAccessInputStream(id);){
                TiffParser parser = new TiffParser(in);
                littleEndian = parser.checkHeader();
                allOffsets = parser.getIFDOffsets();
            }
            int mainIFDIndex = 0;
            int currentFullResolution = 0;
            for (int i = 0; i < r.getImageCount(); ++i) {
                this.setSeries(i);
                int resCount = resCounts[i];
                for (int p = 0; p < planeCounts[i]; ++p) {
                    long[] subIFDOffsets = new long[resCount - 1];
                    for (int res = 0; res < subIFDOffsets.length; ++res) {
                        subIFDOffsets[res] = allOffsets[mainIFDIndex + (res + 1) * planeCounts[i]];
                    }
                    try (RandomAccessOutputStream out = new RandomAccessOutputStream(id);
                         RandomAccessInputStream in = new RandomAccessInputStream(id);){
                        out.order(littleEndian);
                        in.order(littleEndian);
                        TiffSaver saver = new TiffSaver(out, id);
                        saver.setBigTiff(this.isBigTiff);
                        saver.setLittleEndian(littleEndian);
                        int index = mainIFDIndex + 1;
                        if (p == planeCounts[i] - 1) {
                            index += planeCounts[i] * (resCount - 1);
                        }
                        long nextPointer = index < allOffsets.length ? allOffsets[index] : 0L;
                        saver.overwriteIFDOffset(in, allOffsets[mainIFDIndex], nextPointer);
                        saver.overwriteIFDValue(in, currentFullResolution, 330, subIFDOffsets);
                    }
                    ++mainIFDIndex;
                    ++currentFullResolution;
                }
                mainIFDIndex += planeCounts[i] * (resCount - 1);
            }
            this.setSeries(0);
        }
        catch (FormatException e) {
            throw new IOException("Failed to assemble SubIFD offsets", e);
        }
    }
}

