/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import com.google.common.base.Joiner;
import java.awt.image.IndexColorModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import loci.common.DataTools;
import loci.common.DebugTools;
import loci.common.Location;
import loci.common.image.SimpleImageScaler;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.ChannelFiller;
import loci.formats.ChannelMerger;
import loci.formats.ChannelSeparator;
import loci.formats.FilePattern;
import loci.formats.FileStitcher;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.IFormatWriter;
import loci.formats.ImageReader;
import loci.formats.ImageTools;
import loci.formats.ImageWriter;
import loci.formats.MetadataTools;
import loci.formats.MinMaxCalculator;
import loci.formats.MissingLibraryException;
import loci.formats.gui.Index16ColorModel;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEPyramidStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.out.TiffWriter;
import loci.formats.services.OMEXMLService;
import loci.formats.services.OMEXMLServiceImpl;
import loci.formats.tiff.IFD;
import loci.formats.tools.CommandLineTools;
import ome.xml.meta.OMEXMLMetadataRoot;
import ome.xml.model.Image;
import ome.xml.model.Pixels;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageConverter.class);
    private String in = null;
    private String out = null;
    private String map = null;
    private String compression = null;
    private boolean stitch = false;
    private boolean separate = false;
    private boolean merge = false;
    private boolean fill = false;
    private boolean bigtiff = false;
    private boolean group = true;
    private boolean printVersion = false;
    private boolean lookup = true;
    private boolean autoscale = false;
    private Boolean overwrite = null;
    private int series = -1;
    private int firstPlane = 0;
    private int lastPlane = Integer.MAX_VALUE;
    private int channel = -1;
    private int zSection = -1;
    private int timepoint = -1;
    private int xCoordinate = 0;
    private int yCoordinate = 0;
    private int width = 0;
    private int height = 0;
    private int saveTileWidth = 0;
    private int saveTileHeight = 0;
    private boolean validate = false;
    private boolean zeroPadding = false;
    private boolean flat = true;
    private int pyramidScale = 1;
    private int pyramidResolutions = 1;
    private IFormatReader reader;
    private MinMaxCalculator minMax;
    private HashMap<String, Integer> nextOutputIndex = new HashMap();
    private boolean firstTile = true;
    private DynamicMetadataOptions options = new DynamicMetadataOptions();

    private boolean parseArgs(String[] args) {
        if (args == null) {
            return true;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-") && args.length > 1) {
                if (args[i].equals("-version")) {
                    this.printVersion = true;
                    return true;
                }
                if (args[i].equals("-debug")) {
                    DebugTools.setRootLevel("DEBUG");
                    continue;
                }
                if (args[i].equals("-stitch")) {
                    this.stitch = true;
                    continue;
                }
                if (args[i].equals("-separate")) {
                    this.separate = true;
                    continue;
                }
                if (args[i].equals("-merge")) {
                    this.merge = true;
                    continue;
                }
                if (args[i].equals("-expand")) {
                    this.fill = true;
                    continue;
                }
                if (args[i].equals("-bigtiff")) {
                    this.bigtiff = true;
                    continue;
                }
                if (args[i].equals("-map")) {
                    this.map = args[++i];
                    continue;
                }
                if (args[i].equals("-compression")) {
                    this.compression = args[++i];
                    continue;
                }
                if (args[i].equals("-nogroup")) {
                    this.group = false;
                    continue;
                }
                if (args[i].equals("-nolookup")) {
                    this.lookup = false;
                    continue;
                }
                if (args[i].equals("-autoscale")) {
                    this.autoscale = true;
                    continue;
                }
                if (args[i].equals("-novalid")) {
                    this.validate = false;
                    continue;
                }
                if (args[i].equals("-validate")) {
                    this.validate = true;
                    continue;
                }
                if (args[i].equals("-padded")) {
                    this.zeroPadding = true;
                    continue;
                }
                if (args[i].equals("-noflat")) {
                    this.flat = false;
                    continue;
                }
                if (args[i].equals("-option")) {
                    this.options.set(args[++i], args[++i]);
                    continue;
                }
                if (args[i].equals("-overwrite")) {
                    this.overwrite = true;
                    continue;
                }
                if (args[i].equals("-nooverwrite")) {
                    this.overwrite = false;
                    continue;
                }
                if (args[i].equals("-channel")) {
                    this.channel = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-z")) {
                    this.zSection = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-timepoint")) {
                    this.timepoint = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-series")) {
                    try {
                        this.series = Integer.parseInt(args[++i]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (args[i].equals("-range")) {
                    try {
                        this.firstPlane = Integer.parseInt(args[++i]);
                        this.lastPlane = Integer.parseInt(args[++i]) + 1;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (args[i].equals("-crop")) {
                    String[] tokens = args[++i].split(",");
                    this.xCoordinate = Integer.parseInt(tokens[0]);
                    this.yCoordinate = Integer.parseInt(tokens[1]);
                    this.width = Integer.parseInt(tokens[2]);
                    this.height = Integer.parseInt(tokens[3]);
                    continue;
                }
                if (args[i].equals("-tilex")) {
                    try {
                        this.saveTileWidth = Integer.parseInt(args[++i]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (args[i].equals("-tiley")) {
                    try {
                        this.saveTileHeight = Integer.parseInt(args[++i]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (args[i].equals("-pyramid-scale")) {
                    try {
                        this.pyramidScale = Integer.parseInt(args[++i]);
                        if (this.pyramidScale <= 0) {
                            LOGGER.error("Invalid pyramid scale: {}", (Object)this.pyramidScale);
                            return false;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (args[i].equals("-pyramid-resolutions")) {
                    try {
                        this.pyramidResolutions = Integer.parseInt(args[++i]);
                        if (this.pyramidResolutions <= 0) {
                            LOGGER.error("Invalid pyramid resolution count: {}", (Object)this.pyramidResolutions);
                            return false;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (args[i].equals("-no-upgrade")) continue;
                LOGGER.error("Found unknown command flag: {}; exiting.", (Object)args[i]);
                return false;
            }
            if (args[i].equals("-version")) {
                this.printVersion = true;
                continue;
            }
            if (this.in == null) {
                this.in = args[i];
                continue;
            }
            if (this.out == null) {
                this.out = args[i];
                continue;
            }
            LOGGER.error("Found unknown argument: {}; exiting.", (Object)args[i]);
            LOGGER.error("You should specify exactly one input file and exactly one output file.");
            return false;
        }
        return true;
    }

    private static SortedMap<String, String> getExtensions() {
        IFormatWriter[] writers = new ImageWriter().getWriters();
        TreeMap<String, String> extensions = new TreeMap<String, String>();
        for (int i = 0; i < writers.length; ++i) {
            extensions.put(writers[i].getFormat(), '.' + Joiner.on(", .").join(writers[i].getSuffixes()));
        }
        return extensions;
    }

    private static SortedMap<String, String> getCompressions() {
        IFormatWriter[] writers = new ImageWriter().getWriters();
        TreeMap<String, String> compressions = new TreeMap<String, String>();
        for (int i = 0; i < writers.length; ++i) {
            Object[] compressionTypes = writers[i].getCompressionTypes();
            if (compressionTypes == null) continue;
            compressions.put(writers[i].getFormat(), Joiner.on(", ").join(compressionTypes));
        }
        return compressions;
    }

    private static String printList(SortedMap<String, String> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> pair : map.entrySet()) {
            sb.append(" * " + pair.getKey() + ": " + pair.getValue() + '\n');
        }
        return sb.toString();
    }

    private void printUsage() {
        String[] s2 = new String[]{"To convert a file between formats, run:", "  bfconvert [-debug] [-stitch] [-separate] [-merge] [-expand]", "    [-bigtiff] [-compression codec] [-series series] [-noflat]", "    [-map id] [-range start end] [-crop x,y,w,h]", "    [-channel channel] [-z Z] [-timepoint timepoint] [-nogroup]", "    [-nolookup] [-autoscale] [-version] [-no-upgrade] [-padded]", "    [-option key value] in_file out_file", "", "    -version: print the library version and exit", " -no-upgrade: do not perform the upgrade check", "      -debug: turn on debugging output", "     -stitch: stitch input files with similar names", "   -separate: split RGB images into separate channels", "      -merge: combine separate channels into RGB image", "     -expand: expand indexed color to RGB", "    -bigtiff: force BigTIFF files to be written", "-compression: specify the codec to use when saving images", "     -series: specify which image series to convert", "     -noflat: do not flatten subresolutions", "        -map: specify file on disk to which name should be mapped", "      -range: specify range of planes to convert (inclusive)", "    -nogroup: force multi-file datasets to be read as individual              files", "   -nolookup: disable the conversion of lookup tables", "  -autoscale: automatically adjust brightness and contrast before", "              converting; this may mean that the original pixel", "              values are not preserved", "  -overwrite: always overwrite the output file, if it already exists", "-nooverwrite: never overwrite the output file, if it already exists", "       -crop: crop images before converting; argument is 'x,y,w,h'", "    -channel: only convert the specified channel (indexed from 0)", "          -z: only convert the specified Z section (indexed from 0)", "  -timepoint: only convert the specified timepoint (indexed from 0)", "     -padded: filename indexes for series, z, c and t will be zero padded", "     -option: add the specified key/value pair to the options list", "", "The extension of the output file specifies the file format to use", "for the conversion. The list of available formats and extensions is:", "", ImageConverter.printList(ImageConverter.getExtensions()), "Some file formats offer multiple compression schemes that can be set", "using the -compression option. The list of available compressions is:", "", ImageConverter.printList(ImageConverter.getCompressions()), "If any of the following patterns are present in out_file, they will", "be replaced with the indicated metadata value from the input file.", "", "   Pattern:\tMetadata value:", "   ---------------------------", "   %s\t\tseries index", "   %n\t\tseries name", "   %c\t\tchannel index", "   %w\t\tchannel name", "   %z\t\tZ index", "   %t\t\tT index", "   %A\t\tacquisition timestamp", "", "If any of these patterns are present, then the images to be saved", "will be split into multiple files.  For example, if the input file", "contains 5 Z sections and 3 timepoints, and out_file is", "", "  converted_Z%z_T%t.tiff", "", "then 15 files will be created, with the names", "", "  converted_Z0_T0.tiff", "  converted_Z0_T1.tiff", "  converted_Z0_T2.tiff", "  converted_Z1_T0.tiff", "  ...", "  converted_Z4_T2.tiff", "", "Each file would have a single image plane."};
        for (int i = 0; i < s2.length; ++i) {
            System.out.println(s2[i]);
        }
    }

    public boolean testConvert(IFormatWriter writer, String[] args) throws FormatException, IOException {
        IFormatWriter w;
        this.nextOutputIndex.clear();
        this.options.setValidate(this.validate);
        writer.setMetadataOptions(this.options);
        this.firstTile = true;
        boolean success = this.parseArgs(args);
        if (!success) {
            return false;
        }
        if (this.printVersion) {
            CommandLineTools.printVersion();
            return true;
        }
        if (this.in == null || this.out == null) {
            this.printUsage();
            return false;
        }
        CommandLineTools.runUpgradeCheck(args);
        if (new Location(this.out).exists()) {
            if (this.overwrite == null) {
                LOGGER.warn("Output file {} exists.", (Object)this.out);
                LOGGER.warn("Do you want to overwrite it? ([y]/n)");
                BufferedReader r = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
                String choice = r.readLine().trim().toLowerCase();
                this.overwrite = !choice.startsWith("n");
            }
            if (!this.overwrite.booleanValue()) {
                LOGGER.warn("Exiting; next time, please specify an output file that does not exist.");
                return false;
            }
            new Location(this.out).delete();
        }
        if (this.map != null) {
            Location.mapId(this.in, this.map);
        }
        long start = System.currentTimeMillis();
        LOGGER.info(this.in);
        this.reader = new ImageReader();
        if (this.stitch) {
            this.reader = new FileStitcher(this.reader);
            Location f = new Location(this.in);
            String pat = null;
            pat = !f.exists() ? this.in : FilePattern.findPattern(f);
            if (pat != null) {
                this.in = pat;
            }
        }
        if (this.separate) {
            this.reader = new ChannelSeparator(this.reader);
        }
        if (this.merge) {
            this.reader = new ChannelMerger(this.reader);
        }
        if (this.fill) {
            this.reader = new ChannelFiller(this.reader);
        }
        this.minMax = null;
        if (this.autoscale) {
            this.reader = new MinMaxCalculator(this.reader);
            this.minMax = (MinMaxCalculator)this.reader;
        }
        this.reader.setMetadataOptions(this.options);
        this.reader.setGroupFiles(this.group);
        this.reader.setMetadataFiltered(true);
        this.reader.setOriginalMetadataPopulated(true);
        this.reader.setFlattenedResolutions(this.flat);
        OMEXMLService service = null;
        try {
            ServiceFactory factory = new ServiceFactory();
            service = factory.getInstance(OMEXMLService.class);
            this.reader.setMetadataStore(service.createOMEXMLMetadata());
        }
        catch (DependencyException de) {
            throw new MissingLibraryException(OMEXMLServiceImpl.NO_OME_XML_MSG, de);
        }
        catch (ServiceException se) {
            throw new FormatException(se);
        }
        this.reader.setId(this.in);
        MetadataStore store = this.reader.getMetadataStore();
        MetadataTools.populatePixels(store, this.reader, false, false);
        boolean dimensionsSet = true;
        if (this.width == 0 || this.height == 0) {
            if (this.series >= 0) {
                this.reader.setSeries(this.series);
            }
            this.width = this.reader.getSizeX();
            this.height = this.reader.getSizeY();
            dimensionsSet = false;
        }
        if (this.channel >= this.reader.getEffectiveSizeC()) {
            throw new FormatException("Invalid channel '" + this.channel + "' (" + this.reader.getEffectiveSizeC() + " channels in source file)");
        }
        if (this.timepoint >= this.reader.getSizeT()) {
            throw new FormatException("Invalid timepoint '" + this.timepoint + "' (" + this.reader.getSizeT() + " timepoints in source file)");
        }
        if (this.zSection >= this.reader.getSizeZ()) {
            throw new FormatException("Invalid Z section '" + this.zSection + "' (" + this.reader.getSizeZ() + " Z sections in source file)");
        }
        if (store instanceof MetadataRetrieve) {
            try {
                String xml = service.getOMEXML(service.asRetrieve(store));
                OMEXMLMetadataRoot root = (OMEXMLMetadataRoot)store.getRoot();
                OMEXMLMetadata meta = service.createOMEXMLMetadata(xml);
                if (this.series >= 0) {
                    Image exportImage = new Image(root.getImage(this.series));
                    Pixels exportPixels = new Pixels(root.getImage(this.series).getPixels());
                    exportImage.setPixels(exportPixels);
                    OMEXMLMetadataRoot newRoot = (OMEXMLMetadataRoot)meta.getRoot();
                    while (newRoot.sizeOfImageList() > 0) {
                        newRoot.removeImage(newRoot.getImage(0));
                    }
                    while (newRoot.sizeOfPlateList() > 0) {
                        newRoot.removePlate(newRoot.getPlate(0));
                    }
                    newRoot.addImage(exportImage);
                    meta.setRoot(newRoot);
                    meta.setPixelsSizeX(new PositiveInteger(this.width), 0);
                    meta.setPixelsSizeY(new PositiveInteger(this.height), 0);
                    if (this.autoscale) {
                        store.setPixelsType(PixelType.UINT8, 0);
                    }
                    if (this.channel >= 0) {
                        meta.setPixelsSizeC(new PositiveInteger(1), 0);
                    }
                    if (this.zSection >= 0) {
                        meta.setPixelsSizeZ(new PositiveInteger(1), 0);
                    }
                    if (this.timepoint >= 0) {
                        meta.setPixelsSizeT(new PositiveInteger(1), 0);
                    }
                    this.setupResolutions(meta);
                    writer.setMetadataRetrieve(meta);
                } else {
                    for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
                        meta.setPixelsSizeX(new PositiveInteger(this.width), 0);
                        meta.setPixelsSizeY(new PositiveInteger(this.height), 0);
                        if (this.autoscale) {
                            store.setPixelsType(PixelType.UINT8, i);
                        }
                        if (this.channel >= 0) {
                            meta.setPixelsSizeC(new PositiveInteger(1), 0);
                        }
                        if (this.zSection >= 0) {
                            meta.setPixelsSizeZ(new PositiveInteger(1), 0);
                        }
                        if (this.timepoint < 0) continue;
                        meta.setPixelsSizeT(new PositiveInteger(1), 0);
                    }
                    this.setupResolutions(meta);
                    writer.setMetadataRetrieve(meta);
                }
            }
            catch (ServiceException e) {
                throw new FormatException(e);
            }
        }
        writer.setWriteSequentially(true);
        if (writer instanceof TiffWriter) {
            ((TiffWriter)writer).setBigTiff(this.bigtiff);
        } else if (writer instanceof ImageWriter && (w = ((ImageWriter)writer).getWriter(this.out)) instanceof TiffWriter) {
            ((TiffWriter)w).setBigTiff(this.bigtiff);
        }
        String format = writer.getFormat();
        LOGGER.info("[{}] -> {} [{}]", this.reader.getFormat(), this.out, format);
        long mid = System.currentTimeMillis();
        int total = 0;
        int num = writer.canDoStacks() ? this.reader.getSeriesCount() : 1;
        long read = 0L;
        long write = 0L;
        int first = this.series == -1 ? 0 : this.series;
        int last = this.series == -1 ? num : this.series + 1;
        long timeLastLogged = System.currentTimeMillis();
        for (int q = first; q < last; ++q) {
            this.reader.setSeries(q);
            boolean generatePyramid = this.pyramidResolutions > this.reader.getResolutionCount();
            int resolutionCount = generatePyramid ? this.pyramidResolutions : this.reader.getResolutionCount();
            for (int res = 0; res < resolutionCount; ++res) {
                if (!generatePyramid) {
                    this.reader.setResolution(res);
                }
                this.firstTile = true;
                if (!dimensionsSet) {
                    this.width = this.reader.getSizeX();
                    this.height = this.reader.getSizeY();
                    if (generatePyramid && res > 0) {
                        int scale = (int)Math.pow(this.pyramidScale, res);
                        this.width /= scale;
                        this.height /= scale;
                    }
                }
                int writerSeries = this.series == -1 ? q : 0;
                writer.setSeries(writerSeries);
                writer.setResolution(res);
                writer.setInterleaved(this.reader.isInterleaved() && !this.autoscale);
                writer.setValidBitsPerPixel(this.reader.getBitsPerPixel());
                int numImages = writer.canDoStacks() ? this.reader.getImageCount() : 1;
                int startPlane = Math.max(0, this.firstPlane);
                int endPlane = Math.min(numImages, this.lastPlane);
                numImages = endPlane - startPlane;
                if (this.channel >= 0) {
                    numImages /= this.reader.getEffectiveSizeC();
                }
                if (this.zSection >= 0) {
                    numImages /= this.reader.getSizeZ();
                }
                if (this.timepoint >= 0) {
                    numImages /= this.reader.getSizeT();
                }
                total += numImages;
                int count = 0;
                for (int i = startPlane; i < endPlane; ++i) {
                    int[] coords = this.reader.getZCTCoords(i);
                    if (this.zSection >= 0 && coords[0] != this.zSection || this.channel >= 0 && coords[1] != this.channel || this.timepoint >= 0 && coords[2] != this.timepoint) continue;
                    String outputName = FormatTools.getFilename(q, i, this.reader, this.out, this.zeroPadding);
                    if (outputName.equals(FormatTools.getTileFilename(0, 0, 0, outputName))) {
                        writer.setId(outputName);
                        if (this.compression != null) {
                            writer.setCompression(this.compression);
                        }
                    } else {
                        int tileNum = outputName.indexOf("%m");
                        int tileX = outputName.indexOf("%x");
                        int tileY = outputName.indexOf("%y");
                        if (tileNum < 0 && (tileX < 0 || tileY < 0)) {
                            throw new FormatException("Invalid file name pattern; %m or both of %x and %y must be specified.");
                        }
                    }
                    int outputIndex = 0;
                    if (this.nextOutputIndex.containsKey(outputName)) {
                        outputIndex = this.nextOutputIndex.get(outputName);
                    }
                    long s2 = System.currentTimeMillis();
                    long m3 = this.convertPlane(writer, i, outputIndex, outputName);
                    long e = System.currentTimeMillis();
                    read += m3 - s2;
                    write += e - m3;
                    this.nextOutputIndex.put(outputName, outputIndex + 1);
                    if (i == endPlane - 1) {
                        this.nextOutputIndex.remove(outputName);
                    }
                    if (count == numImages - 1 || (e - timeLastLogged) / 1000L > 0L) {
                        int current = count - startPlane + 1;
                        int percent = 100 * current / numImages;
                        StringBuilder sb = new StringBuilder();
                        sb.append("\t");
                        int numSeries = last - first;
                        if (numSeries > 1) {
                            sb.append("Series ");
                            sb.append(q);
                            sb.append(": converted ");
                        } else {
                            sb.append("Converted ");
                        }
                        LOGGER.info(sb.toString() + "{}/{} planes ({}%)", current, numImages, percent);
                        timeLastLogged = e;
                    }
                    ++count;
                }
            }
        }
        writer.close();
        long end = System.currentTimeMillis();
        LOGGER.info("[done]");
        float sec = (float)(end - start) / 1000.0f;
        long initial = mid - start;
        float readAvg = (float)read / (float)total;
        float writeAvg = (float)write / (float)total;
        LOGGER.info("{}s elapsed ({}+{}ms per plane, {}ms overhead)", Float.valueOf(sec), Float.valueOf(readAvg), Float.valueOf(writeAvg), initial);
        return true;
    }

    private long convertPlane(IFormatWriter writer, int index, int outputIndex, String currentFile) throws FormatException, IOException {
        if ((DataTools.safeMultiply64(this.width, this.height) >= DataTools.safeMultiply64(4096L, 4096L) || this.saveTileWidth > 0 || this.saveTileHeight > 0) && (writer instanceof TiffWriter || writer instanceof ImageWriter && ((ImageWriter)writer).getWriter(this.out) instanceof TiffWriter)) {
            return this.convertTilePlane(writer, index, outputIndex, currentFile);
        }
        byte[] buf = this.getTile(this.reader, writer.getResolution(), index, this.xCoordinate, this.yCoordinate, this.width, this.height);
        this.autoscalePlane(buf, index);
        this.applyLUT(writer);
        long m3 = System.currentTimeMillis();
        writer.saveBytes(outputIndex, buf);
        return m3;
    }

    private long convertTilePlane(IFormatWriter writer, int index, int outputIndex, String currentFile) throws FormatException, IOException {
        int w = this.reader.getOptimalTileWidth();
        int h2 = this.reader.getOptimalTileHeight();
        if (this.saveTileWidth > 0 && this.saveTileWidth <= this.width) {
            w = this.saveTileWidth;
        }
        if (this.saveTileHeight > 0 && this.saveTileHeight <= this.height) {
            h2 = this.saveTileHeight;
        }
        if (this.firstTile) {
            LOGGER.info("Tile size = {} x {}", (Object)w, (Object)h2);
            this.firstTile = false;
        }
        int nXTiles = this.width / w;
        int nYTiles = this.height / h2;
        if (nXTiles * w != this.width) {
            ++nXTiles;
        }
        if (nYTiles * h2 != this.height) {
            ++nYTiles;
        }
        IFD ifd = new IFD();
        ifd.put(322, w);
        ifd.put(323, h2);
        Long m3 = null;
        for (int y = 0; y < nYTiles; ++y) {
            for (int x = 0; x < nXTiles; ++x) {
                IFormatWriter baseWriter;
                int tileX = this.xCoordinate + x * w;
                int tileY = this.yCoordinate + y * h2;
                int tileWidth = x < nXTiles - 1 ? w : this.width - w * x;
                int tileHeight = y < nYTiles - 1 ? h2 : this.height - h2 * y;
                byte[] buf = this.getTile(this.reader, writer.getResolution(), index, tileX, tileY, tileWidth, tileHeight);
                String tileName = FormatTools.getTileFilename(x, y, y * nXTiles + x, currentFile);
                if (!currentFile.equals(tileName)) {
                    int nTileRows = this.getTileRows(currentFile);
                    int nTileCols = this.getTileColumns(currentFile);
                    int sizeX = nTileCols == 1 ? this.width : tileWidth;
                    int sizeY = nTileRows == 1 ? this.height : tileHeight;
                    MetadataRetrieve retrieve = writer.getMetadataRetrieve();
                    if (retrieve instanceof MetadataStore) {
                        ((MetadataStore)((Object)retrieve)).setPixelsSizeX(new PositiveInteger(sizeX), this.reader.getSeries());
                        ((MetadataStore)((Object)retrieve)).setPixelsSizeY(new PositiveInteger(sizeY), this.reader.getSeries());
                        this.setupResolutions((IMetadata)retrieve);
                    }
                    writer.close();
                    writer.setMetadataRetrieve(retrieve);
                    writer.setId(tileName);
                    if (this.compression != null) {
                        writer.setCompression(this.compression);
                    }
                    outputIndex = 0;
                    if (this.nextOutputIndex.containsKey(tileName)) {
                        outputIndex = this.nextOutputIndex.get(tileName);
                    }
                    this.nextOutputIndex.put(tileName, outputIndex + 1);
                    if (nTileRows > 1) {
                        tileY = 0;
                    }
                    if (nTileCols > 1) {
                        tileX = 0;
                    }
                }
                this.autoscalePlane(buf, index);
                this.applyLUT(writer);
                if (m3 == null) {
                    m3 = System.currentTimeMillis();
                }
                if (writer instanceof TiffWriter) {
                    ((TiffWriter)writer).saveBytes(outputIndex, buf, ifd, tileX, tileY, tileWidth, tileHeight);
                    continue;
                }
                if (!(writer instanceof ImageWriter) || !((baseWriter = ((ImageWriter)writer).getWriter(this.out)) instanceof TiffWriter)) continue;
                ((TiffWriter)baseWriter).saveBytes(outputIndex, buf, ifd, tileX, tileY, tileWidth, tileHeight);
            }
        }
        return m3;
    }

    private int getTileRows(String outputName) {
        if (outputName.indexOf("%y") >= 0 || outputName.indexOf("%m") >= 0) {
            int nYTiles;
            int h2 = this.reader.getOptimalTileHeight();
            if (this.saveTileHeight > 0 && this.saveTileHeight <= this.height) {
                h2 = this.saveTileHeight;
            }
            if ((nYTiles = this.height / h2) * h2 != this.height) {
                ++nYTiles;
            }
            return nYTiles;
        }
        return 1;
    }

    public int getTileColumns(String outputName) {
        if (outputName.indexOf("%x") >= 0 || outputName.indexOf("%m") >= 0) {
            int nXTiles;
            int w = this.reader.getOptimalTileWidth();
            if (this.saveTileWidth > 0 && this.saveTileWidth <= this.width) {
                w = this.saveTileWidth;
            }
            if ((nXTiles = this.width / w) * w != this.width) {
                ++nXTiles;
            }
            return nXTiles;
        }
        return 1;
    }

    private void autoscalePlane(byte[] buf, int index) throws FormatException, IOException {
        if (this.autoscale) {
            Double min2 = null;
            Double max = null;
            Double[] planeMin = this.minMax.getPlaneMinimum(index);
            Double[] planeMax = this.minMax.getPlaneMaximum(index);
            if (planeMin != null && planeMax != null) {
                min2 = planeMin[0];
                max = planeMax[0];
                for (int j = 1; j < planeMin.length; ++j) {
                    if (planeMin[j] < min2) {
                        min2 = planeMin[j];
                    }
                    if (!(planeMax[j] < max)) continue;
                    max = planeMax[j];
                }
            }
            int pixelType = this.reader.getPixelType();
            int bpp = FormatTools.getBytesPerPixel(pixelType);
            boolean floatingPoint = FormatTools.isFloatingPoint(pixelType);
            Object pix = DataTools.makeDataArray(buf, bpp, floatingPoint, this.reader.isLittleEndian());
            byte[][] b = ImageTools.make24Bits(pix, this.width, this.height, this.reader.isInterleaved(), false, min2, max);
            int channelCount = this.reader.getRGBChannelCount();
            int copyComponents = Math.min(channelCount, b.length);
            buf = new byte[channelCount * b[0].length];
            for (int j = 0; j < copyComponents; ++j) {
                System.arraycopy(b[j], 0, buf, b[0].length * j, b[0].length);
            }
        }
    }

    private void applyLUT(IFormatWriter writer) throws FormatException, IOException {
        if (this.lookup) {
            byte[][] lut = this.reader.get8BitLookupTable();
            if (lut != null) {
                IndexColorModel model = new IndexColorModel(8, lut[0].length, lut[0], lut[1], lut[2]);
                writer.setColorModel(model);
            } else {
                short[][] lut16 = this.reader.get16BitLookupTable();
                if (lut16 != null) {
                    Index16ColorModel model = new Index16ColorModel(16, lut16[0].length, lut16, this.reader.isLittleEndian());
                    writer.setColorModel(model);
                }
            }
        }
    }

    private void setupResolutions(IMetadata meta) {
        if (!(meta instanceof OMEPyramidStore)) {
            return;
        }
        for (int series = 0; series < meta.getImageCount(); ++series) {
            int width = (Integer)meta.getPixelsSizeX(series).getValue();
            int height = (Integer)meta.getPixelsSizeY(series).getValue();
            for (int i = 1; i < this.pyramidResolutions; ++i) {
                int scale = (int)Math.pow(this.pyramidScale, i);
                ((OMEPyramidStore)meta).setResolutionSizeX(new PositiveInteger(width / scale), series, i);
                ((OMEPyramidStore)meta).setResolutionSizeY(new PositiveInteger(height / scale), series, i);
            }
        }
    }

    private byte[] getTile(IFormatReader reader, int resolution, int no, int x, int y, int w, int h2) throws FormatException, IOException {
        if (resolution < reader.getResolutionCount()) {
            reader.setResolution(resolution);
            return reader.openBytes(no, x, y, w, h2);
        }
        reader.setResolution(0);
        SimpleImageScaler scaler = new SimpleImageScaler();
        int scale = (int)Math.pow(this.pyramidScale, resolution);
        byte[] tile = reader.openBytes(no, x * scale, y * scale, w * scale, h2 * scale);
        int type = reader.getPixelType();
        return scaler.downsample(tile, w * scale, h2 * scale, scale, FormatTools.getBytesPerPixel(type), reader.isLittleEndian(), FormatTools.isFloatingPoint(type), reader.getRGBChannelCount(), reader.isInterleaved());
    }

    public static void main(String[] args) throws FormatException, IOException {
        DebugTools.enableLogging("INFO");
        ImageConverter converter = new ImageConverter();
        if (!converter.testConvert(new ImageWriter(), args)) {
            System.exit(1);
        }
        System.exit(0);
    }
}

