/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import net.jcip.annotations.ThreadSafe;
import thredds.inventory.MFile;
import ucar.unidata.util.StringUtil2;

@ThreadSafe
public class MFileOS7
implements MFile {
    private final Path path;
    private final BasicFileAttributes attr;
    private Object auxInfo;

    public static MFileOS7 getExistingFile(String filename) throws IOException {
        if (filename == null) {
            return null;
        }
        Path path = Paths.get(filename, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            return new MFileOS7(path);
        }
        return null;
    }

    public MFileOS7(Path path) throws IOException {
        this.path = path;
        this.attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
    }

    public MFileOS7(Path path, BasicFileAttributes attr) {
        this.path = path;
        this.attr = attr;
    }

    public MFileOS7(String filename) throws IOException {
        this.path = Paths.get(filename, new String[0]);
        this.attr = Files.readAttributes(this.path, BasicFileAttributes.class, new LinkOption[0]);
    }

    @Override
    public long getLastModified() {
        return this.attr.lastModifiedTime().toMillis();
    }

    @Override
    public long getLength() {
        return this.attr.size();
    }

    @Override
    public boolean isDirectory() {
        return this.attr.isDirectory();
    }

    @Override
    public String getPath() {
        return StringUtil2.replace(this.path.toString(), '\\', "/");
    }

    @Override
    public String getName() {
        return this.path.getFileName().toString();
    }

    @Override
    public MFile getParent() throws IOException {
        return new MFileOS7(this.path.getParent());
    }

    @Override
    public int compareTo(MFile o) {
        return this.getPath().compareTo(o.getPath());
    }

    @Override
    public Object getAuxInfo() {
        return this.auxInfo;
    }

    @Override
    public void setAuxInfo(Object auxInfo) {
        this.auxInfo = auxInfo;
    }

    public String toString() {
        return this.getPath();
    }

    public Path getNioPath() {
        return this.path;
    }
}

