# coding: utf-8

"""
    authentik

    Making authentication simple.

    The version of the OpenAPI document: 2025.10.0-rc1
    Contact: hello@goauthentik.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class Version(BaseModel):
    """
    Get running and latest version.
    """ # noqa: E501
    version_current: StrictStr = Field(description="Get current version")
    version_latest: StrictStr = Field(description="Get latest version from cache")
    version_latest_valid: StrictBool = Field(description="Check if latest version is valid")
    build_hash: StrictStr = Field(description="Get build hash, if version is not latest or released")
    outdated: StrictBool = Field(description="Check if we're running the latest version")
    outpost_outdated: StrictBool = Field(description="Check if any outpost is outdated/has a version mismatch")
    __properties: ClassVar[List[str]] = ["version_current", "version_latest", "version_latest_valid", "build_hash", "outdated", "outpost_outdated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Version from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "version_current",
            "version_latest",
            "version_latest_valid",
            "build_hash",
            "outdated",
            "outpost_outdated",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Version from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "version_current": obj.get("version_current"),
            "version_latest": obj.get("version_latest"),
            "version_latest_valid": obj.get("version_latest_valid"),
            "build_hash": obj.get("build_hash"),
            "outdated": obj.get("outdated"),
            "outpost_outdated": obj.get("outpost_outdated")
        })
        return _obj


