"""
Flet Cupertino Icons

To generate/update this file run from the root of the repository:

```
uv run .github/scripts/generate_icons.py
```
"""

from flet.controls.icon_data import IconData

__all__ = ["CupertinoIcons"]


class CupertinoIcons(IconData, package_name="flet", class_name="CupertinoIcons"):
    ADD = 0x20000
    ADD_CIRCLED = 0x20001
    ADD_CIRCLED_SOLID = 0x20002
    AIRPLANE = 0x20003
    ALARM = 0x20004
    ALARM_FILL = 0x20005
    ALT = 0x20006
    ANT = 0x20007
    ANT_CIRCLE = 0x20008
    ANT_CIRCLE_FILL = 0x20009
    ANT_FILL = 0x2000A
    ANTENNA_RADIOWAVES_LEFT_RIGHT = 0x2000B
    APP = 0x2000C
    APP_BADGE = 0x2000D
    APP_BADGE_FILL = 0x2000E
    APP_FILL = 0x2000F
    ARCHIVEBOX = 0x20010
    ARCHIVEBOX_FILL = 0x20011
    ARROW_2_CIRCLEPATH = 0x20012
    ARROW_2_CIRCLEPATH_CIRCLE = 0x20013
    ARROW_2_CIRCLEPATH_CIRCLE_FILL = 0x20014
    ARROW_2_SQUAREPATH = 0x20015
    ARROW_3_TRIANGLEPATH = 0x20016
    ARROW_BRANCH = 0x20017
    ARROW_CLOCKWISE = 0x20018
    ARROW_CLOCKWISE_CIRCLE = 0x20019
    ARROW_CLOCKWISE_CIRCLE_FILL = 0x2001A
    ARROW_COUNTERCLOCKWISE = 0x2001B
    ARROW_COUNTERCLOCKWISE_CIRCLE = 0x2001C
    ARROW_COUNTERCLOCKWISE_CIRCLE_FILL = 0x2001D
    ARROW_DOWN = 0x2001E
    ARROW_DOWN_CIRCLE = 0x2001F
    ARROW_DOWN_CIRCLE_FILL = 0x20020
    ARROW_DOWN_DOC = 0x20021
    ARROW_DOWN_DOC_FILL = 0x20022
    ARROW_DOWN_LEFT = 0x20023
    ARROW_DOWN_LEFT_CIRCLE = 0x20024
    ARROW_DOWN_LEFT_CIRCLE_FILL = 0x20025
    ARROW_DOWN_LEFT_SQUARE = 0x20026
    ARROW_DOWN_LEFT_SQUARE_FILL = 0x20027
    ARROW_DOWN_RIGHT = 0x20028
    ARROW_DOWN_RIGHT_ARROW_UP_LEFT = 0x20029
    ARROW_DOWN_RIGHT_CIRCLE = 0x2002A
    ARROW_DOWN_RIGHT_CIRCLE_FILL = 0x2002B
    ARROW_DOWN_RIGHT_SQUARE = 0x2002C
    ARROW_DOWN_RIGHT_SQUARE_FILL = 0x2002D
    ARROW_DOWN_SQUARE = 0x2002E
    ARROW_DOWN_SQUARE_FILL = 0x2002F
    ARROW_DOWN_TO_LINE = 0x20030
    ARROW_DOWN_TO_LINE_ALT = 0x20031
    ARROW_LEFT = 0x20032
    ARROW_LEFT_CIRCLE = 0x20033
    ARROW_LEFT_CIRCLE_FILL = 0x20034
    ARROW_LEFT_RIGHT = 0x20035
    ARROW_LEFT_RIGHT_CIRCLE = 0x20036
    ARROW_LEFT_RIGHT_CIRCLE_FILL = 0x20037
    ARROW_LEFT_RIGHT_SQUARE = 0x20038
    ARROW_LEFT_RIGHT_SQUARE_FILL = 0x20039
    ARROW_LEFT_SQUARE = 0x2003A
    ARROW_LEFT_SQUARE_FILL = 0x2003B
    ARROW_LEFT_TO_LINE = 0x2003C
    ARROW_LEFT_TO_LINE_ALT = 0x2003D
    ARROW_MERGE = 0x2003E
    ARROW_RIGHT = 0x2003F
    ARROW_RIGHT_ARROW_LEFT = 0x20040
    ARROW_RIGHT_ARROW_LEFT_CIRCLE = 0x20041
    ARROW_RIGHT_ARROW_LEFT_CIRCLE_FILL = 0x20042
    ARROW_RIGHT_ARROW_LEFT_SQUARE = 0x20043
    ARROW_RIGHT_ARROW_LEFT_SQUARE_FILL = 0x20044
    ARROW_RIGHT_CIRCLE = 0x20045
    ARROW_RIGHT_CIRCLE_FILL = 0x20046
    ARROW_RIGHT_SQUARE = 0x20047
    ARROW_RIGHT_SQUARE_FILL = 0x20048
    ARROW_RIGHT_TO_LINE = 0x20049
    ARROW_RIGHT_TO_LINE_ALT = 0x2004A
    ARROW_SWAP = 0x2004B
    ARROW_TURN_DOWN_LEFT = 0x2004C
    ARROW_TURN_DOWN_RIGHT = 0x2004D
    ARROW_TURN_LEFT_DOWN = 0x2004E
    ARROW_TURN_LEFT_UP = 0x2004F
    ARROW_TURN_RIGHT_DOWN = 0x20050
    ARROW_TURN_RIGHT_UP = 0x20051
    ARROW_TURN_UP_LEFT = 0x20052
    ARROW_TURN_UP_RIGHT = 0x20053
    ARROW_UP = 0x20054
    ARROW_UP_ARROW_DOWN = 0x20055
    ARROW_UP_ARROW_DOWN_CIRCLE = 0x20056
    ARROW_UP_ARROW_DOWN_CIRCLE_FILL = 0x20057
    ARROW_UP_ARROW_DOWN_SQUARE = 0x20058
    ARROW_UP_ARROW_DOWN_SQUARE_FILL = 0x20059
    ARROW_UP_BIN = 0x2005A
    ARROW_UP_BIN_FILL = 0x2005B
    ARROW_UP_CIRCLE = 0x2005C
    ARROW_UP_CIRCLE_FILL = 0x2005D
    ARROW_UP_DOC = 0x2005E
    ARROW_UP_DOC_FILL = 0x2005F
    ARROW_UP_DOWN = 0x20060
    ARROW_UP_DOWN_CIRCLE = 0x20061
    ARROW_UP_DOWN_CIRCLE_FILL = 0x20062
    ARROW_UP_DOWN_SQUARE = 0x20063
    ARROW_UP_DOWN_SQUARE_FILL = 0x20064
    ARROW_UP_LEFT = 0x20065
    ARROW_UP_LEFT_ARROW_DOWN_RIGHT = 0x20066
    ARROW_UP_LEFT_CIRCLE = 0x20067
    ARROW_UP_LEFT_CIRCLE_FILL = 0x20068
    ARROW_UP_LEFT_SQUARE = 0x20069
    ARROW_UP_LEFT_SQUARE_FILL = 0x2006A
    ARROW_UP_RIGHT = 0x2006B
    ARROW_UP_RIGHT_CIRCLE = 0x2006C
    ARROW_UP_RIGHT_CIRCLE_FILL = 0x2006D
    ARROW_UP_RIGHT_DIAMOND = 0x2006E
    ARROW_UP_RIGHT_DIAMOND_FILL = 0x2006F
    ARROW_UP_RIGHT_SQUARE = 0x20070
    ARROW_UP_RIGHT_SQUARE_FILL = 0x20071
    ARROW_UP_SQUARE = 0x20072
    ARROW_UP_SQUARE_FILL = 0x20073
    ARROW_UP_TO_LINE = 0x20074
    ARROW_UP_TO_LINE_ALT = 0x20075
    ARROW_UTURN_DOWN = 0x20076
    ARROW_UTURN_DOWN_CIRCLE = 0x20077
    ARROW_UTURN_DOWN_CIRCLE_FILL = 0x20078
    ARROW_UTURN_DOWN_SQUARE = 0x20079
    ARROW_UTURN_DOWN_SQUARE_FILL = 0x2007A
    ARROW_UTURN_LEFT = 0x2007B
    ARROW_UTURN_LEFT_CIRCLE = 0x2007C
    ARROW_UTURN_LEFT_CIRCLE_FILL = 0x2007D
    ARROW_UTURN_LEFT_SQUARE = 0x2007E
    ARROW_UTURN_LEFT_SQUARE_FILL = 0x2007F
    ARROW_UTURN_RIGHT = 0x20080
    ARROW_UTURN_RIGHT_CIRCLE = 0x20081
    ARROW_UTURN_RIGHT_CIRCLE_FILL = 0x20082
    ARROW_UTURN_RIGHT_SQUARE = 0x20083
    ARROW_UTURN_RIGHT_SQUARE_FILL = 0x20084
    ARROW_UTURN_UP = 0x20085
    ARROW_UTURN_UP_CIRCLE = 0x20086
    ARROW_UTURN_UP_CIRCLE_FILL = 0x20087
    ARROW_UTURN_UP_SQUARE = 0x20088
    ARROW_UTURN_UP_SQUARE_FILL = 0x20089
    ARROWSHAPE_TURN_UP_LEFT = 0x2008A
    ARROWSHAPE_TURN_UP_LEFT_2 = 0x2008B
    ARROWSHAPE_TURN_UP_LEFT_2_FILL = 0x2008C
    ARROWSHAPE_TURN_UP_LEFT_CIRCLE = 0x2008D
    ARROWSHAPE_TURN_UP_LEFT_CIRCLE_FILL = 0x2008E
    ARROWSHAPE_TURN_UP_LEFT_FILL = 0x2008F
    ARROWSHAPE_TURN_UP_RIGHT = 0x20090
    ARROWSHAPE_TURN_UP_RIGHT_CIRCLE = 0x20091
    ARROWSHAPE_TURN_UP_RIGHT_CIRCLE_FILL = 0x20092
    ARROWSHAPE_TURN_UP_RIGHT_FILL = 0x20093
    ARROWTRIANGLE_DOWN = 0x20094
    ARROWTRIANGLE_DOWN_CIRCLE = 0x20095
    ARROWTRIANGLE_DOWN_CIRCLE_FILL = 0x20096
    ARROWTRIANGLE_DOWN_FILL = 0x20097
    ARROWTRIANGLE_DOWN_SQUARE = 0x20098
    ARROWTRIANGLE_DOWN_SQUARE_FILL = 0x20099
    ARROWTRIANGLE_LEFT = 0x2009A
    ARROWTRIANGLE_LEFT_CIRCLE = 0x2009B
    ARROWTRIANGLE_LEFT_CIRCLE_FILL = 0x2009C
    ARROWTRIANGLE_LEFT_FILL = 0x2009D
    ARROWTRIANGLE_LEFT_SQUARE = 0x2009E
    ARROWTRIANGLE_LEFT_SQUARE_FILL = 0x2009F
    ARROWTRIANGLE_RIGHT = 0x200A0
    ARROWTRIANGLE_RIGHT_CIRCLE = 0x200A1
    ARROWTRIANGLE_RIGHT_CIRCLE_FILL = 0x200A2
    ARROWTRIANGLE_RIGHT_FILL = 0x200A3
    ARROWTRIANGLE_RIGHT_SQUARE = 0x200A4
    ARROWTRIANGLE_RIGHT_SQUARE_FILL = 0x200A5
    ARROWTRIANGLE_UP = 0x200A6
    ARROWTRIANGLE_UP_CIRCLE = 0x200A7
    ARROWTRIANGLE_UP_CIRCLE_FILL = 0x200A8
    ARROWTRIANGLE_UP_FILL = 0x200A9
    ARROWTRIANGLE_UP_SQUARE = 0x200AA
    ARROWTRIANGLE_UP_SQUARE_FILL = 0x200AB
    ASTERISK_CIRCLE = 0x200AC
    ASTERISK_CIRCLE_FILL = 0x200AD
    AT = 0x200AE
    AT_BADGE_MINUS = 0x200AF
    AT_BADGE_PLUS = 0x200B0
    AT_CIRCLE = 0x200B1
    AT_CIRCLE_FILL = 0x200B2
    BACK = 0x200B3
    BACKWARD = 0x200B4
    BACKWARD_END = 0x200B5
    BACKWARD_END_ALT = 0x200B6
    BACKWARD_END_ALT_FILL = 0x200B7
    BACKWARD_END_FILL = 0x200B8
    BACKWARD_FILL = 0x200B9
    BADGE_PLUS_RADIOWAVES_RIGHT = 0x200BA
    BAG = 0x200BB
    BAG_BADGE_MINUS = 0x200BC
    BAG_BADGE_PLUS = 0x200BD
    BAG_FILL = 0x200BE
    BAG_FILL_BADGE_MINUS = 0x200BF
    BAG_FILL_BADGE_PLUS = 0x200C0
    BANDAGE = 0x200C1
    BANDAGE_FILL = 0x200C2
    BARCODE = 0x200C3
    BARCODE_VIEWFINDER = 0x200C4
    BARS = 0x200C5
    BATTERY_0 = 0x200C6
    BATTERY_100 = 0x200C7
    BATTERY_25 = 0x200C8
    BATTERY_25_PERCENT = 0x200C9
    BATTERY_75_PERCENT = 0x200CA
    BATTERY_CHARGING = 0x200CB
    BATTERY_EMPTY = 0x200CC
    BATTERY_FULL = 0x200CD
    BED_DOUBLE = 0x200CE
    BED_DOUBLE_FILL = 0x200CF
    BELL = 0x200D0
    BELL_CIRCLE = 0x200D1
    BELL_CIRCLE_FILL = 0x200D2
    BELL_FILL = 0x200D3
    BELL_SLASH = 0x200D4
    BELL_SLASH_FILL = 0x200D5
    BELL_SOLID = 0x200D6
    BIN_XMARK = 0x200D7
    BIN_XMARK_FILL = 0x200D8
    BITCOIN = 0x200D9
    BITCOIN_CIRCLE = 0x200DA
    BITCOIN_CIRCLE_FILL = 0x200DB
    BLUETOOTH = 0x200DC
    BOLD = 0x200DD
    BOLD_ITALIC_UNDERLINE = 0x200DE
    BOLD_UNDERLINE = 0x200DF
    BOLT = 0x200E0
    BOLT_BADGE_A = 0x200E1
    BOLT_BADGE_A_FILL = 0x200E2
    BOLT_CIRCLE = 0x200E3
    BOLT_CIRCLE_FILL = 0x200E4
    BOLT_FILL = 0x200E5
    BOLT_HORIZONTAL = 0x200E6
    BOLT_HORIZONTAL_CIRCLE = 0x200E7
    BOLT_HORIZONTAL_CIRCLE_FILL = 0x200E8
    BOLT_HORIZONTAL_FILL = 0x200E9
    BOLT_SLASH = 0x200EA
    BOLT_SLASH_FILL = 0x200EB
    BOOK = 0x200EC
    BOOK_CIRCLE = 0x200ED
    BOOK_CIRCLE_FILL = 0x200EE
    BOOK_FILL = 0x200EF
    BOOK_SOLID = 0x200F0
    BOOKMARK = 0x200F1
    BOOKMARK_FILL = 0x200F2
    BOOKMARK_SOLID = 0x200F3
    BRIEFCASE = 0x200F4
    BRIEFCASE_FILL = 0x200F5
    BRIGHTNESS = 0x200F6
    BRIGHTNESS_SOLID = 0x200F7
    BUBBLE_LEFT = 0x200F8
    BUBBLE_LEFT_BUBBLE_RIGHT = 0x200F9
    BUBBLE_LEFT_BUBBLE_RIGHT_FILL = 0x200FA
    BUBBLE_LEFT_FILL = 0x200FB
    BUBBLE_MIDDLE_BOTTOM = 0x200FC
    BUBBLE_MIDDLE_BOTTOM_FILL = 0x200FD
    BUBBLE_MIDDLE_TOP = 0x200FE
    BUBBLE_MIDDLE_TOP_FILL = 0x200FF
    BUBBLE_RIGHT = 0x20100
    BUBBLE_RIGHT_FILL = 0x20101
    BUILDING_2_FILL = 0x20102
    BURN = 0x20103
    BURST = 0x20104
    BURST_FILL = 0x20105
    BUS = 0x20106
    CALENDAR = 0x20107
    CALENDAR_BADGE_MINUS = 0x20108
    CALENDAR_BADGE_PLUS = 0x20109
    CALENDAR_CIRCLE = 0x2010A
    CALENDAR_CIRCLE_FILL = 0x2010B
    CALENDAR_TODAY = 0x2010C
    CAMERA = 0x2010D
    CAMERA_CIRCLE = 0x2010E
    CAMERA_CIRCLE_FILL = 0x2010F
    CAMERA_FILL = 0x20110
    CAMERA_ON_RECTANGLE = 0x20111
    CAMERA_ON_RECTANGLE_FILL = 0x20112
    CAMERA_ROTATE = 0x20113
    CAMERA_ROTATE_FILL = 0x20114
    CAMERA_VIEWFINDER = 0x20115
    CAPSLOCK = 0x20116
    CAPSLOCK_FILL = 0x20117
    CAPSULE = 0x20118
    CAPSULE_FILL = 0x20119
    CAPTIONS_BUBBLE = 0x2011A
    CAPTIONS_BUBBLE_FILL = 0x2011B
    CAR = 0x2011C
    CAR_DETAILED = 0x2011D
    CAR_FILL = 0x2011E
    CART = 0x2011F
    CART_BADGE_MINUS = 0x20120
    CART_BADGE_PLUS = 0x20121
    CART_FILL = 0x20122
    CART_FILL_BADGE_MINUS = 0x20123
    CART_FILL_BADGE_PLUS = 0x20124
    CHART_BAR = 0x20125
    CHART_BAR_ALT_FILL = 0x20126
    CHART_BAR_CIRCLE = 0x20127
    CHART_BAR_CIRCLE_FILL = 0x20128
    CHART_BAR_FILL = 0x20129
    CHART_BAR_SQUARE = 0x2012A
    CHART_BAR_SQUARE_FILL = 0x2012B
    CHART_PIE = 0x2012C
    CHART_PIE_FILL = 0x2012D
    CHAT_BUBBLE = 0x2012E
    CHAT_BUBBLE_2 = 0x2012F
    CHAT_BUBBLE_2_FILL = 0x20130
    CHAT_BUBBLE_FILL = 0x20131
    CHAT_BUBBLE_TEXT = 0x20132
    CHAT_BUBBLE_TEXT_FILL = 0x20133
    CHECK_MARK = 0x20134
    CHECK_MARK_CIRCLED = 0x20135
    CHECK_MARK_CIRCLED_SOLID = 0x20136
    CHECKMARK = 0x20137
    CHECKMARK_ALT = 0x20138
    CHECKMARK_ALT_CIRCLE = 0x20139
    CHECKMARK_ALT_CIRCLE_FILL = 0x2013A
    CHECKMARK_CIRCLE = 0x2013B
    CHECKMARK_CIRCLE_FILL = 0x2013C
    CHECKMARK_RECTANGLE = 0x2013D
    CHECKMARK_RECTANGLE_FILL = 0x2013E
    CHECKMARK_SEAL = 0x2013F
    CHECKMARK_SEAL_FILL = 0x20140
    CHECKMARK_SHIELD = 0x20141
    CHECKMARK_SHIELD_FILL = 0x20142
    CHECKMARK_SQUARE = 0x20143
    CHECKMARK_SQUARE_FILL = 0x20144
    CHEVRON_BACK = 0x20145
    CHEVRON_COMPACT_DOWN = 0x20146
    CHEVRON_COMPACT_LEFT = 0x20147
    CHEVRON_COMPACT_RIGHT = 0x20148
    CHEVRON_COMPACT_UP = 0x20149
    CHEVRON_DOWN = 0x2014A
    CHEVRON_DOWN_CIRCLE = 0x2014B
    CHEVRON_DOWN_CIRCLE_FILL = 0x2014C
    CHEVRON_DOWN_SQUARE = 0x2014D
    CHEVRON_DOWN_SQUARE_FILL = 0x2014E
    CHEVRON_FORWARD = 0x2014F
    CHEVRON_LEFT = 0x20150
    CHEVRON_LEFT_2 = 0x20151
    CHEVRON_LEFT_CIRCLE = 0x20152
    CHEVRON_LEFT_CIRCLE_FILL = 0x20153
    CHEVRON_LEFT_SLASH_CHEVRON_RIGHT = 0x20154
    CHEVRON_LEFT_SQUARE = 0x20155
    CHEVRON_LEFT_SQUARE_FILL = 0x20156
    CHEVRON_RIGHT = 0x20157
    CHEVRON_RIGHT_2 = 0x20158
    CHEVRON_RIGHT_CIRCLE = 0x20159
    CHEVRON_RIGHT_CIRCLE_FILL = 0x2015A
    CHEVRON_RIGHT_SQUARE = 0x2015B
    CHEVRON_RIGHT_SQUARE_FILL = 0x2015C
    CHEVRON_UP = 0x2015D
    CHEVRON_UP_CHEVRON_DOWN = 0x2015E
    CHEVRON_UP_CIRCLE = 0x2015F
    CHEVRON_UP_CIRCLE_FILL = 0x20160
    CHEVRON_UP_SQUARE = 0x20161
    CHEVRON_UP_SQUARE_FILL = 0x20162
    CIRCLE = 0x20163
    CIRCLE_BOTTOMTHIRD_SPLIT = 0x20164
    CIRCLE_FILL = 0x20165
    CIRCLE_FILLED = 0x20166
    CIRCLE_GRID_3X3 = 0x20167
    CIRCLE_GRID_3X3_FILL = 0x20168
    CIRCLE_GRID_HEX = 0x20169
    CIRCLE_GRID_HEX_FILL = 0x2016A
    CIRCLE_LEFTHALF_FILL = 0x2016B
    CIRCLE_RIGHTHALF_FILL = 0x2016C
    CLEAR = 0x2016D
    CLEAR_CIRCLED = 0x2016E
    CLEAR_CIRCLED_SOLID = 0x2016F
    CLEAR_FILL = 0x20170
    CLEAR_THICK = 0x20171
    CLEAR_THICK_CIRCLED = 0x20172
    CLOCK = 0x20173
    CLOCK_FILL = 0x20174
    CLOCK_SOLID = 0x20175
    CLOUD = 0x20176
    CLOUD_BOLT = 0x20177
    CLOUD_BOLT_FILL = 0x20178
    CLOUD_BOLT_RAIN = 0x20179
    CLOUD_BOLT_RAIN_FILL = 0x2017A
    CLOUD_DOWNLOAD = 0x2017B
    CLOUD_DOWNLOAD_FILL = 0x2017C
    CLOUD_DRIZZLE = 0x2017D
    CLOUD_DRIZZLE_FILL = 0x2017E
    CLOUD_FILL = 0x2017F
    CLOUD_FOG = 0x20180
    CLOUD_FOG_FILL = 0x20181
    CLOUD_HAIL = 0x20182
    CLOUD_HAIL_FILL = 0x20183
    CLOUD_HEAVYRAIN = 0x20184
    CLOUD_HEAVYRAIN_FILL = 0x20185
    CLOUD_MOON = 0x20186
    CLOUD_MOON_BOLT = 0x20187
    CLOUD_MOON_BOLT_FILL = 0x20188
    CLOUD_MOON_FILL = 0x20189
    CLOUD_MOON_RAIN = 0x2018A
    CLOUD_MOON_RAIN_FILL = 0x2018B
    CLOUD_RAIN = 0x2018C
    CLOUD_RAIN_FILL = 0x2018D
    CLOUD_SLEET = 0x2018E
    CLOUD_SLEET_FILL = 0x2018F
    CLOUD_SNOW = 0x20190
    CLOUD_SNOW_FILL = 0x20191
    CLOUD_SUN = 0x20192
    CLOUD_SUN_BOLT = 0x20193
    CLOUD_SUN_BOLT_FILL = 0x20194
    CLOUD_SUN_FILL = 0x20195
    CLOUD_SUN_RAIN = 0x20196
    CLOUD_SUN_RAIN_FILL = 0x20197
    CLOUD_UPLOAD = 0x20198
    CLOUD_UPLOAD_FILL = 0x20199
    COLLECTIONS = 0x2019A
    COLLECTIONS_SOLID = 0x2019B
    COLOR_FILTER = 0x2019C
    COLOR_FILTER_FILL = 0x2019D
    COMMAND = 0x2019E
    COMPASS = 0x2019F
    COMPASS_FILL = 0x201A0
    CONTROL = 0x201A1
    CONVERSATION_BUBBLE = 0x201A2
    CREATE = 0x201A3
    CREATE_SOLID = 0x201A4
    CREDITCARD = 0x201A5
    CREDITCARD_FILL = 0x201A6
    CROP = 0x201A7
    CROP_ROTATE = 0x201A8
    CUBE = 0x201A9
    CUBE_BOX = 0x201AA
    CUBE_BOX_FILL = 0x201AB
    CUBE_FILL = 0x201AC
    CURSOR_RAYS = 0x201AD
    DECREASE_INDENT = 0x201AE
    DECREASE_QUOTELEVEL = 0x201AF
    DELETE = 0x201B0
    DELETE_LEFT = 0x201B1
    DELETE_LEFT_FILL = 0x201B2
    DELETE_RIGHT = 0x201B3
    DELETE_RIGHT_FILL = 0x201B4
    DELETE_SIMPLE = 0x201B5
    DELETE_SOLID = 0x201B6
    DESKTOPCOMPUTER = 0x201B7
    DEVICE_DESKTOP = 0x201B8
    DEVICE_LAPTOP = 0x201B9
    DEVICE_PHONE_LANDSCAPE = 0x201BA
    DEVICE_PHONE_PORTRAIT = 0x201BB
    DIAL = 0x201BC
    DIAL_FILL = 0x201BD
    DIVIDE = 0x201BE
    DIVIDE_CIRCLE = 0x201BF
    DIVIDE_CIRCLE_FILL = 0x201C0
    DIVIDE_SQUARE = 0x201C1
    DIVIDE_SQUARE_FILL = 0x201C2
    DOC = 0x201C3
    DOC_APPEND = 0x201C4
    DOC_CHART = 0x201C5
    DOC_CHART_FILL = 0x201C6
    DOC_CHECKMARK = 0x201C7
    DOC_CHECKMARK_FILL = 0x201C8
    DOC_CIRCLE = 0x201C9
    DOC_CIRCLE_FILL = 0x201CA
    DOC_FILL = 0x201CB
    DOC_ON_CLIPBOARD = 0x201CC
    DOC_ON_CLIPBOARD_FILL = 0x201CD
    DOC_ON_DOC = 0x201CE
    DOC_ON_DOC_FILL = 0x201CF
    DOC_PERSON = 0x201D0
    DOC_PERSON_FILL = 0x201D1
    DOC_PLAINTEXT = 0x201D2
    DOC_RICHTEXT = 0x201D3
    DOC_TEXT = 0x201D4
    DOC_TEXT_FILL = 0x201D5
    DOC_TEXT_SEARCH = 0x201D6
    DOC_TEXT_VIEWFINDER = 0x201D7
    DOT_RADIOWAVES_LEFT_RIGHT = 0x201D8
    DOT_RADIOWAVES_RIGHT = 0x201D9
    DOT_SQUARE = 0x201DA
    DOT_SQUARE_FILL = 0x201DB
    DOUBLE_MUSIC_NOTE = 0x201DC
    DOWN_ARROW = 0x201DD
    DOWNLOAD_CIRCLE = 0x201DE
    DOWNLOAD_CIRCLE_FILL = 0x201DF
    DROP = 0x201E0
    DROP_FILL = 0x201E1
    DROP_TRIANGLE = 0x201E2
    DROP_TRIANGLE_FILL = 0x201E3
    EAR = 0x201E4
    EJECT = 0x201E5
    EJECT_FILL = 0x201E6
    ELLIPSES_BUBBLE = 0x201E7
    ELLIPSES_BUBBLE_FILL = 0x201E8
    ELLIPSIS = 0x201E9
    ELLIPSIS_CIRCLE = 0x201EA
    ELLIPSIS_CIRCLE_FILL = 0x201EB
    ELLIPSIS_VERTICAL = 0x201EC
    ELLIPSIS_VERTICAL_CIRCLE = 0x201ED
    ELLIPSIS_VERTICAL_CIRCLE_FILL = 0x201EE
    ENVELOPE = 0x201EF
    ENVELOPE_BADGE = 0x201F0
    ENVELOPE_BADGE_FILL = 0x201F1
    ENVELOPE_CIRCLE = 0x201F2
    ENVELOPE_CIRCLE_FILL = 0x201F3
    ENVELOPE_FILL = 0x201F4
    ENVELOPE_OPEN = 0x201F5
    ENVELOPE_OPEN_FILL = 0x201F6
    EQUAL = 0x201F7
    EQUAL_CIRCLE = 0x201F8
    EQUAL_CIRCLE_FILL = 0x201F9
    EQUAL_SQUARE = 0x201FA
    EQUAL_SQUARE_FILL = 0x201FB
    ESCAPE = 0x201FC
    EXCLAMATIONMARK = 0x201FD
    EXCLAMATIONMARK_BUBBLE = 0x201FE
    EXCLAMATIONMARK_BUBBLE_FILL = 0x201FF
    EXCLAMATIONMARK_CIRCLE = 0x20200
    EXCLAMATIONMARK_CIRCLE_FILL = 0x20201
    EXCLAMATIONMARK_OCTAGON = 0x20202
    EXCLAMATIONMARK_OCTAGON_FILL = 0x20203
    EXCLAMATIONMARK_SHIELD = 0x20204
    EXCLAMATIONMARK_SHIELD_FILL = 0x20205
    EXCLAMATIONMARK_SQUARE = 0x20206
    EXCLAMATIONMARK_SQUARE_FILL = 0x20207
    EXCLAMATIONMARK_TRIANGLE = 0x20208
    EXCLAMATIONMARK_TRIANGLE_FILL = 0x20209
    EYE = 0x2020A
    EYE_FILL = 0x2020B
    EYE_SLASH = 0x2020C
    EYE_SLASH_FILL = 0x2020D
    EYE_SOLID = 0x2020E
    EYEDROPPER = 0x2020F
    EYEDROPPER_FULL = 0x20210
    EYEDROPPER_HALFFULL = 0x20211
    EYEGLASSES = 0x20212
    F_CURSIVE = 0x20213
    F_CURSIVE_CIRCLE = 0x20214
    F_CURSIVE_CIRCLE_FILL = 0x20215
    FILM = 0x20216
    FILM_FILL = 0x20217
    FLAG = 0x20218
    FLAG_CIRCLE = 0x20219
    FLAG_CIRCLE_FILL = 0x2021A
    FLAG_FILL = 0x2021B
    FLAG_SLASH = 0x2021C
    FLAG_SLASH_FILL = 0x2021D
    FLAME = 0x2021E
    FLAME_FILL = 0x2021F
    FLOPPY_DISK = 0x20220
    FLOWCHART = 0x20221
    FLOWCHART_FILL = 0x20222
    FOLDER = 0x20223
    FOLDER_BADGE_MINUS = 0x20224
    FOLDER_BADGE_PERSON_CROP = 0x20225
    FOLDER_BADGE_PLUS = 0x20226
    FOLDER_CIRCLE = 0x20227
    FOLDER_CIRCLE_FILL = 0x20228
    FOLDER_FILL = 0x20229
    FOLDER_FILL_BADGE_MINUS = 0x2022A
    FOLDER_FILL_BADGE_PERSON_CROP = 0x2022B
    FOLDER_FILL_BADGE_PLUS = 0x2022C
    FOLDER_OPEN = 0x2022D
    FOLDER_SOLID = 0x2022E
    FORWARD = 0x2022F
    FORWARD_END = 0x20230
    FORWARD_END_ALT = 0x20231
    FORWARD_END_ALT_FILL = 0x20232
    FORWARD_END_FILL = 0x20233
    FORWARD_FILL = 0x20234
    FULLSCREEN = 0x20235
    FULLSCREEN_EXIT = 0x20236
    FUNCTION = 0x20237
    FX = 0x20238
    GAME_CONTROLLER = 0x20239
    GAME_CONTROLLER_SOLID = 0x2023A
    GAMECONTROLLER = 0x2023B
    GAMECONTROLLER_ALT_FILL = 0x2023C
    GAMECONTROLLER_FILL = 0x2023D
    GAUGE = 0x2023E
    GAUGE_BADGE_MINUS = 0x2023F
    GAUGE_BADGE_PLUS = 0x20240
    GEAR = 0x20241
    GEAR_ALT = 0x20242
    GEAR_ALT_FILL = 0x20243
    GEAR_BIG = 0x20244
    GEAR_SOLID = 0x20245
    GIFT = 0x20246
    GIFT_ALT = 0x20247
    GIFT_ALT_FILL = 0x20248
    GIFT_FILL = 0x20249
    GLOBE = 0x2024A
    GOBACKWARD = 0x2024B
    GOBACKWARD_10 = 0x2024C
    GOBACKWARD_15 = 0x2024D
    GOBACKWARD_30 = 0x2024E
    GOBACKWARD_45 = 0x2024F
    GOBACKWARD_60 = 0x20250
    GOBACKWARD_75 = 0x20251
    GOBACKWARD_90 = 0x20252
    GOBACKWARD_MINUS = 0x20253
    GOFORWARD = 0x20254
    GOFORWARD_10 = 0x20255
    GOFORWARD_15 = 0x20256
    GOFORWARD_30 = 0x20257
    GOFORWARD_45 = 0x20258
    GOFORWARD_60 = 0x20259
    GOFORWARD_75 = 0x2025A
    GOFORWARD_90 = 0x2025B
    GOFORWARD_PLUS = 0x2025C
    GRAPH_CIRCLE = 0x2025D
    GRAPH_CIRCLE_FILL = 0x2025E
    GRAPH_SQUARE = 0x2025F
    GRAPH_SQUARE_FILL = 0x20260
    GREATERTHAN = 0x20261
    GREATERTHAN_CIRCLE = 0x20262
    GREATERTHAN_CIRCLE_FILL = 0x20263
    GREATERTHAN_SQUARE = 0x20264
    GREATERTHAN_SQUARE_FILL = 0x20265
    GRID = 0x20266
    GRID_CIRCLE = 0x20267
    GRID_CIRCLE_FILL = 0x20268
    GROUP = 0x20269
    GROUP_SOLID = 0x2026A
    GUITARS = 0x2026B
    HAMMER = 0x2026C
    HAMMER_FILL = 0x2026D
    HAND_DRAW = 0x2026E
    HAND_DRAW_FILL = 0x2026F
    HAND_POINT_LEFT = 0x20270
    HAND_POINT_LEFT_FILL = 0x20271
    HAND_POINT_RIGHT = 0x20272
    HAND_POINT_RIGHT_FILL = 0x20273
    HAND_RAISED = 0x20274
    HAND_RAISED_FILL = 0x20275
    HAND_RAISED_SLASH = 0x20276
    HAND_RAISED_SLASH_FILL = 0x20277
    HAND_THUMBSDOWN = 0x20278
    HAND_THUMBSDOWN_FILL = 0x20279
    HAND_THUMBSUP = 0x2027A
    HAND_THUMBSUP_FILL = 0x2027B
    HARE = 0x2027C
    HARE_FILL = 0x2027D
    HEADPHONES = 0x2027E
    HEART = 0x2027F
    HEART_CIRCLE = 0x20280
    HEART_CIRCLE_FILL = 0x20281
    HEART_FILL = 0x20282
    HEART_SLASH = 0x20283
    HEART_SLASH_CIRCLE = 0x20284
    HEART_SLASH_CIRCLE_FILL = 0x20285
    HEART_SLASH_FILL = 0x20286
    HEART_SOLID = 0x20287
    HELM = 0x20288
    HEXAGON = 0x20289
    HEXAGON_FILL = 0x2028A
    HIFISPEAKER = 0x2028B
    HIFISPEAKER_FILL = 0x2028C
    HOME = 0x2028D
    HOURGLASS = 0x2028E
    HOURGLASS_BOTTOMHALF_FILL = 0x2028F
    HOURGLASS_TOPHALF_FILL = 0x20290
    HOUSE = 0x20291
    HOUSE_ALT = 0x20292
    HOUSE_ALT_FILL = 0x20293
    HOUSE_FILL = 0x20294
    HURRICANE = 0x20295
    INCREASE_INDENT = 0x20296
    INCREASE_QUOTELEVEL = 0x20297
    INFINITE = 0x20298
    INFO = 0x20299
    INFO_CIRCLE = 0x2029A
    INFO_CIRCLE_FILL = 0x2029B
    ITALIC = 0x2029C
    KEYBOARD = 0x2029D
    KEYBOARD_CHEVRON_COMPACT_DOWN = 0x2029E
    LAB_FLASK = 0x2029F
    LAB_FLASK_SOLID = 0x202A0
    LARGECIRCLE_FILL_CIRCLE = 0x202A1
    LASSO = 0x202A2
    LAYERS = 0x202A3
    LAYERS_ALT = 0x202A4
    LAYERS_ALT_FILL = 0x202A5
    LAYERS_FILL = 0x202A6
    LEAF_ARROW_CIRCLEPATH = 0x202A7
    LEFT_CHEVRON = 0x202A8
    LESSTHAN = 0x202A9
    LESSTHAN_CIRCLE = 0x202AA
    LESSTHAN_CIRCLE_FILL = 0x202AB
    LESSTHAN_SQUARE = 0x202AC
    LESSTHAN_SQUARE_FILL = 0x202AD
    LIGHT_MAX = 0x202AE
    LIGHT_MIN = 0x202AF
    LIGHTBULB = 0x202B0
    LIGHTBULB_FILL = 0x202B1
    LIGHTBULB_SLASH = 0x202B2
    LIGHTBULB_SLASH_FILL = 0x202B3
    LINE_HORIZONTAL_3 = 0x202B4
    LINE_HORIZONTAL_3_DECREASE = 0x202B5
    LINE_HORIZONTAL_3_DECREASE_CIRCLE = 0x202B6
    LINE_HORIZONTAL_3_DECREASE_CIRCLE_FILL = 0x202B7
    LINK = 0x202B8
    LINK_CIRCLE = 0x202B9
    LINK_CIRCLE_FILL = 0x202BA
    LIST_BULLET = 0x202BB
    LIST_BULLET_BELOW_RECTANGLE = 0x202BC
    LIST_BULLET_INDENT = 0x202BD
    LIST_DASH = 0x202BE
    LIST_NUMBER = 0x202BF
    LIST_NUMBER_RTL = 0x202C0
    LOCATION = 0x202C1
    LOCATION_CIRCLE = 0x202C2
    LOCATION_CIRCLE_FILL = 0x202C3
    LOCATION_FILL = 0x202C4
    LOCATION_NORTH = 0x202C5
    LOCATION_NORTH_FILL = 0x202C6
    LOCATION_NORTH_LINE = 0x202C7
    LOCATION_NORTH_LINE_FILL = 0x202C8
    LOCATION_SLASH = 0x202C9
    LOCATION_SLASH_FILL = 0x202CA
    LOCATION_SOLID = 0x202CB
    LOCK = 0x202CC
    LOCK_CIRCLE = 0x202CD
    LOCK_CIRCLE_FILL = 0x202CE
    LOCK_FILL = 0x202CF
    LOCK_OPEN = 0x202D0
    LOCK_OPEN_FILL = 0x202D1
    LOCK_ROTATION = 0x202D2
    LOCK_ROTATION_OPEN = 0x202D3
    LOCK_SHIELD = 0x202D4
    LOCK_SHIELD_FILL = 0x202D5
    LOCK_SLASH = 0x202D6
    LOCK_SLASH_FILL = 0x202D7
    LOOP = 0x202D8
    LOOP_THICK = 0x202D9
    MACWINDOW = 0x202DA
    MAIL = 0x202DB
    MAIL_SOLID = 0x202DC
    MAP = 0x202DD
    MAP_FILL = 0x202DE
    MAP_PIN = 0x202DF
    MAP_PIN_ELLIPSE = 0x202E0
    MAP_PIN_SLASH = 0x202E1
    MEMORIES = 0x202E2
    MEMORIES_BADGE_MINUS = 0x202E3
    MEMORIES_BADGE_PLUS = 0x202E4
    METRONOME = 0x202E5
    MIC = 0x202E6
    MIC_CIRCLE = 0x202E7
    MIC_CIRCLE_FILL = 0x202E8
    MIC_FILL = 0x202E9
    MIC_OFF = 0x202EA
    MIC_SLASH = 0x202EB
    MIC_SLASH_FILL = 0x202EC
    MIC_SOLID = 0x202ED
    MINUS = 0x202EE
    MINUS_CIRCLE = 0x202EF
    MINUS_CIRCLE_FILL = 0x202F0
    MINUS_CIRCLED = 0x202F1
    MINUS_RECTANGLE = 0x202F2
    MINUS_RECTANGLE_FILL = 0x202F3
    MINUS_SLASH_PLUS = 0x202F4
    MINUS_SQUARE = 0x202F5
    MINUS_SQUARE_FILL = 0x202F6
    MONEY_DOLLAR = 0x202F7
    MONEY_DOLLAR_CIRCLE = 0x202F8
    MONEY_DOLLAR_CIRCLE_FILL = 0x202F9
    MONEY_EURO = 0x202FA
    MONEY_EURO_CIRCLE = 0x202FB
    MONEY_EURO_CIRCLE_FILL = 0x202FC
    MONEY_POUND = 0x202FD
    MONEY_POUND_CIRCLE = 0x202FE
    MONEY_POUND_CIRCLE_FILL = 0x202FF
    MONEY_RUBL = 0x20300
    MONEY_RUBL_CIRCLE = 0x20301
    MONEY_RUBL_CIRCLE_FILL = 0x20302
    MONEY_YEN = 0x20303
    MONEY_YEN_CIRCLE = 0x20304
    MONEY_YEN_CIRCLE_FILL = 0x20305
    MOON = 0x20306
    MOON_CIRCLE = 0x20307
    MOON_CIRCLE_FILL = 0x20308
    MOON_FILL = 0x20309
    MOON_STARS = 0x2030A
    MOON_STARS_FILL = 0x2030B
    MOON_ZZZ = 0x2030C
    MOON_ZZZ_FILL = 0x2030D
    MOVE = 0x2030E
    MULTIPLY = 0x2030F
    MULTIPLY_CIRCLE = 0x20310
    MULTIPLY_CIRCLE_FILL = 0x20311
    MULTIPLY_SQUARE = 0x20312
    MULTIPLY_SQUARE_FILL = 0x20313
    MUSIC_ALBUMS = 0x20314
    MUSIC_ALBUMS_FILL = 0x20315
    MUSIC_HOUSE = 0x20316
    MUSIC_HOUSE_FILL = 0x20317
    MUSIC_MIC = 0x20318
    MUSIC_NOTE = 0x20319
    MUSIC_NOTE_2 = 0x2031A
    MUSIC_NOTE_LIST = 0x2031B
    NEWS = 0x2031C
    NEWS_SOLID = 0x2031D
    NOSIGN = 0x2031E
    NUMBER = 0x2031F
    NUMBER_CIRCLE = 0x20320
    NUMBER_CIRCLE_FILL = 0x20321
    NUMBER_SQUARE = 0x20322
    NUMBER_SQUARE_FILL = 0x20323
    OPTION = 0x20324
    PADLOCK = 0x20325
    PADLOCK_SOLID = 0x20326
    PAINTBRUSH = 0x20327
    PAINTBRUSH_FILL = 0x20328
    PANO = 0x20329
    PANO_FILL = 0x2032A
    PAPERCLIP = 0x2032B
    PAPERPLANE = 0x2032C
    PAPERPLANE_FILL = 0x2032D
    PARAGRAPH = 0x2032E
    PAUSE = 0x2032F
    PAUSE_CIRCLE = 0x20330
    PAUSE_CIRCLE_FILL = 0x20331
    PAUSE_FILL = 0x20332
    PAUSE_RECTANGLE = 0x20333
    PAUSE_RECTANGLE_FILL = 0x20334
    PAUSE_SOLID = 0x20335
    PAW = 0x20336
    PAW_SOLID = 0x20337
    PEN = 0x20338
    PENCIL = 0x20339
    PENCIL_CIRCLE = 0x2033A
    PENCIL_CIRCLE_FILL = 0x2033B
    PENCIL_ELLIPSIS_RECTANGLE = 0x2033C
    PENCIL_OUTLINE = 0x2033D
    PENCIL_SLASH = 0x2033E
    PERCENT = 0x2033F
    PERSON = 0x20340
    PERSON_2 = 0x20341
    PERSON_2_ALT = 0x20342
    PERSON_2_FILL = 0x20343
    PERSON_2_SQUARE_STACK = 0x20344
    PERSON_2_SQUARE_STACK_FILL = 0x20345
    PERSON_3 = 0x20346
    PERSON_3_FILL = 0x20347
    PERSON_ADD = 0x20348
    PERSON_ADD_SOLID = 0x20349
    PERSON_ALT = 0x2034A
    PERSON_ALT_CIRCLE = 0x2034B
    PERSON_ALT_CIRCLE_FILL = 0x2034C
    PERSON_BADGE_MINUS = 0x2034D
    PERSON_BADGE_MINUS_FILL = 0x2034E
    PERSON_BADGE_PLUS = 0x2034F
    PERSON_BADGE_PLUS_FILL = 0x20350
    PERSON_CIRCLE = 0x20351
    PERSON_CIRCLE_FILL = 0x20352
    PERSON_CROP_CIRCLE = 0x20353
    PERSON_CROP_CIRCLE_BADGE_CHECKMARK = 0x20354
    PERSON_CROP_CIRCLE_BADGE_EXCLAM = 0x20355
    PERSON_CROP_CIRCLE_BADGE_MINUS = 0x20356
    PERSON_CROP_CIRCLE_BADGE_PLUS = 0x20357
    PERSON_CROP_CIRCLE_BADGE_XMARK = 0x20358
    PERSON_CROP_CIRCLE_FILL = 0x20359
    PERSON_CROP_CIRCLE_FILL_BADGE_CHECKMARK = 0x2035A
    PERSON_CROP_CIRCLE_FILL_BADGE_EXCLAM = 0x2035B
    PERSON_CROP_CIRCLE_FILL_BADGE_MINUS = 0x2035C
    PERSON_CROP_CIRCLE_FILL_BADGE_PLUS = 0x2035D
    PERSON_CROP_CIRCLE_FILL_BADGE_XMARK = 0x2035E
    PERSON_CROP_RECTANGLE = 0x2035F
    PERSON_CROP_RECTANGLE_FILL = 0x20360
    PERSON_CROP_SQUARE = 0x20361
    PERSON_CROP_SQUARE_FILL = 0x20362
    PERSON_FILL = 0x20363
    PERSON_SOLID = 0x20364
    PERSONALHOTSPOT = 0x20365
    PERSPECTIVE = 0x20366
    PHONE = 0x20367
    PHONE_ARROW_DOWN_LEFT = 0x20368
    PHONE_ARROW_RIGHT = 0x20369
    PHONE_ARROW_UP_RIGHT = 0x2036A
    PHONE_BADGE_PLUS = 0x2036B
    PHONE_CIRCLE = 0x2036C
    PHONE_CIRCLE_FILL = 0x2036D
    PHONE_DOWN = 0x2036E
    PHONE_DOWN_CIRCLE = 0x2036F
    PHONE_DOWN_CIRCLE_FILL = 0x20370
    PHONE_DOWN_FILL = 0x20371
    PHONE_FILL = 0x20372
    PHONE_FILL_ARROW_DOWN_LEFT = 0x20373
    PHONE_FILL_ARROW_RIGHT = 0x20374
    PHONE_FILL_ARROW_UP_RIGHT = 0x20375
    PHONE_FILL_BADGE_PLUS = 0x20376
    PHONE_SOLID = 0x20377
    PHOTO = 0x20378
    PHOTO_CAMERA = 0x20379
    PHOTO_CAMERA_SOLID = 0x2037A
    PHOTO_FILL = 0x2037B
    PHOTO_FILL_ON_RECTANGLE_FILL = 0x2037C
    PHOTO_ON_RECTANGLE = 0x2037D
    PIANO = 0x2037E
    PIN = 0x2037F
    PIN_FILL = 0x20380
    PIN_SLASH = 0x20381
    PIN_SLASH_FILL = 0x20382
    PLACEMARK = 0x20383
    PLACEMARK_FILL = 0x20384
    PLAY = 0x20385
    PLAY_ARROW = 0x20386
    PLAY_ARROW_SOLID = 0x20387
    PLAY_CIRCLE = 0x20388
    PLAY_CIRCLE_FILL = 0x20389
    PLAY_FILL = 0x2038A
    PLAY_RECTANGLE = 0x2038B
    PLAY_RECTANGLE_FILL = 0x2038C
    PLAYPAUSE = 0x2038D
    PLAYPAUSE_FILL = 0x2038E
    PLUS = 0x2038F
    PLUS_APP = 0x20390
    PLUS_APP_FILL = 0x20391
    PLUS_BUBBLE = 0x20392
    PLUS_BUBBLE_FILL = 0x20393
    PLUS_CIRCLE = 0x20394
    PLUS_CIRCLE_FILL = 0x20395
    PLUS_CIRCLED = 0x20396
    PLUS_RECTANGLE = 0x20397
    PLUS_RECTANGLE_FILL = 0x20398
    PLUS_RECTANGLE_FILL_ON_RECTANGLE_FILL = 0x20399
    PLUS_RECTANGLE_ON_RECTANGLE = 0x2039A
    PLUS_SLASH_MINUS = 0x2039B
    PLUS_SQUARE = 0x2039C
    PLUS_SQUARE_FILL = 0x2039D
    PLUS_SQUARE_FILL_ON_SQUARE_FILL = 0x2039E
    PLUS_SQUARE_ON_SQUARE = 0x2039F
    PLUSMINUS = 0x203A0
    PLUSMINUS_CIRCLE = 0x203A1
    PLUSMINUS_CIRCLE_FILL = 0x203A2
    POWER = 0x203A3
    PRINTER = 0x203A4
    PRINTER_FILL = 0x203A5
    PROFILE_CIRCLED = 0x203A6
    PROJECTIVE = 0x203A7
    PURCHASED = 0x203A8
    PURCHASED_CIRCLE = 0x203A9
    PURCHASED_CIRCLE_FILL = 0x203AA
    QRCODE = 0x203AB
    QRCODE_VIEWFINDER = 0x203AC
    QUESTION = 0x203AD
    QUESTION_CIRCLE = 0x203AE
    QUESTION_CIRCLE_FILL = 0x203AF
    QUESTION_DIAMOND = 0x203B0
    QUESTION_DIAMOND_FILL = 0x203B1
    QUESTION_SQUARE = 0x203B2
    QUESTION_SQUARE_FILL = 0x203B3
    QUOTE_BUBBLE = 0x203B4
    QUOTE_BUBBLE_FILL = 0x203B5
    RADIOWAVES_LEFT = 0x203B6
    RADIOWAVES_RIGHT = 0x203B7
    RAYS = 0x203B8
    RECORDINGTAPE = 0x203B9
    RECTANGLE = 0x203BA
    RECTANGLE_3_OFFGRID = 0x203BB
    RECTANGLE_3_OFFGRID_FILL = 0x203BC
    RECTANGLE_ARROW_UP_RIGHT_ARROW_DOWN_LEFT = 0x203BD
    RECTANGLE_ARROW_UP_RIGHT_ARROW_DOWN_LEFT_SLASH = 0x203BE
    RECTANGLE_BADGE_CHECKMARK = 0x203BF
    RECTANGLE_BADGE_XMARK = 0x203C0
    RECTANGLE_COMPRESS_VERTICAL = 0x203C1
    RECTANGLE_DOCK = 0x203C2
    RECTANGLE_EXPAND_VERTICAL = 0x203C3
    RECTANGLE_FILL = 0x203C4
    RECTANGLE_FILL_BADGE_CHECKMARK = 0x203C5
    RECTANGLE_FILL_BADGE_XMARK = 0x203C6
    RECTANGLE_FILL_ON_RECTANGLE_ANGLED_FILL = 0x203C7
    RECTANGLE_FILL_ON_RECTANGLE_FILL = 0x203C8
    RECTANGLE_GRID_1X2 = 0x203C9
    RECTANGLE_GRID_1X2_FILL = 0x203CA
    RECTANGLE_GRID_2X2 = 0x203CB
    RECTANGLE_GRID_2X2_FILL = 0x203CC
    RECTANGLE_GRID_3X2 = 0x203CD
    RECTANGLE_GRID_3X2_FILL = 0x203CE
    RECTANGLE_ON_RECTANGLE = 0x203CF
    RECTANGLE_ON_RECTANGLE_ANGLED = 0x203D0
    RECTANGLE_PAPERCLIP = 0x203D1
    RECTANGLE_SPLIT_3X1 = 0x203D2
    RECTANGLE_SPLIT_3X1_FILL = 0x203D3
    RECTANGLE_SPLIT_3X3 = 0x203D4
    RECTANGLE_SPLIT_3X3_FILL = 0x203D5
    RECTANGLE_STACK = 0x203D6
    RECTANGLE_STACK_BADGE_MINUS = 0x203D7
    RECTANGLE_STACK_BADGE_PERSON_CROP = 0x203D8
    RECTANGLE_STACK_BADGE_PLUS = 0x203D9
    RECTANGLE_STACK_FILL = 0x203DA
    RECTANGLE_STACK_FILL_BADGE_MINUS = 0x203DB
    RECTANGLE_STACK_FILL_BADGE_PERSON_CROP = 0x203DC
    RECTANGLE_STACK_FILL_BADGE_PLUS = 0x203DD
    RECTANGLE_STACK_PERSON_CROP = 0x203DE
    RECTANGLE_STACK_PERSON_CROP_FILL = 0x203DF
    REFRESH = 0x203E0
    REFRESH_BOLD = 0x203E1
    REFRESH_CIRCLED = 0x203E2
    REFRESH_CIRCLED_SOLID = 0x203E3
    REFRESH_THICK = 0x203E4
    REFRESH_THIN = 0x203E5
    REPEAT = 0x203E6
    REPEAT_1 = 0x203E7
    REPLY = 0x203E8
    REPLY_ALL = 0x203E9
    REPLY_THICK_SOLID = 0x203EA
    RESIZE = 0x203EB
    RESIZE_H = 0x203EC
    RESIZE_V = 0x203ED
    RESTART = 0x203EE
    RETURN_ICON = 0x203EF
    RHOMBUS = 0x203F0
    RHOMBUS_FILL = 0x203F1
    RIGHT_CHEVRON = 0x203F2
    ROCKET = 0x203F3
    ROCKET_FILL = 0x203F4
    ROSETTE = 0x203F5
    ROTATE_LEFT = 0x203F6
    ROTATE_LEFT_FILL = 0x203F7
    ROTATE_RIGHT = 0x203F8
    ROTATE_RIGHT_FILL = 0x203F9
    SCISSORS = 0x203FA
    SCISSORS_ALT = 0x203FB
    SCOPE = 0x203FC
    SCRIBBLE = 0x203FD
    SEARCH = 0x203FE
    SEARCH_CIRCLE = 0x203FF
    SEARCH_CIRCLE_FILL = 0x20400
    SELECTION_PIN_IN_OUT = 0x20401
    SETTINGS = 0x20402
    SETTINGS_SOLID = 0x20403
    SHARE = 0x20404
    SHARE_SOLID = 0x20405
    SHARE_UP = 0x20406
    SHIELD = 0x20407
    SHIELD_FILL = 0x20408
    SHIELD_LEFTHALF_FILL = 0x20409
    SHIELD_SLASH = 0x2040A
    SHIELD_SLASH_FILL = 0x2040B
    SHIFT = 0x2040C
    SHIFT_FILL = 0x2040D
    SHOPPING_CART = 0x2040E
    SHUFFLE = 0x2040F
    SHUFFLE_MEDIUM = 0x20410
    SHUFFLE_THICK = 0x20411
    SIDEBAR_LEFT = 0x20412
    SIDEBAR_RIGHT = 0x20413
    SIGNATURE = 0x20414
    SKEW = 0x20415
    SLASH_CIRCLE = 0x20416
    SLASH_CIRCLE_FILL = 0x20417
    SLIDER_HORIZONTAL_3 = 0x20418
    SLIDER_HORIZONTAL_BELOW_RECTANGLE = 0x20419
    SLOWMO = 0x2041A
    SMALLCIRCLE_CIRCLE = 0x2041B
    SMALLCIRCLE_CIRCLE_FILL = 0x2041C
    SMALLCIRCLE_FILL_CIRCLE = 0x2041D
    SMALLCIRCLE_FILL_CIRCLE_FILL = 0x2041E
    SMILEY = 0x2041F
    SMILEY_FILL = 0x20420
    SMOKE = 0x20421
    SMOKE_FILL = 0x20422
    SNOW = 0x20423
    SORT_DOWN = 0x20424
    SORT_DOWN_CIRCLE = 0x20425
    SORT_DOWN_CIRCLE_FILL = 0x20426
    SORT_UP = 0x20427
    SORT_UP_CIRCLE = 0x20428
    SORT_UP_CIRCLE_FILL = 0x20429
    SPARKLES = 0x2042A
    SPEAKER = 0x2042B
    SPEAKER_1 = 0x2042C
    SPEAKER_1_FILL = 0x2042D
    SPEAKER_2 = 0x2042E
    SPEAKER_2_FILL = 0x2042F
    SPEAKER_3 = 0x20430
    SPEAKER_3_FILL = 0x20431
    SPEAKER_FILL = 0x20432
    SPEAKER_SLASH = 0x20433
    SPEAKER_SLASH_FILL = 0x20434
    SPEAKER_SLASH_FILL_RTL = 0x20435
    SPEAKER_SLASH_RTL = 0x20436
    SPEAKER_ZZZ = 0x20437
    SPEAKER_ZZZ_FILL = 0x20438
    SPEAKER_ZZZ_FILL_RTL = 0x20439
    SPEAKER_ZZZ_RTL = 0x2043A
    SPEEDOMETER = 0x2043B
    SPORTSCOURT = 0x2043C
    SPORTSCOURT_FILL = 0x2043D
    SQUARE = 0x2043E
    SQUARE_ARROW_DOWN = 0x2043F
    SQUARE_ARROW_DOWN_FILL = 0x20440
    SQUARE_ARROW_DOWN_ON_SQUARE = 0x20441
    SQUARE_ARROW_DOWN_ON_SQUARE_FILL = 0x20442
    SQUARE_ARROW_LEFT = 0x20443
    SQUARE_ARROW_LEFT_FILL = 0x20444
    SQUARE_ARROW_RIGHT = 0x20445
    SQUARE_ARROW_RIGHT_FILL = 0x20446
    SQUARE_ARROW_UP = 0x20447
    SQUARE_ARROW_UP_FILL = 0x20448
    SQUARE_ARROW_UP_ON_SQUARE = 0x20449
    SQUARE_ARROW_UP_ON_SQUARE_FILL = 0x2044A
    SQUARE_FAVORITES = 0x2044B
    SQUARE_FAVORITES_ALT = 0x2044C
    SQUARE_FAVORITES_ALT_FILL = 0x2044D
    SQUARE_FAVORITES_FILL = 0x2044E
    SQUARE_FILL = 0x2044F
    SQUARE_FILL_LINE_VERTICAL_SQUARE = 0x20450
    SQUARE_FILL_LINE_VERTICAL_SQUARE_FILL = 0x20451
    SQUARE_FILL_ON_CIRCLE_FILL = 0x20452
    SQUARE_FILL_ON_SQUARE_FILL = 0x20453
    SQUARE_GRID_2X2 = 0x20454
    SQUARE_GRID_2X2_FILL = 0x20455
    SQUARE_GRID_3X2 = 0x20456
    SQUARE_GRID_3X2_FILL = 0x20457
    SQUARE_GRID_4X3_FILL = 0x20458
    SQUARE_LEFTHALF_FILL = 0x20459
    SQUARE_LINE_VERTICAL_SQUARE = 0x2045A
    SQUARE_LINE_VERTICAL_SQUARE_FILL = 0x2045B
    SQUARE_LIST = 0x2045C
    SQUARE_LIST_FILL = 0x2045D
    SQUARE_ON_CIRCLE = 0x2045E
    SQUARE_ON_SQUARE = 0x2045F
    SQUARE_PENCIL = 0x20460
    SQUARE_PENCIL_FILL = 0x20461
    SQUARE_RIGHTHALF_FILL = 0x20462
    SQUARE_SPLIT_1X2 = 0x20463
    SQUARE_SPLIT_1X2_FILL = 0x20464
    SQUARE_SPLIT_2X1 = 0x20465
    SQUARE_SPLIT_2X1_FILL = 0x20466
    SQUARE_SPLIT_2X2 = 0x20467
    SQUARE_SPLIT_2X2_FILL = 0x20468
    SQUARE_STACK = 0x20469
    SQUARE_STACK_3D_DOWN_DOTTEDLINE = 0x2046A
    SQUARE_STACK_3D_DOWN_RIGHT = 0x2046B
    SQUARE_STACK_3D_DOWN_RIGHT_FILL = 0x2046C
    SQUARE_STACK_3D_UP = 0x2046D
    SQUARE_STACK_3D_UP_FILL = 0x2046E
    SQUARE_STACK_3D_UP_SLASH = 0x2046F
    SQUARE_STACK_3D_UP_SLASH_FILL = 0x20470
    SQUARE_STACK_FILL = 0x20471
    SQUARES_BELOW_RECTANGLE = 0x20472
    STAR = 0x20473
    STAR_CIRCLE = 0x20474
    STAR_CIRCLE_FILL = 0x20475
    STAR_FILL = 0x20476
    STAR_LEFTHALF_FILL = 0x20477
    STAR_SLASH = 0x20478
    STAR_SLASH_FILL = 0x20479
    STAROFLIFE = 0x2047A
    STAROFLIFE_FILL = 0x2047B
    STOP = 0x2047C
    STOP_CIRCLE = 0x2047D
    STOP_CIRCLE_FILL = 0x2047E
    STOP_FILL = 0x2047F
    STOPWATCH = 0x20480
    STOPWATCH_FILL = 0x20481
    STRIKETHROUGH = 0x20482
    SUIT_CLUB = 0x20483
    SUIT_CLUB_FILL = 0x20484
    SUIT_DIAMOND = 0x20485
    SUIT_DIAMOND_FILL = 0x20486
    SUIT_HEART = 0x20487
    SUIT_HEART_FILL = 0x20488
    SUIT_SPADE = 0x20489
    SUIT_SPADE_FILL = 0x2048A
    SUM = 0x2048B
    SUN_DUST = 0x2048C
    SUN_DUST_FILL = 0x2048D
    SUN_HAZE = 0x2048E
    SUN_HAZE_FILL = 0x2048F
    SUN_MAX = 0x20490
    SUN_MAX_FILL = 0x20491
    SUN_MIN = 0x20492
    SUN_MIN_FILL = 0x20493
    SUNRISE = 0x20494
    SUNRISE_FILL = 0x20495
    SUNSET = 0x20496
    SUNSET_FILL = 0x20497
    SWITCH_CAMERA = 0x20498
    SWITCH_CAMERA_SOLID = 0x20499
    T_BUBBLE = 0x2049A
    T_BUBBLE_FILL = 0x2049B
    TABLE = 0x2049C
    TABLE_BADGE_MORE = 0x2049D
    TABLE_BADGE_MORE_FILL = 0x2049E
    TABLE_FILL = 0x2049F
    TAG = 0x204A0
    TAG_CIRCLE = 0x204A1
    TAG_CIRCLE_FILL = 0x204A2
    TAG_FILL = 0x204A3
    TAG_SOLID = 0x204A4
    TAGS = 0x204A5
    TAGS_SOLID = 0x204A6
    TEXT_ALIGNCENTER = 0x204A7
    TEXT_ALIGNLEFT = 0x204A8
    TEXT_ALIGNRIGHT = 0x204A9
    TEXT_APPEND = 0x204AA
    TEXT_BADGE_CHECKMARK = 0x204AB
    TEXT_BADGE_MINUS = 0x204AC
    TEXT_BADGE_PLUS = 0x204AD
    TEXT_BADGE_STAR = 0x204AE
    TEXT_BADGE_XMARK = 0x204AF
    TEXT_BUBBLE = 0x204B0
    TEXT_BUBBLE_FILL = 0x204B1
    TEXT_CURSOR = 0x204B2
    TEXT_INSERT = 0x204B3
    TEXT_JUSTIFY = 0x204B4
    TEXT_JUSTIFYLEFT = 0x204B5
    TEXT_JUSTIFYRIGHT = 0x204B6
    TEXT_QUOTE = 0x204B7
    TEXTBOX = 0x204B8
    TEXTFORMAT = 0x204B9
    TEXTFORMAT_123 = 0x204BA
    TEXTFORMAT_ABC = 0x204BB
    TEXTFORMAT_ABC_DOTTEDUNDERLINE = 0x204BC
    TEXTFORMAT_ALT = 0x204BD
    TEXTFORMAT_SIZE = 0x204BE
    TEXTFORMAT_SUBSCRIPT = 0x204BF
    TEXTFORMAT_SUPERSCRIPT = 0x204C0
    THERMOMETER = 0x204C1
    THERMOMETER_SNOWFLAKE = 0x204C2
    THERMOMETER_SUN = 0x204C3
    TICKET = 0x204C4
    TICKET_FILL = 0x204C5
    TICKETS = 0x204C6
    TICKETS_FILL = 0x204C7
    TIME = 0x204C8
    TIME_SOLID = 0x204C9
    TIMELAPSE = 0x204CA
    TIMER = 0x204CB
    TIMER_FILL = 0x204CC
    TODAY = 0x204CD
    TODAY_FILL = 0x204CE
    TORNADO = 0x204CF
    TORTOISE = 0x204D0
    TORTOISE_FILL = 0x204D1
    TRAIN_STYLE_ONE = 0x204D2
    TRAIN_STYLE_TWO = 0x204D3
    TRAM_FILL = 0x204D4
    TRASH = 0x204D5
    TRASH_CIRCLE = 0x204D6
    TRASH_CIRCLE_FILL = 0x204D7
    TRASH_FILL = 0x204D8
    TRASH_SLASH = 0x204D9
    TRASH_SLASH_FILL = 0x204DA
    TRAY = 0x204DB
    TRAY_2 = 0x204DC
    TRAY_2_FILL = 0x204DD
    TRAY_ARROW_DOWN = 0x204DE
    TRAY_ARROW_DOWN_FILL = 0x204DF
    TRAY_ARROW_UP = 0x204E0
    TRAY_ARROW_UP_FILL = 0x204E1
    TRAY_FILL = 0x204E2
    TRAY_FULL = 0x204E3
    TRAY_FULL_FILL = 0x204E4
    TREE = 0x204E5
    TRIANGLE = 0x204E6
    TRIANGLE_FILL = 0x204E7
    TRIANGLE_LEFTHALF_FILL = 0x204E8
    TRIANGLE_RIGHTHALF_FILL = 0x204E9
    TROPICALSTORM = 0x204EA
    TUNINGFORK = 0x204EB
    TV = 0x204EC
    TV_CIRCLE = 0x204ED
    TV_CIRCLE_FILL = 0x204EE
    TV_FILL = 0x204EF
    TV_MUSIC_NOTE = 0x204F0
    TV_MUSIC_NOTE_FILL = 0x204F1
    UIWINDOW_SPLIT_2X1 = 0x204F2
    UMBRELLA = 0x204F3
    UMBRELLA_FILL = 0x204F4
    UNDERLINE = 0x204F5
    UP_ARROW = 0x204F6
    UPLOAD_CIRCLE = 0x204F7
    UPLOAD_CIRCLE_FILL = 0x204F8
    VIDEO_CAMERA = 0x204F9
    VIDEO_CAMERA_SOLID = 0x204FA
    VIDEOCAM = 0x204FB
    VIDEOCAM_CIRCLE = 0x204FC
    VIDEOCAM_CIRCLE_FILL = 0x204FD
    VIDEOCAM_FILL = 0x204FE
    VIEW_2D = 0x204FF
    VIEW_3D = 0x20500
    VIEWFINDER = 0x20501
    VIEWFINDER_CIRCLE = 0x20502
    VIEWFINDER_CIRCLE_FILL = 0x20503
    VOLUME_DOWN = 0x20504
    VOLUME_MUTE = 0x20505
    VOLUME_OFF = 0x20506
    VOLUME_UP = 0x20507
    WAND_RAYS = 0x20508
    WAND_RAYS_INVERSE = 0x20509
    WAND_STARS = 0x2050A
    WAND_STARS_INVERSE = 0x2050B
    WAVEFORM = 0x2050C
    WAVEFORM_CIRCLE = 0x2050D
    WAVEFORM_CIRCLE_FILL = 0x2050E
    WAVEFORM_PATH = 0x2050F
    WAVEFORM_PATH_BADGE_MINUS = 0x20510
    WAVEFORM_PATH_BADGE_PLUS = 0x20511
    WAVEFORM_PATH_ECG = 0x20512
    WIFI = 0x20513
    WIFI_EXCLAMATIONMARK = 0x20514
    WIFI_SLASH = 0x20515
    WIND = 0x20516
    WIND_SNOW = 0x20517
    WRENCH = 0x20518
    WRENCH_FILL = 0x20519
    XMARK = 0x2051A
    XMARK_CIRCLE = 0x2051B
    XMARK_CIRCLE_FILL = 0x2051C
    XMARK_OCTAGON = 0x2051D
    XMARK_OCTAGON_FILL = 0x2051E
    XMARK_RECTANGLE = 0x2051F
    XMARK_RECTANGLE_FILL = 0x20520
    XMARK_SEAL = 0x20521
    XMARK_SEAL_FILL = 0x20522
    XMARK_SHIELD = 0x20523
    XMARK_SHIELD_FILL = 0x20524
    XMARK_SQUARE = 0x20525
    XMARK_SQUARE_FILL = 0x20526
    ZOOM_IN = 0x20527
    ZOOM_OUT = 0x20528
    ZZZ = 0x20529
