"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const elasticsearch_generated_1 = require("./elasticsearch.generated");
Object.defineProperty(exports, "InstanceProperty", { enumerable: true, get: function () { return elasticsearch_generated_1.RosInstance; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::ElasticSearch::Instance`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosInstance`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-elasticsearch-instance
 */
class Instance extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosInstance = new elasticsearch_generated_1.RosInstance(this, id, {
            masterNode: props.masterNode,
            description: props.description,
            kibanaNode: props.kibanaNode,
            resourceGroupId: props.resourceGroupId,
            enableKibanaPrivate: props.enableKibanaPrivate,
            zoneId: props.zoneId,
            publicWhitelist: props.publicWhitelist,
            instanceChargeType: props.instanceChargeType === undefined || props.instanceChargeType === null ? 'PostPaid' : props.instanceChargeType,
            enableKibanaPublic: props.enableKibanaPublic,
            vSwitchId: props.vSwitchId,
            period: props.period === undefined || props.period === null ? 1 : props.period,
            instanceCategory: props.instanceCategory,
            enablePublic: props.enablePublic,
            privateWhitelist: props.privateWhitelist,
            version: props.version,
            dataNode: props.dataNode,
            kibanaWhitelist: props.kibanaWhitelist,
            ymlConfig: props.ymlConfig,
            deleteType: props.deleteType,
            tags: props.tags,
            periodUnit: props.periodUnit,
            password: props.password,
            zoneCount: props.zoneCount,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstance;
        this.attrArn = rosInstance.attrArn;
        this.attrDomain = rosInstance.attrDomain;
        this.attrInstanceChargeType = rosInstance.attrInstanceChargeType;
        this.attrInstanceId = rosInstance.attrInstanceId;
        this.attrKibanaDomain = rosInstance.attrKibanaDomain;
        this.attrKibanaPort = rosInstance.attrKibanaPort;
        this.attrPort = rosInstance.attrPort;
        this.attrPublicDomain = rosInstance.attrPublicDomain;
        this.attrStatus = rosInstance.attrStatus;
        this.attrVSwitchId = rosInstance.attrVSwitchId;
        this.attrVersion = rosInstance.attrVersion;
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,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