"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SwaggerUi = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const apigateway = require("aws-cdk-lib/aws-apigateway");
const iam = require("aws-cdk-lib/aws-iam");
const logs = require("aws-cdk-lib/aws-logs");
const constructs_1 = require("constructs");
const api_docs_function_1 = require("./api-docs-function");
const swagger_ui_function_1 = require("./swagger-ui-function");
class SwaggerUi extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { resource } = props;
        const api = resource.api;
        const apiDocs = resource.addResource("api-docs.json");
        const apiDocsFunction = new api_docs_function_1.ApiDocsFunction(this, "ApiDocsFunction", {
            initialPolicy: [
                new iam.PolicyStatement({
                    actions: ["apigateway:GET"],
                    resources: [
                        aws_cdk_lib_1.Stack.of(this).formatArn({
                            // https://docs.aws.amazon.com/apigateway/latest/developerguide/arn-format-reference.html
                            service: "apigateway",
                            account: "",
                            resource: `/restapis/${api.restApiId}/*`,
                            arnFormat: aws_cdk_lib_1.ArnFormat.COLON_RESOURCE_NAME,
                        }),
                    ],
                }),
            ],
            logRetention: logs.RetentionDays.ONE_WEEK,
        });
        apiDocs.addMethod("GET", new apigateway.LambdaIntegration(apiDocsFunction, {}), {});
        const swaggerUi = resource.addResource("api-docs").addResource("{proxy+}");
        const swaggerUiFunction = new swagger_ui_function_1.SwaggerUiFunction(this, "SwaggerUiFunction", {
            logRetention: logs.RetentionDays.ONE_WEEK,
        });
        swaggerUi.addMethod("GET", new apigateway.LambdaIntegration(swaggerUiFunction, { proxy: true }), {});
    }
}
exports.SwaggerUi = SwaggerUi;
_a = JSII_RTTI_SYMBOL_1;
SwaggerUi[_a] = { fqn: "@pepperize/cdk-apigateway-swagger-ui.SwaggerUi", version: "0.0.487" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3dhZ2dlci11aS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9zd2FnZ2VyLXVpLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkNBQStDO0FBQy9DLHlEQUF5RDtBQUN6RCwyQ0FBMkM7QUFDM0MsNkNBQTZDO0FBQzdDLDJDQUF1QztBQUN2QywyREFBc0Q7QUFDdEQsK0RBQTBEO0FBTTFELE1BQWEsU0FBVSxTQUFRLHNCQUFTO0lBQ3RDLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXFCO1FBQ3BFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxFQUFFLFFBQVEsRUFBRSxHQUFHLEtBQUssQ0FBQztRQUMzQixNQUFNLEdBQUcsR0FBRyxRQUFRLENBQUMsR0FBRyxDQUFDO1FBRXpCLE1BQU0sT0FBTyxHQUFHLFFBQVEsQ0FBQyxXQUFXLENBQUMsZUFBZSxDQUFDLENBQUM7UUFDdEQsTUFBTSxlQUFlLEdBQUcsSUFBSSxtQ0FBZSxDQUFDLElBQUksRUFBRSxpQkFBaUIsRUFBRTtZQUNuRSxhQUFhLEVBQUU7Z0JBQ2IsSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDO29CQUN0QixPQUFPLEVBQUUsQ0FBQyxnQkFBZ0IsQ0FBQztvQkFDM0IsU0FBUyxFQUFFO3dCQUNULG1CQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLFNBQVMsQ0FBQzs0QkFDdkIseUZBQXlGOzRCQUN6RixPQUFPLEVBQUUsWUFBWTs0QkFDckIsT0FBTyxFQUFFLEVBQUU7NEJBQ1gsUUFBUSxFQUFFLGFBQWEsR0FBRyxDQUFDLFNBQVMsSUFBSTs0QkFDeEMsU0FBUyxFQUFFLHVCQUFTLENBQUMsbUJBQW1CO3lCQUN6QyxDQUFDO3FCQUNIO2lCQUNGLENBQUM7YUFDSDtZQUNELFlBQVksRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLFFBQVE7U0FDMUMsQ0FBQyxDQUFDO1FBQ0gsT0FBTyxDQUFDLFNBQVMsQ0FBQyxLQUFLLEVBQUUsSUFBSSxVQUFVLENBQUMsaUJBQWlCLENBQUMsZUFBZSxFQUFFLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRXBGLE1BQU0sU0FBUyxHQUFHLFFBQVEsQ0FBQyxXQUFXLENBQUMsVUFBVSxDQUFDLENBQUMsV0FBVyxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQzNFLE1BQU0saUJBQWlCLEdBQUcsSUFBSSx1Q0FBaUIsQ0FBQyxJQUFJLEVBQUUsbUJBQW1CLEVBQUU7WUFDekUsWUFBWSxFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsUUFBUTtTQUMxQyxDQUFDLENBQUM7UUFFSCxTQUFTLENBQUMsU0FBUyxDQUFDLEtBQUssRUFBRSxJQUFJLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxFQUFFLEtBQUssRUFBRSxJQUFJLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0lBQ3ZHLENBQUM7O0FBakNILDhCQWtDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFybkZvcm1hdCwgU3RhY2sgfSBmcm9tIFwiYXdzLWNkay1saWJcIjtcbmltcG9ydCAqIGFzIGFwaWdhdGV3YXkgZnJvbSBcImF3cy1jZGstbGliL2F3cy1hcGlnYXRld2F5XCI7XG5pbXBvcnQgKiBhcyBpYW0gZnJvbSBcImF3cy1jZGstbGliL2F3cy1pYW1cIjtcbmltcG9ydCAqIGFzIGxvZ3MgZnJvbSBcImF3cy1jZGstbGliL2F3cy1sb2dzXCI7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tIFwiY29uc3RydWN0c1wiO1xuaW1wb3J0IHsgQXBpRG9jc0Z1bmN0aW9uIH0gZnJvbSBcIi4vYXBpLWRvY3MtZnVuY3Rpb25cIjtcbmltcG9ydCB7IFN3YWdnZXJVaUZ1bmN0aW9uIH0gZnJvbSBcIi4vc3dhZ2dlci11aS1mdW5jdGlvblwiO1xuXG5leHBvcnQgaW50ZXJmYWNlIFN3YWdnZXJVaVByb3BzIHtcbiAgcmVhZG9ubHkgcmVzb3VyY2U6IGFwaWdhdGV3YXkuSVJlc291cmNlO1xufVxuXG5leHBvcnQgY2xhc3MgU3dhZ2dlclVpIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBTd2FnZ2VyVWlQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBjb25zdCB7IHJlc291cmNlIH0gPSBwcm9wcztcbiAgICBjb25zdCBhcGkgPSByZXNvdXJjZS5hcGk7XG5cbiAgICBjb25zdCBhcGlEb2NzID0gcmVzb3VyY2UuYWRkUmVzb3VyY2UoXCJhcGktZG9jcy5qc29uXCIpO1xuICAgIGNvbnN0IGFwaURvY3NGdW5jdGlvbiA9IG5ldyBBcGlEb2NzRnVuY3Rpb24odGhpcywgXCJBcGlEb2NzRnVuY3Rpb25cIiwge1xuICAgICAgaW5pdGlhbFBvbGljeTogW1xuICAgICAgICBuZXcgaWFtLlBvbGljeVN0YXRlbWVudCh7XG4gICAgICAgICAgYWN0aW9uczogW1wiYXBpZ2F0ZXdheTpHRVRcIl0sXG4gICAgICAgICAgcmVzb3VyY2VzOiBbXG4gICAgICAgICAgICBTdGFjay5vZih0aGlzKS5mb3JtYXRBcm4oe1xuICAgICAgICAgICAgICAvLyBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXBpZ2F0ZXdheS9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvYXJuLWZvcm1hdC1yZWZlcmVuY2UuaHRtbFxuICAgICAgICAgICAgICBzZXJ2aWNlOiBcImFwaWdhdGV3YXlcIixcbiAgICAgICAgICAgICAgYWNjb3VudDogXCJcIixcbiAgICAgICAgICAgICAgcmVzb3VyY2U6IGAvcmVzdGFwaXMvJHthcGkucmVzdEFwaUlkfS8qYCxcbiAgICAgICAgICAgICAgYXJuRm9ybWF0OiBBcm5Gb3JtYXQuQ09MT05fUkVTT1VSQ0VfTkFNRSxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICAgIF0sXG4gICAgICAgIH0pLFxuICAgICAgXSxcbiAgICAgIGxvZ1JldGVudGlvbjogbG9ncy5SZXRlbnRpb25EYXlzLk9ORV9XRUVLLFxuICAgIH0pO1xuICAgIGFwaURvY3MuYWRkTWV0aG9kKFwiR0VUXCIsIG5ldyBhcGlnYXRld2F5LkxhbWJkYUludGVncmF0aW9uKGFwaURvY3NGdW5jdGlvbiwge30pLCB7fSk7XG5cbiAgICBjb25zdCBzd2FnZ2VyVWkgPSByZXNvdXJjZS5hZGRSZXNvdXJjZShcImFwaS1kb2NzXCIpLmFkZFJlc291cmNlKFwie3Byb3h5K31cIik7XG4gICAgY29uc3Qgc3dhZ2dlclVpRnVuY3Rpb24gPSBuZXcgU3dhZ2dlclVpRnVuY3Rpb24odGhpcywgXCJTd2FnZ2VyVWlGdW5jdGlvblwiLCB7XG4gICAgICBsb2dSZXRlbnRpb246IGxvZ3MuUmV0ZW50aW9uRGF5cy5PTkVfV0VFSyxcbiAgICB9KTtcblxuICAgIHN3YWdnZXJVaS5hZGRNZXRob2QoXCJHRVRcIiwgbmV3IGFwaWdhdGV3YXkuTGFtYmRhSW50ZWdyYXRpb24oc3dhZ2dlclVpRnVuY3Rpb24sIHsgcHJveHk6IHRydWUgfSksIHt9KTtcbiAgfVxufVxuIl19