from __future__ import annotations

from typing import Iterable

from mismo.linkage._linkage import Linkage


def _pair_counts_chart(linkages: Iterable[Linkage]):
    # Need to flesh out this API before I expose it
    import altair as alt

    counts = [
        {"blocker": linkage.name, "n": linkage.links.count()} for linkage in linkages
    ]
    # some of these counts are 0 (no pairs generated)
    # or None (no way to estimate)
    # At this point leave these in the chart.
    n_title = "Number of Pairs"
    chart = (
        alt.Chart(counts)
        .properties(
            title=alt.TitleParams(
                "Number of Pairs generated by each Blocker",
                subtitle=[
                    f"Total number of pairs: {counts.n.sum().execute():,}",
                    "If two blockers generate the same pair, then the pair will only appear once in the blocked output.",  # noqa: E501
                    "So, the sum of these counts is probably an overestimate of the true blocked size.",  # noqa: E501
                ],
                anchor="middle",
            ),
            height=150,
        )
        .mark_bar()
        .encode(
            alt.X("blocker:O", title="Blocker", sort="-y"),
            alt.Y("n:Q", title=n_title),
            tooltip=[
                alt.Tooltip("n:Q", title=n_title, format=","),
                alt.Tooltip("blocker:O", title="Blocker"),
            ],
        )
    )
    return chart
