# Orkes

## 🔍 What is Orkes?

**Orkes** helps you coordinate LLM agents using plain Python.
No magic, no unnecessary layers. Just **explicit control flow**, **transparent agent logic**, and **simple message passing**.

## 🔹 Core Principles

* **Explicit control flow** — use DAGs, FSMs, or plain loops
* **Transparent agents** — define prompt, tool, and logic directly
* **Simple message passing** — plain dicts, no graph state magic
* **Minimal dependencies** — only what you truly need
* **100% Pythonic** — easy to read, modify, and extend
* **Stateless by default** — you control memory and state
* **Hackable and debuggable** — nothing hidden

## 🛠️ Project Status

This is the initial stage of Orkes.

* [x] Vision and core philosophy
* [ ] Basic orchestration engine
* [ ] Agent structure (prompt + tool + fn)
* [ ] Minimal examples
* [ ] Optional visualizer (planned)
* [ ] Docs and tests (coming)

## License

This poject is available as open source under the terms of the [MIT License](https://github.com/hfahrudin/orkes/blob/main/LICENSE).

