/*
 * Copyright © 2023 Contrast Security, Inc.
 * See https://www.contrastsecurity.com/enduser-terms-0317a for more details.
 */
/* THIS FILE WAS AUTOMATICALLY GENERATED BY HOOKSPY */
/* Python requires its own header to always be included first */
#define PY_SSIZE_T_CLEAN
#include <Python.h>

#include <contrast/assess/patches.h>
#include <contrast/assess/propagate.h>
#include <contrast/assess/scope.h>
#include <contrast/assess/utils.h>

typedef PyObject *(*fastcall_func)(PyObject *, PyObject *const *, Py_ssize_t);
typedef PyObject *(*fastcall_kwargs_func)(
    PyObject *, PyObject *const *, Py_ssize_t, PyObject *);

#define BYTES_DECODE_OFFSET 4
#define BYTES_REPLACE_OFFSET 25
#define BYTES_SPLIT_OFFSET 34
#define BYTES_RSPLIT_OFFSET 32
#define BYTES_JOIN_OFFSET 19
#define BYTES_CAPITALIZE_OFFSET 1
#define BYTES_TITLE_OFFSET 39
#define BYTES_CENTER_OFFSET 2
#define BYTES_EXPANDTABS_OFFSET 6
#define BYTES_PARTITION_OFFSET 24
#define BYTES_LJUST_OFFSET 20
#define BYTES_LOWER_OFFSET 21
#define BYTES_LSTRIP_OFFSET 22
#define BYTES_RJUST_OFFSET 30
#define BYTES_RSTRIP_OFFSET 33
#define BYTES_RPARTITION_OFFSET 31
#define BYTES_SPLITLINES_OFFSET 35
#define BYTES_STRIP_OFFSET 37
#define BYTES_SWAPCASE_OFFSET 38
#define BYTES_TRANSLATE_OFFSET 40
#define BYTES_UPPER_OFFSET 41
#define BYTES_ZFILL_OFFSET 42
#define BYTES_REMOVEPREFIX_OFFSET 26
#define BYTES_REMOVESUFFIX_OFFSET 27

fastcall_kwargs_func bytes_decode_orig;
fastcall_func bytes_replace_orig;
fastcall_kwargs_func bytes_split_orig;
fastcall_kwargs_func bytes_rsplit_orig;
binaryfunc bytes_join_orig;
unaryfunc bytes_capitalize_orig;
unaryfunc bytes_title_orig;
fastcall_func bytes_center_orig;
fastcall_kwargs_func bytes_expandtabs_orig;
binaryfunc bytes_partition_orig;
fastcall_func bytes_ljust_orig;
unaryfunc bytes_lower_orig;
fastcall_func bytes_lstrip_orig;
fastcall_func bytes_rjust_orig;
fastcall_func bytes_rstrip_orig;
binaryfunc bytes_rpartition_orig;
fastcall_kwargs_func bytes_splitlines_orig;
fastcall_func bytes_strip_orig;
unaryfunc bytes_swapcase_orig;
fastcall_kwargs_func bytes_translate_orig;
unaryfunc bytes_upper_orig;
binaryfunc bytes_zfill_orig;
binaryfunc bytes_removeprefix_orig;
binaryfunc bytes_removesuffix_orig;

HOOK_TERNARY_FASTCALL(bytes_decode);
PyObject *bytes_replace_new(PyObject *self, PyObject *const *args, Py_ssize_t nargs) {
    /* In Py37 the replace method type moved to METH_FASTARGS. This means that
     * instead of args being passed as a tuple, they are passed as a C array
     * that contains PyObjects. We need to check whether there is the number of
     * args that we expect, and whether the arg we care about is not NULL.
     * Specifically, we want args[1] since it represents the "new" string in
     * the replacement.
     */
    PyObject *hook_args = pack_args_tuple(args, nargs);
    PyObject *result = bytes_replace_orig(self, args, nargs);

    if (result == NULL || nargs < 2 || args[1] == NULL)
        goto cleanup_and_exit;

    if (result == self)
        goto cleanup_and_exit;

    call_string_propagator("propagate_bytes_replace", self, result, hook_args, NULL);

cleanup_and_exit:
    Py_XDECREF(hook_args);
    return result;
}

PyObject *bytes_split_new(
    PyObject *self, PyObject *const *args, Py_ssize_t nargs, PyObject *kwnames) {
    PyObject *result = bytes_split_orig(self, args, nargs, kwnames);
    PyObject *args_tuple = pack_args_tuple(args, nargs);
    PyObject *kwargs = pack_kwargs_dict(args, nargs, kwnames);

    if (result == NULL || PySequence_Length(result) == 1)
        goto cleanup_and_exit;

    call_string_propagator(
        "propagate_bytes_split", (PyObject *)self, result, args_tuple, kwargs);

cleanup_and_exit:
    Py_XDECREF(args_tuple);
    Py_XDECREF(kwargs);
    return result;
}

PyObject *bytes_rsplit_new(
    PyObject *self, PyObject *const *args, Py_ssize_t nargs, PyObject *kwnames) {
    PyObject *result = bytes_rsplit_orig(self, args, nargs, kwnames);
    PyObject *args_tuple = pack_args_tuple(args, nargs);
    PyObject *kwargs = pack_kwargs_dict(args, nargs, kwnames);

    if (result == NULL || PySequence_Length(result) == 1)
        goto cleanup_and_exit;

    call_string_propagator(
        "propagate_bytes_rsplit", (PyObject *)self, result, args_tuple, kwargs);

cleanup_and_exit:
    Py_XDECREF(args_tuple);
    Py_XDECREF(kwargs);
    return result;
}

PyObject *bytes_join_new(PyObject *self, PyObject *args) {
    PyObject *list = PySequence_List(args);

    /* Converting args to a list might legitimately raise an exception in some cases.
     * We need to be sure we don't suppress that exception to maintain original app
     * behavior. We've seen this before when args is a generator.
     */
    if (list == NULL) {
        return NULL;
    }

    /* In Py36+ we also hook an internal function that is called by this
     * function in order to propagate fstring formatting. We still want to have
     * a separate hook for join so that the events are reported differently.
     * This means that we need to go into scope when calling the original
     * function here so that we don't propagate twice.
     */
    enter_propagation_scope();
    PyObject *result = bytes_join_orig((PyObject *)self, list);
    exit_propagation_scope();

    PyObject *prop_args = PyTuple_Pack(1, list);

    if (prop_args == NULL || result == NULL)
        goto cleanup_and_exit;

    call_string_propagator(
        "propagate_bytes_join", (PyObject *)self, result, prop_args, NULL);

cleanup_and_exit:
    Py_XDECREF(list);
    Py_XDECREF(prop_args);
    return result;
}

HOOK_UNARYFUNC(bytes_capitalize);
HOOK_UNARYFUNC(bytes_title);
HOOK_FASTCALL(bytes_center);
HOOK_TERNARY_FASTCALL(bytes_expandtabs);
HOOK_BINARYFUNC(bytes_partition);
HOOK_FASTCALL(bytes_ljust);
HOOK_UNARYFUNC(bytes_lower);
HOOK_FASTCALL(bytes_lstrip);
HOOK_FASTCALL(bytes_rjust);
HOOK_FASTCALL(bytes_rstrip);
HOOK_BINARYFUNC(bytes_rpartition);
HOOK_TERNARY_FASTCALL(bytes_splitlines);
HOOK_FASTCALL(bytes_strip);
HOOK_UNARYFUNC(bytes_swapcase);
HOOK_TERNARY_FASTCALL(bytes_translate);
HOOK_UNARYFUNC(bytes_upper);
HOOK_BINARYFUNC(bytes_zfill);
HOOK_BINARYFUNC(bytes_removeprefix);
HOOK_BINARYFUNC(bytes_removesuffix);

CREATE_HOOK_METHOD(PyBytes_Type, bytes_decode, 4)
CREATE_HOOK_METHOD(PyBytes_Type, bytes_replace, 25)
CREATE_HOOK_METHOD(PyBytes_Type, bytes_split, 34)
CREATE_HOOK_METHOD(PyBytes_Type, bytes_rsplit, 32)
CREATE_HOOK_METHOD(PyBytes_Type, bytes_join, 19)
CREATE_HOOK_METHOD(PyBytes_Type, bytes_capitalize, 1)
CREATE_HOOK_METHOD(PyBytes_Type, bytes_title, 39)
CREATE_HOOK_METHOD(PyBytes_Type, bytes_center, 2)
CREATE_HOOK_METHOD(PyBytes_Type, bytes_expandtabs, 6)
CREATE_HOOK_METHOD(PyBytes_Type, bytes_partition, 24)
CREATE_HOOK_METHOD(PyBytes_Type, bytes_ljust, 20)
CREATE_HOOK_METHOD(PyBytes_Type, bytes_lower, 21)
CREATE_HOOK_METHOD(PyBytes_Type, bytes_lstrip, 22)
CREATE_HOOK_METHOD(PyBytes_Type, bytes_rjust, 30)
CREATE_HOOK_METHOD(PyBytes_Type, bytes_rstrip, 33)
CREATE_HOOK_METHOD(PyBytes_Type, bytes_rpartition, 31)
CREATE_HOOK_METHOD(PyBytes_Type, bytes_splitlines, 35)
CREATE_HOOK_METHOD(PyBytes_Type, bytes_strip, 37)
CREATE_HOOK_METHOD(PyBytes_Type, bytes_swapcase, 38)
CREATE_HOOK_METHOD(PyBytes_Type, bytes_translate, 40)
CREATE_HOOK_METHOD(PyBytes_Type, bytes_upper, 41)
CREATE_HOOK_METHOD(PyBytes_Type, bytes_zfill, 42)
CREATE_HOOK_METHOD(PyBytes_Type, bytes_removeprefix, 26)
CREATE_HOOK_METHOD(PyBytes_Type, bytes_removesuffix, 27)

static PyMethodDef methods[] = {
    {"apply_decode_hook", apply_bytes_decode_hook, METH_O, "Enable bytes.decode hook"},
    {"apply_replace_hook",
     apply_bytes_replace_hook,
     METH_O,
     "Enable bytes.replace hook"},
    {"apply_split_hook", apply_bytes_split_hook, METH_O, "Enable bytes.split hook"},
    {"apply_rsplit_hook", apply_bytes_rsplit_hook, METH_O, "Enable bytes.rsplit hook"},
    {"apply_join_hook", apply_bytes_join_hook, METH_O, "Enable bytes.join hook"},
    {"apply_capitalize_hook",
     apply_bytes_capitalize_hook,
     METH_O,
     "Enable bytes.capitalize hook"},
    {"apply_title_hook", apply_bytes_title_hook, METH_O, "Enable bytes.title hook"},
    {"apply_center_hook", apply_bytes_center_hook, METH_O, "Enable bytes.center hook"},
    {"apply_expandtabs_hook",
     apply_bytes_expandtabs_hook,
     METH_O,
     "Enable bytes.expandtabs hook"},
    {"apply_partition_hook",
     apply_bytes_partition_hook,
     METH_O,
     "Enable bytes.partition hook"},
    {"apply_ljust_hook", apply_bytes_ljust_hook, METH_O, "Enable bytes.ljust hook"},
    {"apply_lower_hook", apply_bytes_lower_hook, METH_O, "Enable bytes.lower hook"},
    {"apply_lstrip_hook", apply_bytes_lstrip_hook, METH_O, "Enable bytes.lstrip hook"},
    {"apply_rjust_hook", apply_bytes_rjust_hook, METH_O, "Enable bytes.rjust hook"},
    {"apply_rstrip_hook", apply_bytes_rstrip_hook, METH_O, "Enable bytes.rstrip hook"},
    {"apply_rpartition_hook",
     apply_bytes_rpartition_hook,
     METH_O,
     "Enable bytes.rpartition hook"},
    {"apply_splitlines_hook",
     apply_bytes_splitlines_hook,
     METH_O,
     "Enable bytes.splitlines hook"},
    {"apply_strip_hook", apply_bytes_strip_hook, METH_O, "Enable bytes.strip hook"},
    {"apply_swapcase_hook",
     apply_bytes_swapcase_hook,
     METH_O,
     "Enable bytes.swapcase hook"},
    {"apply_translate_hook",
     apply_bytes_translate_hook,
     METH_O,
     "Enable bytes.translate hook"},
    {"apply_upper_hook", apply_bytes_upper_hook, METH_O, "Enable bytes.upper hook"},
    {"apply_zfill_hook", apply_bytes_zfill_hook, METH_O, "Enable bytes.zfill hook"},
    {"apply_removeprefix_hook",
     apply_bytes_removeprefix_hook,
     METH_O,
     "Enable bytes.removeprefix hook"},
    {"apply_removesuffix_hook",
     apply_bytes_removesuffix_hook,
     METH_O,
     "Enable bytes.removesuffix hook"},
    {NULL, NULL, 0, NULL},
};

static struct PyModuleDef bytes_module_def = {
    PyModuleDef_HEAD_INIT,
    "bytes_hooks",
    "methods for hooking bytes methods",
    -1,
    methods,
    NULL,
    NULL,
    NULL,
    NULL};

PyObject *create_bytes_hook_module(PyObject *self, PyObject *arg) {
    return PyModule_Create(&bytes_module_def);
}
