# -*- coding: utf-8 -*-
# Copyright © 2023 Contrast Security, Inc.
# See https://www.contrastsecurity.com/enduser-terms-0317a for more details.
import sys


def build_modules_to_ignore():
    """
    Get the set of module names that are
    1. in the modules to ignore list
    2. in sys.builtin_module_names
    3. NOT in the modules to allow list
    """
    return set(list(MODULES_TO_IGNORE + sys.builtin_module_names)).difference(
        MODULES_TO_ALLOW
    )


# this list contains modules to include despite their appearance in sys.builtin_module_names
MODULES_TO_ALLOW = ("__main__", "__builtin__", "builtins", "io")

MODULES_TO_IGNORE = (
    "__future__",
    "_ast",
    "_asyncio",
    "_bisect",
    "_blake2",
    "_bootlocale",
    "_bz2",
    "_codecs",
    "_collections",
    "_collections_abc",
    "_compat_pickle",
    "_compression",
    "_csv",
    "_ctypes",
    "_datetime",
    "_decimal",
    "_elementtree",
    "_frozen_importlib",
    "_frozen_importlib_external",
    "_functools",
    "_heapq",
    "_imp",
    "_jb_runner_tools",
    "_jb_serial_tree_manager",
    "_jb_utils",
    "_locale",
    "_lzma",
    "_markupbase",
    "_multiprocessing",
    "_opcode",
    "_operator",
    "_osx_support",
    "_pickle",
    "_posixsubprocess",
    "_random",
    "_sha3",
    "_signal",
    "_socket",
    "_sre",
    "_ssl",
    "_stat",
    "_string",
    "_struct",
    "_sysconfigdata_m_darwin_darwin",
    "_warnings",
    "_weakref",
    "_weakrefset",
    "_yaml",
    "abc",
    "argparse",
    "array",
    "ast",
    "atexit",
    "atomicwrites",
    "attr",
    "base64",
    "bdb",
    "bisect",
    "calendar",
    "cmd",
    "code",
    "codecs",
    "codeop",
    "collections",
    "collections.abc",
    "concurrent",
    "configparser",
    "contextlib",
    "contrast",
    "copy",
    "copyreg",
    "coverage",
    "csv",
    "cython_runtime",
    "datetime",
    "decimal",
    "difflib",
    "dis",
    "doctest",
    "email",
    "email._encoded_words",
    "email._parseaddr",
    "email._policybase",
    "email.base64mime",
    "email.charset",
    "email.encoders",
    "email.errors",
    "email.feedparser",
    "email.header",
    "email.iterators",
    "email.message",
    "email.parser",
    "email.quoprimime",
    "email.utils",
    "encodings",
    "encodings.aliases",
    "enum",
    "errno",
    "fcntl",
    "fnmatch",
    "functools",
    "genericpath",
    "getopt",
    "gettext",
    "glob",
    "google",
    "grp",
    "gzip",
    "heapq",
    "hmac",
    "html",
    "html.entities",
    "html.parser",
    "imp",
    "importlib",
    "inspect",
    "ipaddress",
    "itertools",
    "keyword",
    "linecache",
    "locale",
    "logging",
    "lzma",
    "marshal",
    "math",
    "mimetypes",
    "mock",
    "mock.mock",
    "more_itertools",
    "more_itertools.more",
    "more_itertools.recipes",
    "ntpath",
    "numbers",
    "opcode",
    "operator",
    "optparse",
    "os",
    "os.path",
    "paste",
    "pbr",
    "pbr.version",
    "pdb",
    "pip",
    "pkgutil",
    "platform",
    "plistlib",
    "posixpath",
    "pprint",
    "psutil",
    "pwd",
    "py",
    "pyexpat",
    "pytz",
    "queue",
    "quopri",
    "reprlib",
    "select",
    "selectors",
    "shlex",
    "shutil",
    "signal",
    "site",
    "sitecustomize",
    "socket",
    "ssl",
    "stat",
    "string",
    "struct",
    "subprocess",
    "sys",
    "sysconfig",
    "tempfile",
    "termios",
    "textwrap",
    "time",
    "token",
    "tokenize",
    "traceback",
    "types",
    "unicodedata",
    "urllib.parse",
    "uu",
    "uuid",
    "warnings",
    "weakref",
    "wsgiref",
    "wsgiref.util",
    "zipfile",
    "zipimport",
    "zipp",
    "zlib",
    "zope",
)

ALL_MODULES_TO_IGNORE = build_modules_to_ignore()

# This list is carefully curated to ensure we don't exclude modules by accident.
# 'contrast' is not in this list because it's not
# unrealistic to think that a python library called contrastcolors or concurrent_stuff exists.
# Adding a dot ensures we only remove our own modules.
MODULES_TO_IGNORE_PREFIXES = (
    "_pytest",
    "attr.",
    "concurrent.",
    "contrast.",
    "coverage.",
    "ctypes",
    "distutils",
    "google.protobuf",
    "importlib.",
    "importlib_",
    "multiprocessing",
    "psutil.",
    "pkg_resources",
    "py.",
    "pyexpat.",
    "pluggy",
    "pytest",
    "pytz.",
    "sre_",
    "teamcity",
    "unittest",
    "wrapt",
)
