from __future__ import annotations  # noqa: D100

from alembic import context
from sqlalchemy import engine_from_config, pool

config = context.config


def run_migrations_offline():  # noqa: ANN201
    """Run migrations in 'offline' mode.

    This configures the context with just a URL
    and not an Engine, though an Engine is acceptable
    here as well.  By skipping the Engine creation
    we don't even need a DBAPI to be available.

    Calls to context.execute() here emit the given string to the
    script output.

    """
    url = config.get_main_option("sqlalchemy.url")
    context.configure(url=url, literal_binds=True)

    with context.begin_transaction():
        context.run_migrations()


def run_migrations_online():  # noqa: ANN201
    """Run migrations in 'online' mode.

    In this scenario we need to create an Engine
    and associate a connection with the context.

    """
    if connection := config.attributes.get("connection"):
        _run_migrations_online(connection)
        return

    connectable = engine_from_config(
        config.get_section(config.config_ini_section),
        prefix="sqlalchemy.",
        poolclass=pool.NullPool,
    )

    with connectable.connect() as new_connection:
        _run_migrations_online(new_connection)


def _run_migrations_online(connection):  # noqa: ANN001, ANN202
    context.configure(connection=connection)

    with context.begin_transaction():
        context.run_migrations()


if context.is_offline_mode():
    run_migrations_offline()
else:
    run_migrations_online()
