# Life123
Open-Source Engine for Quantitative Reactomics.

Dynamical Modeling of Biological Systems in 1, 2 and 3D (as well as single-compartment reactions)

Includes diffusion, reactions, diffusion/reaction, membranes and compartments.

[WEBSITE](https://life123.science/)

## Fundamental Goals
1. Detailed, quantitative biological simulations, including whole prokaryotic cells (bacteria), and later eukaryotic cells
2. Deeper quantitative insight into human tissue/organ/system physiology, for the advancement of medicine
3. A very integrative approach that is ultimate conducive to body-wide insights,
   with an eye to Longevity Science
4. Explore the minimalist essence of life-like dynamical systems
5. Investigate potential paths for the emergence of life on Earth and on Exoplanets
6. A community effort bringing together biologists, system biologists, programmers, machine-learning specialists, biochemists, power-computing engineers, doctors, data scientists, graphic designers, members of the public willing to share computing resources, etc.

## Overview and Details

[WEBSITE](https://life123.science/)

[Follow our blog/discussions](https://github.com/BrainAnnex/life123/discussions)

## Try it Out Live on a hosted JupyterLab!
**TRY IT OUT LIVE** (no registration nor install!)  
Click on
[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/BrainAnnex/life123/main)

Then explore the notebooks under the `experiments` folder.

Note that several notebooks create **HTML log files**, by the same name as the notebook (eg,
running the notebook called `diffusion_1.ipynb` will create a log file named `diffusion_1.htm`).
These log files typically contain additional interactive graphics: currently, mostly interactive diagrams of the reaction networks.  
(Most plots will show up inside the notebooks.)

"Binder", the host of the live demo, is akin to Google's Colab:
short-term runs on a hosted JupyterLab environment.  
It generally takes less than one minute to launch... and then you'll have your own private copy of all the notebooks,
to run and/or change and re-run.  (The notebooks are pre-existing; you may view them without
having to run anything.)

Please remember that nothing gets saved long term on Binder; so, if you make changes you want to preserve,
make sure to download the changed notebooks!  For instruction on creating your own private local copy, read on...

(Note: if you want to simply VIEW the notebooks rather than run them, you may simply follow the  
links in the [Experiments Page](https://life123.science/experiments) )

## Components

*Experiments:*
See the [Life123 List of Experiments](https://life123.science/experiments)

*Libraries:*
See the [Life123 Guide](https://life123.science/guide)

*Unit Testing (pytest):*
* "tests" folder (top-level)

## How to Use
See this [short video](https://www.youtube.com/watch?v=FOhQgPZaEsA)

## How to Run Locally
`pip install life123`

For details, see the [Life123 Download/Install page](https://life123.science/install)
