from os import PathLike

from .mode import TrackFlag, TrackMode

class CDText:
    @property
    def title(self) -> str | None: ...
    @property
    def performer(self) -> str | None: ...
    @property
    def songwriter(self) -> str | None: ...
    @property
    def composer(self) -> str | None: ...
    @property
    def arranger(self) -> str | None: ...
    @property
    def message(self) -> str | None: ...
    @property
    def disc_id(self) -> str | None: ...
    @property
    def genre(self) -> str | None: ...
    @property
    def upc_isrc(self) -> str | None: ...
    @property
    def size_info(self) -> str | None: ...
    @property
    def toc_info(self) -> str | None: ...
    def _asdict(self) -> dict[str, str | None]: ...

class Rem:
    @property
    def date(self) -> str | None: ...
    @property
    def comment(self) -> str | None: ...
    @property
    def album_gain(self) -> str | None: ...
    @property
    def album_peak(self) -> str | None: ...
    @property
    def track_gain(self) -> str | None: ...
    @property
    def track_peak(self) -> str | None: ...
    def _asdict(self) -> dict[str, str | None]: ...

class Cd:
    encoding: str
    @classmethod
    def from_file(cls, path: PathLike[str] | str, encoding: str = "utf-8") -> "Cd": ...
    @classmethod
    def from_str(cls, string: str) -> "Cd": ...
    @property
    def cdtext(self) -> CDText: ...
    @property
    def rem(self) -> Rem: ...
    @property
    def cdtextfile(self) -> str | None: ...
    @property
    def catalog(self) -> str | None: ...
    def __len__(self) -> int: ...
    def __getitem__(self, index: int) -> Track: ...
    def __contains__(self, track: Track) -> bool: ...

class Track:
    @property
    def filename(self) -> str | None: ...
    @property
    def index(self) -> int: ...
    @property
    def cdtext(self) -> CDText: ...
    @property
    def rem(self) -> Rem: ...
    @property
    def start(self) -> tuple[int, int, int] | None: ...
    @property
    def length(self) -> tuple[int, int, int] | None: ...
    @property
    def zero_pre(self) -> tuple[int, int, int] | None: ...
    @property
    def zero_post(self) -> tuple[int, int, int] | None: ...
    @property
    def isrc(self) -> str | None: ...
    @property
    def mode(self) -> TrackMode | None: ...
    def has_flag(self, flag: TrackFlag) -> bool: ...
    def __and__(self, other: TrackFlag) -> bool: ...

def parse_file(path: PathLike[str] | str, encoding: str = "utf-8") -> Cd: ...
def parse_str(string: str) -> Cd: ...
