import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AdministrativeUnitConfig extends cdktf.TerraformMetaArguments {
    /**
    * The description for the administrative unit
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit#description AdministrativeUnit#description}
    */
    readonly description?: string;
    /**
    * The display name for the administrative unit
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit#display_name AdministrativeUnit#display_name}
    */
    readonly displayName: string;
    /**
    * Whether the administrative unit and its members are hidden or publicly viewable in the directory
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit#hidden_membership_enabled AdministrativeUnit#hidden_membership_enabled}
    */
    readonly hiddenMembershipEnabled?: boolean | cdktf.IResolvable;
    /**
    * A set of object IDs of members who should be present in this administrative unit. Supported object types are Users or Groups
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit#members AdministrativeUnit#members}
    */
    readonly members?: string[];
    /**
    * If `true`, will return an error if an existing administrative unit is found with the same name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit#prevent_duplicate_names AdministrativeUnit#prevent_duplicate_names}
    */
    readonly preventDuplicateNames?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit#timeouts AdministrativeUnit#timeouts}
    */
    readonly timeouts?: AdministrativeUnitTimeouts;
}
export interface AdministrativeUnitTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit#create AdministrativeUnit#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit#delete AdministrativeUnit#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit#read AdministrativeUnit#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit#update AdministrativeUnit#update}
    */
    readonly update?: string;
}
export declare function administrativeUnitTimeoutsToTerraform(struct?: AdministrativeUnitTimeoutsOutputReference | AdministrativeUnitTimeouts | cdktf.IResolvable): any;
export declare class AdministrativeUnitTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AdministrativeUnitTimeouts | undefined;
    set internalValue(value: AdministrativeUnitTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit azuread_administrative_unit}
*/
export declare class AdministrativeUnit extends cdktf.TerraformResource {
    static readonly tfResourceType = "azuread_administrative_unit";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/administrative_unit azuread_administrative_unit} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AdministrativeUnitConfig
    */
    constructor(scope: Construct, id: string, config: AdministrativeUnitConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _hiddenMembershipEnabled?;
    get hiddenMembershipEnabled(): boolean | cdktf.IResolvable;
    set hiddenMembershipEnabled(value: boolean | cdktf.IResolvable);
    resetHiddenMembershipEnabled(): void;
    get hiddenMembershipEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    resetMembers(): void;
    get membersInput(): string[] | undefined;
    get objectId(): string;
    private _preventDuplicateNames?;
    get preventDuplicateNames(): boolean | cdktf.IResolvable;
    set preventDuplicateNames(value: boolean | cdktf.IResolvable);
    resetPreventDuplicateNames(): void;
    get preventDuplicateNamesInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): AdministrativeUnitTimeoutsOutputReference;
    putTimeouts(value: AdministrativeUnitTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): AdministrativeUnitTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
