import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppRoleAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the app role to be assigned
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/app_role_assignment#app_role_id AppRoleAssignment#app_role_id}
    */
    readonly appRoleId: string;
    /**
    * The object ID of the user, group or service principal to be assigned this app role
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/app_role_assignment#principal_object_id AppRoleAssignment#principal_object_id}
    */
    readonly principalObjectId: string;
    /**
    * The object ID of the service principal representing the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/app_role_assignment#resource_object_id AppRoleAssignment#resource_object_id}
    */
    readonly resourceObjectId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/app_role_assignment#timeouts AppRoleAssignment#timeouts}
    */
    readonly timeouts?: AppRoleAssignmentTimeouts;
}
export interface AppRoleAssignmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/app_role_assignment#create AppRoleAssignment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/app_role_assignment#delete AppRoleAssignment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/app_role_assignment#read AppRoleAssignment#read}
    */
    readonly read?: string;
}
export declare function appRoleAssignmentTimeoutsToTerraform(struct?: AppRoleAssignmentTimeoutsOutputReference | AppRoleAssignmentTimeouts | cdktf.IResolvable): any;
export declare class AppRoleAssignmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppRoleAssignmentTimeouts | undefined;
    set internalValue(value: AppRoleAssignmentTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/r/app_role_assignment azuread_app_role_assignment}
*/
export declare class AppRoleAssignment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azuread_app_role_assignment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/app_role_assignment azuread_app_role_assignment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppRoleAssignmentConfig
    */
    constructor(scope: Construct, id: string, config: AppRoleAssignmentConfig);
    private _appRoleId?;
    get appRoleId(): string;
    set appRoleId(value: string);
    get appRoleIdInput(): string | undefined;
    get id(): string;
    get principalDisplayName(): string;
    private _principalObjectId?;
    get principalObjectId(): string;
    set principalObjectId(value: string);
    get principalObjectIdInput(): string | undefined;
    get principalType(): string;
    get resourceDisplayName(): string;
    private _resourceObjectId?;
    get resourceObjectId(): string;
    set resourceObjectId(value: string);
    get resourceObjectIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): AppRoleAssignmentTimeoutsOutputReference;
    putTimeouts(value: AppRoleAssignmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): AppRoleAssignmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
