import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApplicationFederatedIdentityCredentialConfig extends cdktf.TerraformMetaArguments {
    /**
    * The object ID of the application for which this federated identity credential should be created
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential#application_object_id ApplicationFederatedIdentityCredential#application_object_id}
    */
    readonly applicationObjectId: string;
    /**
    * List of audiences that can appear in the external token. This specifies what should be accepted in the `aud` claim of incoming tokens.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential#audiences ApplicationFederatedIdentityCredential#audiences}
    */
    readonly audiences: string[];
    /**
    * A description for the federated identity credential
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential#description ApplicationFederatedIdentityCredential#description}
    */
    readonly description?: string;
    /**
    * A unique display name for the federated identity credential
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential#display_name ApplicationFederatedIdentityCredential#display_name}
    */
    readonly displayName: string;
    /**
    * The URL of the external identity provider, which must match the issuer claim of the external token being exchanged. The combination of the values of issuer and subject must be unique on the app.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential#issuer ApplicationFederatedIdentityCredential#issuer}
    */
    readonly issuer: string;
    /**
    * The identifier of the external software workload within the external identity provider. The combination of issuer and subject must be unique on the app.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential#subject ApplicationFederatedIdentityCredential#subject}
    */
    readonly subject: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential#timeouts ApplicationFederatedIdentityCredential#timeouts}
    */
    readonly timeouts?: ApplicationFederatedIdentityCredentialTimeouts;
}
export interface ApplicationFederatedIdentityCredentialTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential#create ApplicationFederatedIdentityCredential#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential#delete ApplicationFederatedIdentityCredential#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential#read ApplicationFederatedIdentityCredential#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential#update ApplicationFederatedIdentityCredential#update}
    */
    readonly update?: string;
}
export declare function applicationFederatedIdentityCredentialTimeoutsToTerraform(struct?: ApplicationFederatedIdentityCredentialTimeoutsOutputReference | ApplicationFederatedIdentityCredentialTimeouts | cdktf.IResolvable): any;
export declare class ApplicationFederatedIdentityCredentialTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationFederatedIdentityCredentialTimeouts | undefined;
    set internalValue(value: ApplicationFederatedIdentityCredentialTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential azuread_application_federated_identity_credential}
*/
export declare class ApplicationFederatedIdentityCredential extends cdktf.TerraformResource {
    static readonly tfResourceType = "azuread_application_federated_identity_credential";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/application_federated_identity_credential azuread_application_federated_identity_credential} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApplicationFederatedIdentityCredentialConfig
    */
    constructor(scope: Construct, id: string, config: ApplicationFederatedIdentityCredentialConfig);
    private _applicationObjectId?;
    get applicationObjectId(): string;
    set applicationObjectId(value: string);
    get applicationObjectIdInput(): string | undefined;
    private _audiences?;
    get audiences(): string[];
    set audiences(value: string[]);
    get audiencesInput(): string[] | undefined;
    get credentialId(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get id(): string;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    get issuerInput(): string | undefined;
    private _subject?;
    get subject(): string;
    set subject(value: string);
    get subjectInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApplicationFederatedIdentityCredentialTimeoutsOutputReference;
    putTimeouts(value: ApplicationFederatedIdentityCredentialTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApplicationFederatedIdentityCredentialTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
