import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApplicationPreAuthorizedConfig extends cdktf.TerraformMetaArguments {
    /**
    * The object ID of the application to which this pre-authorized application should be added
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_pre_authorized#application_object_id ApplicationPreAuthorized#application_object_id}
    */
    readonly applicationObjectId: string;
    /**
    * The application ID of the pre-authorized application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_pre_authorized#authorized_app_id ApplicationPreAuthorized#authorized_app_id}
    */
    readonly authorizedAppId: string;
    /**
    * The IDs of the permission scopes required by the pre-authorized application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_pre_authorized#permission_ids ApplicationPreAuthorized#permission_ids}
    */
    readonly permissionIds: string[];
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_pre_authorized#timeouts ApplicationPreAuthorized#timeouts}
    */
    readonly timeouts?: ApplicationPreAuthorizedTimeouts;
}
export interface ApplicationPreAuthorizedTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_pre_authorized#create ApplicationPreAuthorized#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_pre_authorized#delete ApplicationPreAuthorized#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_pre_authorized#read ApplicationPreAuthorized#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/application_pre_authorized#update ApplicationPreAuthorized#update}
    */
    readonly update?: string;
}
export declare function applicationPreAuthorizedTimeoutsToTerraform(struct?: ApplicationPreAuthorizedTimeoutsOutputReference | ApplicationPreAuthorizedTimeouts | cdktf.IResolvable): any;
export declare class ApplicationPreAuthorizedTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationPreAuthorizedTimeouts | undefined;
    set internalValue(value: ApplicationPreAuthorizedTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/r/application_pre_authorized azuread_application_pre_authorized}
*/
export declare class ApplicationPreAuthorized extends cdktf.TerraformResource {
    static readonly tfResourceType = "azuread_application_pre_authorized";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/application_pre_authorized azuread_application_pre_authorized} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApplicationPreAuthorizedConfig
    */
    constructor(scope: Construct, id: string, config: ApplicationPreAuthorizedConfig);
    private _applicationObjectId?;
    get applicationObjectId(): string;
    set applicationObjectId(value: string);
    get applicationObjectIdInput(): string | undefined;
    private _authorizedAppId?;
    get authorizedAppId(): string;
    set authorizedAppId(value: string);
    get authorizedAppIdInput(): string | undefined;
    get id(): string;
    private _permissionIds?;
    get permissionIds(): string[];
    set permissionIds(value: string[]);
    get permissionIdsInput(): string[] | undefined;
    private _timeouts;
    get timeouts(): ApplicationPreAuthorizedTimeoutsOutputReference;
    putTimeouts(value: ApplicationPreAuthorizedTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApplicationPreAuthorizedTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
