"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Application = exports.ApplicationWebOutputReference = exports.applicationWebToTerraform = exports.ApplicationWebImplicitGrantOutputReference = exports.applicationWebImplicitGrantToTerraform = exports.ApplicationTimeoutsOutputReference = exports.applicationTimeoutsToTerraform = exports.ApplicationSinglePageApplicationOutputReference = exports.applicationSinglePageApplicationToTerraform = exports.applicationRequiredResourceAccessToTerraform = exports.applicationRequiredResourceAccessResourceAccessToTerraform = exports.ApplicationPublicClientOutputReference = exports.applicationPublicClientToTerraform = exports.ApplicationOptionalClaimsOutputReference = exports.applicationOptionalClaimsToTerraform = exports.applicationOptionalClaimsSaml2TokenToTerraform = exports.applicationOptionalClaimsIdTokenToTerraform = exports.applicationOptionalClaimsAccessTokenToTerraform = exports.applicationFeatureTagsToTerraform = exports.applicationAppRoleToTerraform = exports.ApplicationApiOutputReference = exports.applicationApiToTerraform = exports.applicationApiOauth2PermissionScopeToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function applicationApiOauth2PermissionScopeToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        admin_consent_description: cdktf.stringToTerraform(struct.adminConsentDescription),
        admin_consent_display_name: cdktf.stringToTerraform(struct.adminConsentDisplayName),
        enabled: cdktf.booleanToTerraform(struct.enabled),
        id: cdktf.stringToTerraform(struct.id),
        type: cdktf.stringToTerraform(struct.type),
        user_consent_description: cdktf.stringToTerraform(struct.userConsentDescription),
        user_consent_display_name: cdktf.stringToTerraform(struct.userConsentDisplayName),
        value: cdktf.stringToTerraform(struct.value),
    };
}
exports.applicationApiOauth2PermissionScopeToTerraform = applicationApiOauth2PermissionScopeToTerraform;
function applicationApiToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        known_client_applications: cdktf.listMapper(cdktf.stringToTerraform)(struct.knownClientApplications),
        mapped_claims_enabled: cdktf.booleanToTerraform(struct.mappedClaimsEnabled),
        requested_access_token_version: cdktf.numberToTerraform(struct.requestedAccessTokenVersion),
        oauth2_permission_scope: cdktf.listMapper(applicationApiOauth2PermissionScopeToTerraform)(struct.oauth2PermissionScope),
    };
}
exports.applicationApiToTerraform = applicationApiToTerraform;
class ApplicationApiOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._knownClientApplications !== undefined) {
            hasAnyValues = true;
            internalValueResult.knownClientApplications = this._knownClientApplications;
        }
        if (this._mappedClaimsEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.mappedClaimsEnabled = this._mappedClaimsEnabled;
        }
        if (this._requestedAccessTokenVersion !== undefined) {
            hasAnyValues = true;
            internalValueResult.requestedAccessTokenVersion = this._requestedAccessTokenVersion;
        }
        if (this._oauth2PermissionScope !== undefined) {
            hasAnyValues = true;
            internalValueResult.oauth2PermissionScope = this._oauth2PermissionScope;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._knownClientApplications = undefined;
            this._mappedClaimsEnabled = undefined;
            this._requestedAccessTokenVersion = undefined;
            this._oauth2PermissionScope = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._knownClientApplications = value.knownClientApplications;
            this._mappedClaimsEnabled = value.mappedClaimsEnabled;
            this._requestedAccessTokenVersion = value.requestedAccessTokenVersion;
            this._oauth2PermissionScope = value.oauth2PermissionScope;
        }
    }
    get knownClientApplications() {
        return cdktf.Fn.tolist(this.getListAttribute('known_client_applications'));
    }
    set knownClientApplications(value) {
        this._knownClientApplications = value;
    }
    resetKnownClientApplications() {
        this._knownClientApplications = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get knownClientApplicationsInput() {
        return this._knownClientApplications;
    }
    get mappedClaimsEnabled() {
        return this.getBooleanAttribute('mapped_claims_enabled');
    }
    set mappedClaimsEnabled(value) {
        this._mappedClaimsEnabled = value;
    }
    resetMappedClaimsEnabled() {
        this._mappedClaimsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mappedClaimsEnabledInput() {
        return this._mappedClaimsEnabled;
    }
    get requestedAccessTokenVersion() {
        return this.getNumberAttribute('requested_access_token_version');
    }
    set requestedAccessTokenVersion(value) {
        this._requestedAccessTokenVersion = value;
    }
    resetRequestedAccessTokenVersion() {
        this._requestedAccessTokenVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestedAccessTokenVersionInput() {
        return this._requestedAccessTokenVersion;
    }
    get oauth2PermissionScope() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('oauth2_permission_scope')));
    }
    set oauth2PermissionScope(value) {
        this._oauth2PermissionScope = value;
    }
    resetOauth2PermissionScope() {
        this._oauth2PermissionScope = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauth2PermissionScopeInput() {
        return this._oauth2PermissionScope;
    }
}
exports.ApplicationApiOutputReference = ApplicationApiOutputReference;
_a = JSII_RTTI_SYMBOL_1;
ApplicationApiOutputReference[_a] = { fqn: "@cdktf/provider-azuread.ApplicationApiOutputReference", version: "0.4.17" };
function applicationAppRoleToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_member_types: cdktf.listMapper(cdktf.stringToTerraform)(struct.allowedMemberTypes),
        description: cdktf.stringToTerraform(struct.description),
        display_name: cdktf.stringToTerraform(struct.displayName),
        enabled: cdktf.booleanToTerraform(struct.enabled),
        id: cdktf.stringToTerraform(struct.id),
        value: cdktf.stringToTerraform(struct.value),
    };
}
exports.applicationAppRoleToTerraform = applicationAppRoleToTerraform;
function applicationFeatureTagsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        custom_single_sign_on: cdktf.booleanToTerraform(struct.customSingleSignOn),
        enterprise: cdktf.booleanToTerraform(struct.enterprise),
        gallery: cdktf.booleanToTerraform(struct.gallery),
        hide: cdktf.booleanToTerraform(struct.hide),
    };
}
exports.applicationFeatureTagsToTerraform = applicationFeatureTagsToTerraform;
function applicationOptionalClaimsAccessTokenToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        additional_properties: cdktf.listMapper(cdktf.stringToTerraform)(struct.additionalProperties),
        essential: cdktf.booleanToTerraform(struct.essential),
        name: cdktf.stringToTerraform(struct.name),
        source: cdktf.stringToTerraform(struct.source),
    };
}
exports.applicationOptionalClaimsAccessTokenToTerraform = applicationOptionalClaimsAccessTokenToTerraform;
function applicationOptionalClaimsIdTokenToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        additional_properties: cdktf.listMapper(cdktf.stringToTerraform)(struct.additionalProperties),
        essential: cdktf.booleanToTerraform(struct.essential),
        name: cdktf.stringToTerraform(struct.name),
        source: cdktf.stringToTerraform(struct.source),
    };
}
exports.applicationOptionalClaimsIdTokenToTerraform = applicationOptionalClaimsIdTokenToTerraform;
function applicationOptionalClaimsSaml2TokenToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        additional_properties: cdktf.listMapper(cdktf.stringToTerraform)(struct.additionalProperties),
        essential: cdktf.booleanToTerraform(struct.essential),
        name: cdktf.stringToTerraform(struct.name),
        source: cdktf.stringToTerraform(struct.source),
    };
}
exports.applicationOptionalClaimsSaml2TokenToTerraform = applicationOptionalClaimsSaml2TokenToTerraform;
function applicationOptionalClaimsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        access_token: cdktf.listMapper(applicationOptionalClaimsAccessTokenToTerraform)(struct.accessToken),
        id_token: cdktf.listMapper(applicationOptionalClaimsIdTokenToTerraform)(struct.idToken),
        saml2_token: cdktf.listMapper(applicationOptionalClaimsSaml2TokenToTerraform)(struct.saml2Token),
    };
}
exports.applicationOptionalClaimsToTerraform = applicationOptionalClaimsToTerraform;
class ApplicationOptionalClaimsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._accessToken !== undefined) {
            hasAnyValues = true;
            internalValueResult.accessToken = this._accessToken;
        }
        if (this._idToken !== undefined) {
            hasAnyValues = true;
            internalValueResult.idToken = this._idToken;
        }
        if (this._saml2Token !== undefined) {
            hasAnyValues = true;
            internalValueResult.saml2Token = this._saml2Token;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._accessToken = undefined;
            this._idToken = undefined;
            this._saml2Token = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._accessToken = value.accessToken;
            this._idToken = value.idToken;
            this._saml2Token = value.saml2Token;
        }
    }
    get accessToken() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('access_token');
    }
    set accessToken(value) {
        this._accessToken = value;
    }
    resetAccessToken() {
        this._accessToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accessTokenInput() {
        return this._accessToken;
    }
    get idToken() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('id_token');
    }
    set idToken(value) {
        this._idToken = value;
    }
    resetIdToken() {
        this._idToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idTokenInput() {
        return this._idToken;
    }
    get saml2Token() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('saml2_token');
    }
    set saml2Token(value) {
        this._saml2Token = value;
    }
    resetSaml2Token() {
        this._saml2Token = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2TokenInput() {
        return this._saml2Token;
    }
}
exports.ApplicationOptionalClaimsOutputReference = ApplicationOptionalClaimsOutputReference;
_b = JSII_RTTI_SYMBOL_1;
ApplicationOptionalClaimsOutputReference[_b] = { fqn: "@cdktf/provider-azuread.ApplicationOptionalClaimsOutputReference", version: "0.4.17" };
function applicationPublicClientToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        redirect_uris: cdktf.listMapper(cdktf.stringToTerraform)(struct.redirectUris),
    };
}
exports.applicationPublicClientToTerraform = applicationPublicClientToTerraform;
class ApplicationPublicClientOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._redirectUris !== undefined) {
            hasAnyValues = true;
            internalValueResult.redirectUris = this._redirectUris;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._redirectUris = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._redirectUris = value.redirectUris;
        }
    }
    get redirectUris() {
        return cdktf.Fn.tolist(this.getListAttribute('redirect_uris'));
    }
    set redirectUris(value) {
        this._redirectUris = value;
    }
    resetRedirectUris() {
        this._redirectUris = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get redirectUrisInput() {
        return this._redirectUris;
    }
}
exports.ApplicationPublicClientOutputReference = ApplicationPublicClientOutputReference;
_c = JSII_RTTI_SYMBOL_1;
ApplicationPublicClientOutputReference[_c] = { fqn: "@cdktf/provider-azuread.ApplicationPublicClientOutputReference", version: "0.4.17" };
function applicationRequiredResourceAccessResourceAccessToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        id: cdktf.stringToTerraform(struct.id),
        type: cdktf.stringToTerraform(struct.type),
    };
}
exports.applicationRequiredResourceAccessResourceAccessToTerraform = applicationRequiredResourceAccessResourceAccessToTerraform;
function applicationRequiredResourceAccessToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        resource_app_id: cdktf.stringToTerraform(struct.resourceAppId),
        resource_access: cdktf.listMapper(applicationRequiredResourceAccessResourceAccessToTerraform)(struct.resourceAccess),
    };
}
exports.applicationRequiredResourceAccessToTerraform = applicationRequiredResourceAccessToTerraform;
function applicationSinglePageApplicationToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        redirect_uris: cdktf.listMapper(cdktf.stringToTerraform)(struct.redirectUris),
    };
}
exports.applicationSinglePageApplicationToTerraform = applicationSinglePageApplicationToTerraform;
class ApplicationSinglePageApplicationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._redirectUris !== undefined) {
            hasAnyValues = true;
            internalValueResult.redirectUris = this._redirectUris;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._redirectUris = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._redirectUris = value.redirectUris;
        }
    }
    get redirectUris() {
        return cdktf.Fn.tolist(this.getListAttribute('redirect_uris'));
    }
    set redirectUris(value) {
        this._redirectUris = value;
    }
    resetRedirectUris() {
        this._redirectUris = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get redirectUrisInput() {
        return this._redirectUris;
    }
}
exports.ApplicationSinglePageApplicationOutputReference = ApplicationSinglePageApplicationOutputReference;
_d = JSII_RTTI_SYMBOL_1;
ApplicationSinglePageApplicationOutputReference[_d] = { fqn: "@cdktf/provider-azuread.ApplicationSinglePageApplicationOutputReference", version: "0.4.17" };
function applicationTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.applicationTimeoutsToTerraform = applicationTimeoutsToTerraform;
class ApplicationTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.ApplicationTimeoutsOutputReference = ApplicationTimeoutsOutputReference;
_e = JSII_RTTI_SYMBOL_1;
ApplicationTimeoutsOutputReference[_e] = { fqn: "@cdktf/provider-azuread.ApplicationTimeoutsOutputReference", version: "0.4.17" };
function applicationWebImplicitGrantToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        access_token_issuance_enabled: cdktf.booleanToTerraform(struct.accessTokenIssuanceEnabled),
        id_token_issuance_enabled: cdktf.booleanToTerraform(struct.idTokenIssuanceEnabled),
    };
}
exports.applicationWebImplicitGrantToTerraform = applicationWebImplicitGrantToTerraform;
class ApplicationWebImplicitGrantOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._accessTokenIssuanceEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.accessTokenIssuanceEnabled = this._accessTokenIssuanceEnabled;
        }
        if (this._idTokenIssuanceEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.idTokenIssuanceEnabled = this._idTokenIssuanceEnabled;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._accessTokenIssuanceEnabled = undefined;
            this._idTokenIssuanceEnabled = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._accessTokenIssuanceEnabled = value.accessTokenIssuanceEnabled;
            this._idTokenIssuanceEnabled = value.idTokenIssuanceEnabled;
        }
    }
    get accessTokenIssuanceEnabled() {
        return this.getBooleanAttribute('access_token_issuance_enabled');
    }
    set accessTokenIssuanceEnabled(value) {
        this._accessTokenIssuanceEnabled = value;
    }
    resetAccessTokenIssuanceEnabled() {
        this._accessTokenIssuanceEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accessTokenIssuanceEnabledInput() {
        return this._accessTokenIssuanceEnabled;
    }
    get idTokenIssuanceEnabled() {
        return this.getBooleanAttribute('id_token_issuance_enabled');
    }
    set idTokenIssuanceEnabled(value) {
        this._idTokenIssuanceEnabled = value;
    }
    resetIdTokenIssuanceEnabled() {
        this._idTokenIssuanceEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idTokenIssuanceEnabledInput() {
        return this._idTokenIssuanceEnabled;
    }
}
exports.ApplicationWebImplicitGrantOutputReference = ApplicationWebImplicitGrantOutputReference;
_f = JSII_RTTI_SYMBOL_1;
ApplicationWebImplicitGrantOutputReference[_f] = { fqn: "@cdktf/provider-azuread.ApplicationWebImplicitGrantOutputReference", version: "0.4.17" };
function applicationWebToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        homepage_url: cdktf.stringToTerraform(struct.homepageUrl),
        logout_url: cdktf.stringToTerraform(struct.logoutUrl),
        redirect_uris: cdktf.listMapper(cdktf.stringToTerraform)(struct.redirectUris),
        implicit_grant: applicationWebImplicitGrantToTerraform(struct.implicitGrant),
    };
}
exports.applicationWebToTerraform = applicationWebToTerraform;
class ApplicationWebOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // implicit_grant - computed: false, optional: true, required: false
        this._implicitGrant = new ApplicationWebImplicitGrantOutputReference(this, "implicit_grant");
    }
    get internalValue() {
        var _j, _k;
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._homepageUrl !== undefined) {
            hasAnyValues = true;
            internalValueResult.homepageUrl = this._homepageUrl;
        }
        if (this._logoutUrl !== undefined) {
            hasAnyValues = true;
            internalValueResult.logoutUrl = this._logoutUrl;
        }
        if (this._redirectUris !== undefined) {
            hasAnyValues = true;
            internalValueResult.redirectUris = this._redirectUris;
        }
        if (((_j = this._implicitGrant) === null || _j === void 0 ? void 0 : _j.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.implicitGrant = (_k = this._implicitGrant) === null || _k === void 0 ? void 0 : _k.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._homepageUrl = undefined;
            this._logoutUrl = undefined;
            this._redirectUris = undefined;
            this._implicitGrant.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._homepageUrl = value.homepageUrl;
            this._logoutUrl = value.logoutUrl;
            this._redirectUris = value.redirectUris;
            this._implicitGrant.internalValue = value.implicitGrant;
        }
    }
    get homepageUrl() {
        return this.getStringAttribute('homepage_url');
    }
    set homepageUrl(value) {
        this._homepageUrl = value;
    }
    resetHomepageUrl() {
        this._homepageUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get homepageUrlInput() {
        return this._homepageUrl;
    }
    get logoutUrl() {
        return this.getStringAttribute('logout_url');
    }
    set logoutUrl(value) {
        this._logoutUrl = value;
    }
    resetLogoutUrl() {
        this._logoutUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get logoutUrlInput() {
        return this._logoutUrl;
    }
    get redirectUris() {
        return cdktf.Fn.tolist(this.getListAttribute('redirect_uris'));
    }
    set redirectUris(value) {
        this._redirectUris = value;
    }
    resetRedirectUris() {
        this._redirectUris = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get redirectUrisInput() {
        return this._redirectUris;
    }
    get implicitGrant() {
        return this._implicitGrant;
    }
    putImplicitGrant(value) {
        this._implicitGrant.internalValue = value;
    }
    resetImplicitGrant() {
        this._implicitGrant.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get implicitGrantInput() {
        return this._implicitGrant.internalValue;
    }
}
exports.ApplicationWebOutputReference = ApplicationWebOutputReference;
_g = JSII_RTTI_SYMBOL_1;
ApplicationWebOutputReference[_g] = { fqn: "@cdktf/provider-azuread.ApplicationWebOutputReference", version: "0.4.17" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/r/application azuread_application}
*/
class Application extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/application azuread_application} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApplicationConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azuread_application',
            terraformGeneratorMetadata: {
                providerName: 'azuread',
                providerVersion: '2.20.0',
                providerVersionConstraint: '~> 2.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // api - computed: false, optional: true, required: false
        this._api = new ApplicationApiOutputReference(this, "api");
        // optional_claims - computed: false, optional: true, required: false
        this._optionalClaims = new ApplicationOptionalClaimsOutputReference(this, "optional_claims");
        // public_client - computed: false, optional: true, required: false
        this._publicClient = new ApplicationPublicClientOutputReference(this, "public_client");
        // single_page_application - computed: false, optional: true, required: false
        this._singlePageApplication = new ApplicationSinglePageApplicationOutputReference(this, "single_page_application");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new ApplicationTimeoutsOutputReference(this, "timeouts");
        // web - computed: false, optional: true, required: false
        this._web = new ApplicationWebOutputReference(this, "web");
        this._deviceOnlyAuthEnabled = config.deviceOnlyAuthEnabled;
        this._displayName = config.displayName;
        this._fallbackPublicClientEnabled = config.fallbackPublicClientEnabled;
        this._groupMembershipClaims = config.groupMembershipClaims;
        this._identifierUris = config.identifierUris;
        this._logoImage = config.logoImage;
        this._marketingUrl = config.marketingUrl;
        this._oauth2PostResponseRequired = config.oauth2PostResponseRequired;
        this._owners = config.owners;
        this._preventDuplicateNames = config.preventDuplicateNames;
        this._privacyStatementUrl = config.privacyStatementUrl;
        this._signInAudience = config.signInAudience;
        this._supportUrl = config.supportUrl;
        this._tags = config.tags;
        this._templateId = config.templateId;
        this._termsOfServiceUrl = config.termsOfServiceUrl;
        this._api.internalValue = config.api;
        this._appRole = config.appRole;
        this._featureTags = config.featureTags;
        this._optionalClaims.internalValue = config.optionalClaims;
        this._publicClient.internalValue = config.publicClient;
        this._requiredResourceAccess = config.requiredResourceAccess;
        this._singlePageApplication.internalValue = config.singlePageApplication;
        this._timeouts.internalValue = config.timeouts;
        this._web.internalValue = config.web;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // app_role_ids - computed: true, optional: false, required: false
    appRoleIds(key) {
        return new cdktf.StringMap(this, 'app_role_ids').lookup(key);
    }
    // application_id - computed: true, optional: false, required: false
    get applicationId() {
        return this.getStringAttribute('application_id');
    }
    get deviceOnlyAuthEnabled() {
        return this.getBooleanAttribute('device_only_auth_enabled');
    }
    set deviceOnlyAuthEnabled(value) {
        this._deviceOnlyAuthEnabled = value;
    }
    resetDeviceOnlyAuthEnabled() {
        this._deviceOnlyAuthEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deviceOnlyAuthEnabledInput() {
        return this._deviceOnlyAuthEnabled;
    }
    // disabled_by_microsoft - computed: true, optional: false, required: false
    get disabledByMicrosoft() {
        return this.getStringAttribute('disabled_by_microsoft');
    }
    get displayName() {
        return this.getStringAttribute('display_name');
    }
    set displayName(value) {
        this._displayName = value;
    }
    // Temporarily expose input value. Use with caution.
    get displayNameInput() {
        return this._displayName;
    }
    get fallbackPublicClientEnabled() {
        return this.getBooleanAttribute('fallback_public_client_enabled');
    }
    set fallbackPublicClientEnabled(value) {
        this._fallbackPublicClientEnabled = value;
    }
    resetFallbackPublicClientEnabled() {
        this._fallbackPublicClientEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fallbackPublicClientEnabledInput() {
        return this._fallbackPublicClientEnabled;
    }
    get groupMembershipClaims() {
        return cdktf.Fn.tolist(this.getListAttribute('group_membership_claims'));
    }
    set groupMembershipClaims(value) {
        this._groupMembershipClaims = value;
    }
    resetGroupMembershipClaims() {
        this._groupMembershipClaims = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupMembershipClaimsInput() {
        return this._groupMembershipClaims;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get identifierUris() {
        return cdktf.Fn.tolist(this.getListAttribute('identifier_uris'));
    }
    set identifierUris(value) {
        this._identifierUris = value;
    }
    resetIdentifierUris() {
        this._identifierUris = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get identifierUrisInput() {
        return this._identifierUris;
    }
    get logoImage() {
        return this.getStringAttribute('logo_image');
    }
    set logoImage(value) {
        this._logoImage = value;
    }
    resetLogoImage() {
        this._logoImage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get logoImageInput() {
        return this._logoImage;
    }
    // logo_url - computed: true, optional: false, required: false
    get logoUrl() {
        return this.getStringAttribute('logo_url');
    }
    get marketingUrl() {
        return this.getStringAttribute('marketing_url');
    }
    set marketingUrl(value) {
        this._marketingUrl = value;
    }
    resetMarketingUrl() {
        this._marketingUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get marketingUrlInput() {
        return this._marketingUrl;
    }
    // oauth2_permission_scope_ids - computed: true, optional: false, required: false
    oauth2PermissionScopeIds(key) {
        return new cdktf.StringMap(this, 'oauth2_permission_scope_ids').lookup(key);
    }
    get oauth2PostResponseRequired() {
        return this.getBooleanAttribute('oauth2_post_response_required');
    }
    set oauth2PostResponseRequired(value) {
        this._oauth2PostResponseRequired = value;
    }
    resetOauth2PostResponseRequired() {
        this._oauth2PostResponseRequired = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauth2PostResponseRequiredInput() {
        return this._oauth2PostResponseRequired;
    }
    // object_id - computed: true, optional: false, required: false
    get objectId() {
        return this.getStringAttribute('object_id');
    }
    get owners() {
        return cdktf.Fn.tolist(this.getListAttribute('owners'));
    }
    set owners(value) {
        this._owners = value;
    }
    resetOwners() {
        this._owners = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ownersInput() {
        return this._owners;
    }
    get preventDuplicateNames() {
        return this.getBooleanAttribute('prevent_duplicate_names');
    }
    set preventDuplicateNames(value) {
        this._preventDuplicateNames = value;
    }
    resetPreventDuplicateNames() {
        this._preventDuplicateNames = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get preventDuplicateNamesInput() {
        return this._preventDuplicateNames;
    }
    get privacyStatementUrl() {
        return this.getStringAttribute('privacy_statement_url');
    }
    set privacyStatementUrl(value) {
        this._privacyStatementUrl = value;
    }
    resetPrivacyStatementUrl() {
        this._privacyStatementUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privacyStatementUrlInput() {
        return this._privacyStatementUrl;
    }
    // publisher_domain - computed: true, optional: false, required: false
    get publisherDomain() {
        return this.getStringAttribute('publisher_domain');
    }
    get signInAudience() {
        return this.getStringAttribute('sign_in_audience');
    }
    set signInAudience(value) {
        this._signInAudience = value;
    }
    resetSignInAudience() {
        this._signInAudience = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get signInAudienceInput() {
        return this._signInAudience;
    }
    get supportUrl() {
        return this.getStringAttribute('support_url');
    }
    set supportUrl(value) {
        this._supportUrl = value;
    }
    resetSupportUrl() {
        this._supportUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get supportUrlInput() {
        return this._supportUrl;
    }
    get tags() {
        return cdktf.Fn.tolist(this.getListAttribute('tags'));
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get templateId() {
        return this.getStringAttribute('template_id');
    }
    set templateId(value) {
        this._templateId = value;
    }
    resetTemplateId() {
        this._templateId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get templateIdInput() {
        return this._templateId;
    }
    get termsOfServiceUrl() {
        return this.getStringAttribute('terms_of_service_url');
    }
    set termsOfServiceUrl(value) {
        this._termsOfServiceUrl = value;
    }
    resetTermsOfServiceUrl() {
        this._termsOfServiceUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get termsOfServiceUrlInput() {
        return this._termsOfServiceUrl;
    }
    get api() {
        return this._api;
    }
    putApi(value) {
        this._api.internalValue = value;
    }
    resetApi() {
        this._api.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get apiInput() {
        return this._api.internalValue;
    }
    get appRole() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('app_role')));
    }
    set appRole(value) {
        this._appRole = value;
    }
    resetAppRole() {
        this._appRole = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get appRoleInput() {
        return this._appRole;
    }
    get featureTags() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('feature_tags');
    }
    set featureTags(value) {
        this._featureTags = value;
    }
    resetFeatureTags() {
        this._featureTags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get featureTagsInput() {
        return this._featureTags;
    }
    get optionalClaims() {
        return this._optionalClaims;
    }
    putOptionalClaims(value) {
        this._optionalClaims.internalValue = value;
    }
    resetOptionalClaims() {
        this._optionalClaims.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get optionalClaimsInput() {
        return this._optionalClaims.internalValue;
    }
    get publicClient() {
        return this._publicClient;
    }
    putPublicClient(value) {
        this._publicClient.internalValue = value;
    }
    resetPublicClient() {
        this._publicClient.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get publicClientInput() {
        return this._publicClient.internalValue;
    }
    get requiredResourceAccess() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('required_resource_access')));
    }
    set requiredResourceAccess(value) {
        this._requiredResourceAccess = value;
    }
    resetRequiredResourceAccess() {
        this._requiredResourceAccess = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requiredResourceAccessInput() {
        return this._requiredResourceAccess;
    }
    get singlePageApplication() {
        return this._singlePageApplication;
    }
    putSinglePageApplication(value) {
        this._singlePageApplication.internalValue = value;
    }
    resetSinglePageApplication() {
        this._singlePageApplication.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get singlePageApplicationInput() {
        return this._singlePageApplication.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    get web() {
        return this._web;
    }
    putWeb(value) {
        this._web.internalValue = value;
    }
    resetWeb() {
        this._web.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get webInput() {
        return this._web.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            device_only_auth_enabled: cdktf.booleanToTerraform(this._deviceOnlyAuthEnabled),
            display_name: cdktf.stringToTerraform(this._displayName),
            fallback_public_client_enabled: cdktf.booleanToTerraform(this._fallbackPublicClientEnabled),
            group_membership_claims: cdktf.listMapper(cdktf.stringToTerraform)(this._groupMembershipClaims),
            identifier_uris: cdktf.listMapper(cdktf.stringToTerraform)(this._identifierUris),
            logo_image: cdktf.stringToTerraform(this._logoImage),
            marketing_url: cdktf.stringToTerraform(this._marketingUrl),
            oauth2_post_response_required: cdktf.booleanToTerraform(this._oauth2PostResponseRequired),
            owners: cdktf.listMapper(cdktf.stringToTerraform)(this._owners),
            prevent_duplicate_names: cdktf.booleanToTerraform(this._preventDuplicateNames),
            privacy_statement_url: cdktf.stringToTerraform(this._privacyStatementUrl),
            sign_in_audience: cdktf.stringToTerraform(this._signInAudience),
            support_url: cdktf.stringToTerraform(this._supportUrl),
            tags: cdktf.listMapper(cdktf.stringToTerraform)(this._tags),
            template_id: cdktf.stringToTerraform(this._templateId),
            terms_of_service_url: cdktf.stringToTerraform(this._termsOfServiceUrl),
            api: applicationApiToTerraform(this._api.internalValue),
            app_role: cdktf.listMapper(applicationAppRoleToTerraform)(this._appRole),
            feature_tags: cdktf.listMapper(applicationFeatureTagsToTerraform)(this._featureTags),
            optional_claims: applicationOptionalClaimsToTerraform(this._optionalClaims.internalValue),
            public_client: applicationPublicClientToTerraform(this._publicClient.internalValue),
            required_resource_access: cdktf.listMapper(applicationRequiredResourceAccessToTerraform)(this._requiredResourceAccess),
            single_page_application: applicationSinglePageApplicationToTerraform(this._singlePageApplication.internalValue),
            timeouts: applicationTimeoutsToTerraform(this._timeouts.internalValue),
            web: applicationWebToTerraform(this._web.internalValue),
        };
    }
}
exports.Application = Application;
_h = JSII_RTTI_SYMBOL_1;
Application[_h] = { fqn: "@cdktf/provider-azuread.Application", version: "0.4.17" };
// =================
// STATIC PROPERTIES
// =================
Application.tfResourceType = "azuread_application";
//# sourceMappingURL=data:application/json;base64,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