import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AzureadProviderConfig {
    /**
    * Base64 encoded PKCS#12 certificate bundle to use when authenticating as a Service Principal using a Client Certificate
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#client_certificate AzureadProvider#client_certificate}
    */
    readonly clientCertificate?: string;
    /**
    * The password to decrypt the Client Certificate. For use when authenticating as a Service Principal using a Client Certificate
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#client_certificate_password AzureadProvider#client_certificate_password}
    */
    readonly clientCertificatePassword?: string;
    /**
    * The path to the Client Certificate associated with the Service Principal for use when authenticating as a Service Principal using a Client Certificate
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#client_certificate_path AzureadProvider#client_certificate_path}
    */
    readonly clientCertificatePath?: string;
    /**
    * The Client ID which should be used for service principal authentication
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#client_id AzureadProvider#client_id}
    */
    readonly clientId?: string;
    /**
    * The application password to use when authenticating as a Service Principal using a Client Secret
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#client_secret AzureadProvider#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * Disable the Terraform Partner ID, which is used if a custom `partner_id` isn't specified
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#disable_terraform_partner_id AzureadProvider#disable_terraform_partner_id}
    */
    readonly disableTerraformPartnerId?: boolean | cdktf.IResolvable;
    /**
    * The cloud environment which should be used. Possible values are: `global` (also `public`), `usgovernmentl4` (also `usgovernment`), `usgovernmentl5` (also `dod`), and `china`. Defaults to `global`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#environment AzureadProvider#environment}
    */
    readonly environment?: string;
    /**
    * The path to a custom endpoint for Managed Identity - in most circumstances this should be detected automatically
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#msi_endpoint AzureadProvider#msi_endpoint}
    */
    readonly msiEndpoint?: string;
    /**
    * A GUID/UUID that is registered with Microsoft to facilitate partner resource usage attribution
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#partner_id AzureadProvider#partner_id}
    */
    readonly partnerId?: string;
    /**
    * The Tenant ID which should be used. Works with all authentication methods except Managed Identity
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#tenant_id AzureadProvider#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * Allow Azure CLI to be used for Authentication
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#use_cli AzureadProvider#use_cli}
    */
    readonly useCli?: boolean | cdktf.IResolvable;
    /**
    * Allow Managed Identity to be used for Authentication
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#use_msi AzureadProvider#use_msi}
    */
    readonly useMsi?: boolean | cdktf.IResolvable;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread#alias AzureadProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread azuread}
*/
export declare class AzureadProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "azuread";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread azuread} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AzureadProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: AzureadProviderConfig);
    private _clientCertificate?;
    get clientCertificate(): string | undefined;
    set clientCertificate(value: string | undefined);
    resetClientCertificate(): void;
    get clientCertificateInput(): string | undefined;
    private _clientCertificatePassword?;
    get clientCertificatePassword(): string | undefined;
    set clientCertificatePassword(value: string | undefined);
    resetClientCertificatePassword(): void;
    get clientCertificatePasswordInput(): string | undefined;
    private _clientCertificatePath?;
    get clientCertificatePath(): string | undefined;
    set clientCertificatePath(value: string | undefined);
    resetClientCertificatePath(): void;
    get clientCertificatePathInput(): string | undefined;
    private _clientId?;
    get clientId(): string | undefined;
    set clientId(value: string | undefined);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string | undefined;
    set clientSecret(value: string | undefined);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _disableTerraformPartnerId?;
    get disableTerraformPartnerId(): boolean | cdktf.IResolvable | undefined;
    set disableTerraformPartnerId(value: boolean | cdktf.IResolvable | undefined);
    resetDisableTerraformPartnerId(): void;
    get disableTerraformPartnerIdInput(): boolean | cdktf.IResolvable | undefined;
    private _environment?;
    get environment(): string | undefined;
    set environment(value: string | undefined);
    resetEnvironment(): void;
    get environmentInput(): string | undefined;
    private _msiEndpoint?;
    get msiEndpoint(): string | undefined;
    set msiEndpoint(value: string | undefined);
    resetMsiEndpoint(): void;
    get msiEndpointInput(): string | undefined;
    private _partnerId?;
    get partnerId(): string | undefined;
    set partnerId(value: string | undefined);
    resetPartnerId(): void;
    get partnerIdInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string | undefined;
    set tenantId(value: string | undefined);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _useCli?;
    get useCli(): boolean | cdktf.IResolvable | undefined;
    set useCli(value: boolean | cdktf.IResolvable | undefined);
    resetUseCli(): void;
    get useCliInput(): boolean | cdktf.IResolvable | undefined;
    private _useMsi?;
    get useMsi(): boolean | cdktf.IResolvable | undefined;
    set useMsi(value: boolean | cdktf.IResolvable | undefined);
    resetUseMsi(): void;
    get useMsiInput(): boolean | cdktf.IResolvable | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
