import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ClaimsMappingPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * A string collection containing a JSON string that defines the rules and settings for this policy
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/claims_mapping_policy#definition ClaimsMappingPolicy#definition}
    */
    readonly definition: string[];
    /**
    * Display name for this policy
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/claims_mapping_policy#display_name ClaimsMappingPolicy#display_name}
    */
    readonly displayName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/r/claims_mapping_policy azuread_claims_mapping_policy}
*/
export declare class ClaimsMappingPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azuread_claims_mapping_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/claims_mapping_policy azuread_claims_mapping_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ClaimsMappingPolicyConfig
    */
    constructor(scope: Construct, id: string, config: ClaimsMappingPolicyConfig);
    private _definition?;
    get definition(): string[];
    set definition(value: string[]);
    get definitionInput(): string[] | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get id(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
