import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzureadAdministrativeUnitConfig extends cdktf.TerraformMetaArguments {
    /**
    * The display name for the administrative unit
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/administrative_unit#display_name DataAzureadAdministrativeUnit#display_name}
    */
    readonly displayName?: string;
    /**
    * The object ID of the administrative unit
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/administrative_unit#object_id DataAzureadAdministrativeUnit#object_id}
    */
    readonly objectId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/administrative_unit#timeouts DataAzureadAdministrativeUnit#timeouts}
    */
    readonly timeouts?: DataAzureadAdministrativeUnitTimeouts;
}
export interface DataAzureadAdministrativeUnitTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/administrative_unit#create DataAzureadAdministrativeUnit#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/administrative_unit#delete DataAzureadAdministrativeUnit#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/administrative_unit#read DataAzureadAdministrativeUnit#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/administrative_unit#update DataAzureadAdministrativeUnit#update}
    */
    readonly update?: string;
}
export declare function dataAzureadAdministrativeUnitTimeoutsToTerraform(struct?: DataAzureadAdministrativeUnitTimeoutsOutputReference | DataAzureadAdministrativeUnitTimeouts | cdktf.IResolvable): any;
export declare class DataAzureadAdministrativeUnitTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzureadAdministrativeUnitTimeouts | undefined;
    set internalValue(value: DataAzureadAdministrativeUnitTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/d/administrative_unit azuread_administrative_unit}
*/
export declare class DataAzureadAdministrativeUnit extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azuread_administrative_unit";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/administrative_unit azuread_administrative_unit} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzureadAdministrativeUnitConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzureadAdministrativeUnitConfig);
    get description(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get id(): string;
    get members(): string[];
    private _objectId?;
    get objectId(): string;
    set objectId(value: string);
    resetObjectId(): void;
    get objectIdInput(): string | undefined;
    get visibility(): string;
    private _timeouts;
    get timeouts(): DataAzureadAdministrativeUnitTimeoutsOutputReference;
    putTimeouts(value: DataAzureadAdministrativeUnitTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzureadAdministrativeUnitTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
