import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzureadApplicationPublishedAppIdsConfig extends cdktf.TerraformMetaArguments {
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application_published_app_ids#timeouts DataAzureadApplicationPublishedAppIds#timeouts}
    */
    readonly timeouts?: DataAzureadApplicationPublishedAppIdsTimeouts;
}
export interface DataAzureadApplicationPublishedAppIdsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application_published_app_ids#read DataAzureadApplicationPublishedAppIds#read}
    */
    readonly read?: string;
}
export declare function dataAzureadApplicationPublishedAppIdsTimeoutsToTerraform(struct?: DataAzureadApplicationPublishedAppIdsTimeoutsOutputReference | DataAzureadApplicationPublishedAppIdsTimeouts | cdktf.IResolvable): any;
export declare class DataAzureadApplicationPublishedAppIdsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzureadApplicationPublishedAppIdsTimeouts | undefined;
    set internalValue(value: DataAzureadApplicationPublishedAppIdsTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/d/application_published_app_ids azuread_application_published_app_ids}
*/
export declare class DataAzureadApplicationPublishedAppIds extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azuread_application_published_app_ids";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/application_published_app_ids azuread_application_published_app_ids} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzureadApplicationPublishedAppIdsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzureadApplicationPublishedAppIdsConfig);
    get id(): string;
    result(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzureadApplicationPublishedAppIdsTimeoutsOutputReference;
    putTimeouts(value: DataAzureadApplicationPublishedAppIdsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzureadApplicationPublishedAppIdsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
