import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzureadApplicationTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * The display name for the application template
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application_template#display_name DataAzureadApplicationTemplate#display_name}
    */
    readonly displayName?: string;
    /**
    * The application template's ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application_template#template_id DataAzureadApplicationTemplate#template_id}
    */
    readonly templateId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application_template#timeouts DataAzureadApplicationTemplate#timeouts}
    */
    readonly timeouts?: DataAzureadApplicationTemplateTimeouts;
}
export interface DataAzureadApplicationTemplateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/application_template#read DataAzureadApplicationTemplate#read}
    */
    readonly read?: string;
}
export declare function dataAzureadApplicationTemplateTimeoutsToTerraform(struct?: DataAzureadApplicationTemplateTimeoutsOutputReference | DataAzureadApplicationTemplateTimeouts | cdktf.IResolvable): any;
export declare class DataAzureadApplicationTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzureadApplicationTemplateTimeouts | undefined;
    set internalValue(value: DataAzureadApplicationTemplateTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/d/application_template azuread_application_template}
*/
export declare class DataAzureadApplicationTemplate extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azuread_application_template";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/application_template azuread_application_template} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzureadApplicationTemplateConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzureadApplicationTemplateConfig);
    get categories(): string[];
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get homepageUrl(): string;
    get id(): string;
    get logoUrl(): string;
    get publisher(): string;
    get supportedProvisioningTypes(): string[];
    get supportedSingleSignOnModes(): string[];
    private _templateId?;
    get templateId(): string;
    set templateId(value: string);
    resetTemplateId(): void;
    get templateIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzureadApplicationTemplateTimeoutsOutputReference;
    putTimeouts(value: DataAzureadApplicationTemplateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzureadApplicationTemplateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
