import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzureadClientConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/client_config#timeouts DataAzureadClientConfig#timeouts}
    */
    readonly timeouts?: DataAzureadClientConfigTimeouts;
}
export interface DataAzureadClientConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/client_config#read DataAzureadClientConfig#read}
    */
    readonly read?: string;
}
export declare function dataAzureadClientConfigTimeoutsToTerraform(struct?: DataAzureadClientConfigTimeoutsOutputReference | DataAzureadClientConfigTimeouts | cdktf.IResolvable): any;
export declare class DataAzureadClientConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzureadClientConfigTimeouts | undefined;
    set internalValue(value: DataAzureadClientConfigTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/d/client_config azuread_client_config}
*/
export declare class DataAzureadClientConfig extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azuread_client_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/client_config azuread_client_config} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzureadClientConfigConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzureadClientConfigConfig);
    get clientId(): string;
    get id(): string;
    get objectId(): string;
    get tenantId(): string;
    private _timeouts;
    get timeouts(): DataAzureadClientConfigTimeoutsOutputReference;
    putTimeouts(value: DataAzureadClientConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzureadClientConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
