import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzureadGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * The display name for the group
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/group#display_name DataAzureadGroup#display_name}
    */
    readonly displayName?: string;
    /**
    * Whether the group is mail-enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/group#mail_enabled DataAzureadGroup#mail_enabled}
    */
    readonly mailEnabled?: boolean | cdktf.IResolvable;
    /**
    * The object ID of the group
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/group#object_id DataAzureadGroup#object_id}
    */
    readonly objectId?: string;
    /**
    * Whether the group is a security group
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/group#security_enabled DataAzureadGroup#security_enabled}
    */
    readonly securityEnabled?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/group#timeouts DataAzureadGroup#timeouts}
    */
    readonly timeouts?: DataAzureadGroupTimeouts;
}
export interface DataAzureadGroupDynamicMembership {
}
export declare function dataAzureadGroupDynamicMembershipToTerraform(struct?: DataAzureadGroupDynamicMembership): any;
export declare class DataAzureadGroupDynamicMembershipOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzureadGroupDynamicMembership | undefined;
    set internalValue(value: DataAzureadGroupDynamicMembership | undefined);
    get enabled(): cdktf.IResolvable;
    get rule(): string;
}
export declare class DataAzureadGroupDynamicMembershipList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzureadGroupDynamicMembershipOutputReference;
}
export interface DataAzureadGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/group#read DataAzureadGroup#read}
    */
    readonly read?: string;
}
export declare function dataAzureadGroupTimeoutsToTerraform(struct?: DataAzureadGroupTimeoutsOutputReference | DataAzureadGroupTimeouts | cdktf.IResolvable): any;
export declare class DataAzureadGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzureadGroupTimeouts | undefined;
    set internalValue(value: DataAzureadGroupTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/d/group azuread_group}
*/
export declare class DataAzureadGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azuread_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/group azuread_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzureadGroupConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzureadGroupConfig);
    get assignableToRole(): cdktf.IResolvable;
    get autoSubscribeNewMembers(): cdktf.IResolvable;
    get behaviors(): string[];
    get description(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _dynamicMembership;
    get dynamicMembership(): DataAzureadGroupDynamicMembershipList;
    get externalSendersAllowed(): cdktf.IResolvable;
    get hideFromAddressLists(): cdktf.IResolvable;
    get hideFromOutlookClients(): cdktf.IResolvable;
    get id(): string;
    get mail(): string;
    private _mailEnabled?;
    get mailEnabled(): boolean | cdktf.IResolvable;
    set mailEnabled(value: boolean | cdktf.IResolvable);
    resetMailEnabled(): void;
    get mailEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get mailNickname(): string;
    get members(): string[];
    private _objectId?;
    get objectId(): string;
    set objectId(value: string);
    resetObjectId(): void;
    get objectIdInput(): string | undefined;
    get onpremisesDomainName(): string;
    get onpremisesNetbiosName(): string;
    get onpremisesSamAccountName(): string;
    get onpremisesSecurityIdentifier(): string;
    get onpremisesSyncEnabled(): cdktf.IResolvable;
    get owners(): string[];
    get preferredLanguage(): string;
    get provisioningOptions(): string[];
    get proxyAddresses(): string[];
    private _securityEnabled?;
    get securityEnabled(): boolean | cdktf.IResolvable;
    set securityEnabled(value: boolean | cdktf.IResolvable);
    resetSecurityEnabled(): void;
    get securityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get theme(): string;
    get types(): string[];
    get visibility(): string;
    private _timeouts;
    get timeouts(): DataAzureadGroupTimeoutsOutputReference;
    putTimeouts(value: DataAzureadGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzureadGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
